#ifndef lint
static char sccsid[] = "@(#) setmode.c 5.1 89/02/20";
#endif
#define MS_DOS 0
#define UNIX 1
/*
 *	Module	:	mode
 *	Date	:	8705.20
 *	Author	:	Jeffrey A. Turner
 *	Purpose	:	Set cga video modes (0-6) when active Unix display
 *			is an mda.  Modified to support modes 7 and 8
 *			on Everex Edge.
 *
 *	Modifications:	dtlewis 8-16-1987 Changes to support mode 7 and to
 *			support Hercules operation on an Everex Edge.
 *			Hercules 720 x 348 (page 0) is referred to as
 *			mode 8 for this routine, and Hercules page 1 is
 *			referred to as mode 9.  Note that these are for
 *			convenience, and conflict with the PCjr mode
 *			assignments, which I presume to be non-reusable
 *			and obsolete.
 *
 *			Split modeset() off from the main routine to make
 *			it callable from any program.
 *
 *			Renamed the function to setmode().
 *
 *	Useage:		int setmode(modenumber)
 *			int modenumber
 *
 *	$Log$
 */

#include <stdio.h>
#if UNIX
#include <sys/types.h>
#include <sys/io_op.h>
#endif

extern	errno;

int	fd;

/* Define the mode register settings. */
unsigned char	creg[12] = {
	0x2c, 0x28, 0x2d, 0x2d, 0x2a, 0x2e, 0x1e, 0x2d, 0x0e, 0x8e, 0x2d, 0x2d
};
/* Define the Everex extended graphics register settings */
unsigned char	ext_graf_reg[12] = {
	0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x06, 0x06
};

unsigned char	params[192] = {
/*0*/	0x38, 0x28, 0x2d, 0x0a, 0x1f, 0x06, 0x19, 0x1c,   /* 40x25 b/w */
	0x02, 0x07, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00,

/*1*/	0x38, 0x28, 0x2d, 0x0a, 0x1f, 0x06, 0x19, 0x1c,   /* 40x25 color */
	0x02, 0x07, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00,

/*2*/	0x61, 0x50, 0x52, 0x0f, 0x19, 0x06, 0x19, 0x19,	  /* 80x25 b/w */
	0x02, 0x0d, 0x0b, 0x0c, 0x00, 0x00, 0x00, 0x00,

/*3*/	0x71, 0x50, 0x5a, 0x0a, 0x1f, 0x06, 0x19, 0x1c,	  /* 80x25 color */
	0x02, 0x07, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00,

/*4*/	0x38, 0x28, 0x2d, 0x0a, 0x7f, 0x06, 0x64, 0x70,	  /* 320x200 color */
	0x02, 0x01, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00,

/*5*/	0x38, 0x28, 0x2d, 0x0a, 0x7f, 0x06, 0x64, 0x70,	  /* 320x200 b/w */
	0x02, 0x01, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00,

/*6*/	0x38, 0x28, 0x2d, 0x0a, 0x7f, 0x06, 0x64, 0x70,	  /* 640x200 b/w */
	0x02, 0x01, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00,

/*7*/	0x61, 0x50, 0x52, 0x0f, 0x19, 0x06, 0x19, 0x19,	  /* mono */
	0x02, 0x0d, 0x0b, 0x0c, 0x00, 0x00, 0x00, 0x00,

/*8*/	0x36, 0x2d, 0x2e, 0x07, 0x5a, 0x02, 0x57, 0x57,   /* Hercules 720x348 */
	0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

/*9*/	0x36, 0x2d, 0x2e, 0x07, 0x5a, 0x02, 0x57, 0x57,   /* Hercules 720x348 */
	0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

/*10*/	0x9a, 0x84, 0x86, 0x0f, 0x19, 0x06, 0x19, 0x19,   /* Everex 132x25b&w */
	0x02, 0x0d, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00,

/*11*/	0x9a, 0x84, 0x86, 0x0f, 0x2d, 0x02, 0x2c, 0x2c,   /* Everex 132x44b&w */
	0x02, 0x07, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00
};

setmode(mode)
int	mode;
{
	int	i, j;
	int	bport;
	int	cgaaddr  = 0x3d4;		/* cga 6845 port address */
	int	monoaddr = 0x3b4;		/* mda 6845 port address */

#if UNIX
	if ((fd = open("/dev/mem", 2)) < 0) {
		fprintf(stderr, "mode: open of /dev/mem failed\n");
		perror("mode");
		exit(1);
		}
#endif
	if ((mode == 2) | (mode == 7) | (mode == 8) | (mode == 9) |
			(mode == 10) | (mode == 11))  {
		/* Select mono mode on Everex Edge. */
		bport = cgaaddr;
		outb(bport+9, 2);		/* Extended Graphics Register */
		bport = monoaddr;
		}
	else  {
		/* Select CGA mode on Everex Edge. */
		bport = monoaddr;
		outb(bport+9, 0);		/* Extended Graphics Register */
		bport = cgaaddr;
		}

	outb(bport+4, 0);			/* Reset mode register */

	outb(bport+11, 0x06);			/* Enable all 64k of Everex 
						** Edge video memory, for mono 
						** adapter. 
						*/

	outb(bport+9, ext_graf_reg[mode]);	/* set Everex "extended 
						graphics register" */
	j = (mode+1)*16;

	for(i = mode*16, j = 0; j < 16; i++, j++) {
		outb(bport, j);			/* select register */
		outb(bport+1, params[i]);	/* send value */
		}

	outb(bport+4, creg[mode]);		/* enable */
	if (mode == 6)
		outb(bport+5, 0x3f);	/* set overscan for 640x200 */
	else
		outb(bport+5, 0x30);	/* set normal overscan */
	close(fd);
	return(0);
}

#if UNIX
outb(portno, data)
int	portno;
int	data;
{
	io_op_t	iop;

	iop.io_port = portno;
	iop.io_byte = data;
	if (ioctl(fd, IOCIOP_WB, &iop) < 0) {
		fprintf(stderr, "mode: error on IOCIOP_WB\n");
		perror("mode");
		exit(1);
	}
}
#endif


#if MS_DOS
outb(portno, data)
int portno;
int data;
{
	outp(portno,data);
}
#endif

