#ifndef lint
static char sccsid[] = "@(#) p_wr_pix.c 5.1 89/02/20";
#endif

/*
 *	Copyright (c) David T. Lewis 1987, 1988
 *	All rights reserved.
 *
 *	Permission is granted to use this for any personal noncommercial use.
 *	You may not distribute source or executable code for profit, nor
 *	may you distribute it with a commercial product without the written
 *	consent of the author.  Please send modifications to the author for
 *	inclusion in updates to the program.  Thanks.
 */

#include "config.h"
#include "bitmaps.h"
#include "gf_types.h"
#include "graphics.h"
#include "modes.h"

/*
 *	Mon Mar 23 00:14:50 EST 1987
 *	Sun Mar 13 22:21:46 EST 1988
 *	system5 dtlewis 2 1.3 AT
 *
 *	This routine writes a pixel dot at (x,y), where x and y are
 *	pixel coordinates.  Operates on bit maps defined in bitmaps.h,
 *	and works for video adapter boards (direct write to screen
 *	memory) or printers (write to a bitmap allocated in main memory).
 */

extern struct GL_graphics graphics;

int p_wr_pix(x,y)  
	int x, y;
{

int row, col, page;
unsigned char bitmask;
register char shiftcount;

/* If this is MIX-C, we have small memory model only, and we can't get	*/
/* a 32 bit pointer to the screen.  Therefore, cheat and use the BIOS.	*/
#if MIX_C
writedot(y, x, graphics.color);
return (0);
#endif /* MIX_C */

switch (graphics.grafmode) {

	case CGA_COLOR_MODE:

		row = y >> 1;
		col = x >> 2;

		/* Select a color mask, consisting of four 2 bit patterns. */
		switch (graphics.color) {
			case 0:	bitmask = 0;
				break;
			case 1: bitmask = 0x055;
				break;
			case 2: bitmask = 0x0AA;
				break;
			case 3:	bitmask = 0x0FF;
				break;
			default:bitmask = 0x0FF;
		}

		/* Apply the color mask to the two bit pixel of interest. */
		switch (x & 0x0003)  {
			case 0:	bitmask &= PIX0;
				break;
			case 1:	bitmask &= PIX1;
				break;
			case 2:	bitmask &= PIX2;
				break;
			case 3:	bitmask &= PIX3;
				break;
		}

		/* Write pixel to the appropriate page for this line. */
		if (y & 0x0001) 
			switch (graphics.wrt_mode)  {
				case OR:
					(graphics.cgamem)->page2[row][col] 
						|= bitmask;
					break;
				case XOR:
					(graphics.cgamem)->page2[row][col] 
						^= bitmask;
					break;
			}
		else
			switch (graphics.wrt_mode)  {
				case OR:
					(graphics.cgamem)->page1[row][col] 
						|= bitmask;
					break;
				case XOR:
					(graphics.cgamem)->page1[row][col] 
						^= bitmask;
					break;
			}
		break;

	case CGA_HI_RES_MODE:

		row = y >> 1;
		col = x >> 3;

		bitmask = 0x80;
		shiftcount = x & 0x0007;
		bitmask = bitmask >> shiftcount;

		if (y & 0x0001) {
			switch (graphics.wrt_mode)  {
				case OR:
					(graphics.cgamem)->page2[row][col] 
						|= bitmask;
					break;
				case XOR:
					(graphics.cgamem)->page2[row][col] 
						^= bitmask;
					break;
			}
		}
		else {
			switch (graphics.wrt_mode)  {
				case OR:
					(graphics.cgamem)->page1[row][col] 
						|= bitmask;
					break;
				case XOR:
					(graphics.cgamem)->page1[row][col] 
						^= bitmask;
					break;
			}
		}
		break;

	case EGA_COLOR_MODE:

		col = x >> 3;

		bitmask = 0x80;
		shiftcount = x & 0x0007;
		bitmask = bitmask >> shiftcount;

		(graphics.egamem)->mem[y][col] |= bitmask;
		break;

	case HERC_P0_MODE:
	case HERC_P1_MODE:

		row = y >> 2;
		col = x >> 3;

		bitmask = 0x80 >> (x & 0x0007);

		switch (y & 0x0003) {

			case 0:
				switch (graphics.wrt_mode)  {
					case OR:
						(graphics.hercmem)
						->page1[row][col] 
						|= bitmask;
						break;
					case XOR:
						(graphics.hercmem)
						->page1[row][col] 
						^= bitmask;
						break;
				}
				break;
			case 1:
				switch (graphics.wrt_mode)  {
					case OR:
						(graphics.hercmem)
						->page2[row][col] 
						|= bitmask;
						break;
					case XOR:
						(graphics.hercmem)
						->page2[row][col] 
						^= bitmask;
						break;
				}
				break;
			case 2:
				switch (graphics.wrt_mode)  {
					case OR:
						(graphics.hercmem)
						->page3[row][col] 
						|= bitmask;
						break;
					case XOR:
						(graphics.hercmem)
						->page3[row][col] 
						^= bitmask;
						break;
				}
				break;
			case 3:
				switch (graphics.wrt_mode)  {
					case OR:
						(graphics.hercmem)
						->page4[row][col] 
						|= bitmask;
						break;
					case XOR:
						(graphics.hercmem)
						->page4[row][col] 
						^= bitmask;
						break;
				}
				break;
		}
		break;

	case IBM_PRINTER:

		col = PRINTDENSITY - y - 1;

		row = (x >> 3);
		page = 0;
		while (row >= PRINTLINES)  {
			row -= PRINTLINES;
			++page;
		}

		bitmask = 0x80 >> (x & 0x0007);

		switch (page) {

			case 0:	/* Page 0 */
				switch (graphics.wrt_mode)  {
					case OR:
						(graphics.printbuf1)
						->buf[row][col] 
						|= bitmask;
						break;
					case XOR:
						(graphics.printbuf1)
						->buf[row][col] 
						^= bitmask;
						break;
					}
				break;
			case 1:	/* Page 1 */
				switch (graphics.wrt_mode)  {
					case OR:
						(graphics.printbuf2)
						->buf[row][col] 
						|= bitmask;
						break;
					case XOR:
						(graphics.printbuf2)
						->buf[row][col] 
						^= bitmask;
						break;
					}
				break;
			case 2: /* Page 2 */
				switch (graphics.wrt_mode)  {
					case OR:
						(graphics.printbuf3)
						->buf[row][col] 
						|= bitmask;
						break;
					case XOR:
						(graphics.printbuf3)
						->buf[row][col] 
						^= bitmask;
						break;
					}
				break;
		}
		break;

	case LJ_PRINTER:

		col = LJ_BYTES_PER_LINE - (y >> 3) - 1;
		row = x;
		page = 0;
		while (row >= LJ_LINES)  {
			row -= LJ_LINES;
			++page;
		}

		bitmask = 0x01 << (y & 0x0007);

		switch (page) {

			case 0:	/* Page 0 */
				switch (graphics.wrt_mode)  {
					case OR:
						(graphics.lj_buf1)
						->buf[row][col] 
						|= bitmask;
						break;
					case XOR:
						(graphics.lj_buf1)
						->buf[row][col] 
						^= bitmask;
						break;
					}
				break;
			case 1:	/* Page 1 */
				switch (graphics.wrt_mode)  {
					case OR:
						(graphics.lj_buf2)
						->buf[row][col] 
						|= bitmask;
						break;
					case XOR:
						(graphics.lj_buf2)
						->buf[row][col] 
						^= bitmask;
						break;
					}
				break;
			case 2: /* Page 2 */
				switch (graphics.wrt_mode)  {
					case OR:
						(graphics.lj_buf3)
						->buf[row][col] 
						|= bitmask;
						break;
					case XOR:
						(graphics.lj_buf3)
						->buf[row][col] 
						^= bitmask;
						break;
					}
				break;
		}
		break;

	default:
		return(1);
	}
	return(0);
}
