#ifndef lint
static char sccsid[] = "@(#) n_mvpen.c 5.1 89/02/20";
#endif

/*
 *	Copyright (c) David T. Lewis 1987, 1988
 *	All rights reserved.
 *
 *	Permission is granted to use this for any personal noncommercial use.
 *	You may not distribute source or executable code for profit, nor
 *	may you distribute it with a commercial product without the written
 *	consent of the author.  Please send modifications to the author for
 *	inclusion in updates to the program.  Thanks.
 */

/* dtlewis Fri Jul  3 23:12:40 EDT 1987 
** Routine to move the logical graphics cursor to the indicated (x,y)
** position.
*/

#include "config.h"
#include "bitmaps.h"
#include "graphics.h"

extern struct GL_graphics graphics;

int n_movepen(x,y)  
	int x,y;
{
        /* Set the graphics cursor to the indicated position. */
        /* X and y are in normalized 2-D coordinates (0 to 32767). */

	/* Check for x or y off the screen.			*/
#if INT16
	/* 16 bit integers, use simple check.			*/
        if ((graphics.x_cursor = x) < 0 ) return(1);
        if ((graphics.y_cursor = y) < 0 ) return(1);
#else
	/* Use explicit check.					*/
        if (((graphics.x_cursor = x) < 0) || (x > NRM_X_RANGE)) return(1);
        if (((graphics.y_cursor = y) < 0) || (y > NRM_X_RANGE)) return(1);
#endif /* INT16 */

	return(0);
}
