#ifndef lint
static char sccsid[] = "@(#) n_gfchar.c 5.1 89/02/20";
#endif

/*
 *	Copyright (c) David T. Lewis 1987, 1988
 *	All rights reserved.
 *
 *	Permission is granted to use this for any personal noncommercial use.
 *	You may not distribute source or executable code for profit, nor
 *	may you distribute it with a commercial product without the written
 *	consent of the author.  Please send modifications to the author for
 *	inclusion in updates to the program.  Thanks.
 */

/* Adapted from a routine in _Advanced_Graphics_in_C_, by Nelson	*/
/* Johnson, McGraw-Hill, 1987.						*/

/* Write a graphics character to the screen; advance cursor.		*/
/* Sat Dec 12 12:51:27 EST 1987						*/
/* system5 dtlewis 2 2.2-U AT						*/

#include "config.h"
#if MIX_C
#else
#include <math.h>
#endif /* MIX_C */
#include "font.h"
#include "bitmaps.h"
#include "graphics.h"

extern struct GL_graphics graphics;

extern int i_rot_2d_s();
extern int n_line(), n_movepen();
extern long longsin();

int n_grafchar(asc_char)
unsigned char asc_char;
{
	int x, y, x_1, y_1, x_2, y_2, i;
	int istat = 0;
	double theta;
	float sin_slant;
	long l_sin_slant;
	int xscale, yscale, xinc, yinc;
	int tempval;

	union  
		{
		struct  
			{
			unsigned xval_2 : 4;
			unsigned yval_2 : 4;
			unsigned xval_1 : 4;
			unsigned yval_1 : 4;
			}  nibble;
		struct
			{
			unsigned word;
			}  whole;
		}  fontline;

	x = graphics.x_cursor;
	y = graphics.y_cursor;

	xscale = graphics.strokefont.xsize;
	yscale = graphics.strokefont.ysize;
	xinc = graphics.strokefont.xtic;
	yinc = 0;

	/* Calculate rotation angle for text and cursor motion.		*/

	if (graphics.strokefont.angle_flag)  {

		theta = - (double)(graphics.strokefont.angle);
		i_rot_2d_s( &xinc, &yinc, theta);
	}

	for (i=0; i<=35; i++)  {
		if ((fontline.whole.word = stroke[asc_char][i]) != 0xFFFF) {

			/* Get the endpoints for this stroke line.	*/

			x_1 = fontline.nibble.xval_1 * xscale;
			y_1 = fontline.nibble.yval_1 * yscale;
			x_2 = fontline.nibble.xval_2 * xscale;
			y_2 = fontline.nibble.yval_2 * yscale;

			/* Slant characters if necessary.		*/

			if (graphics.strokefont.slant_flag)  {

				/* We want to slant the top of the 	*/
				/* character to the right, rather than	*/
				/* slanting the bottom to the left.	*/
				/* Use tempval as an offset.		*/

				tempval = yscale * FONTSIZE;

#if NOFLOAT  /* Use integer math for speed.	*/

				l_sin_slant
					= longsin(graphics.strokefont.slant);

				x_1 += (int)((l_sin_slant * (tempval - y_1))
					/ TRIG_SCALE);
				x_2 += (int)((l_sin_slant * (tempval - y_2))
					/ TRIG_SCALE);

#else  /* Use normal math library.	*/

				sin_slant
					= (float)sin(graphics.strokefont.slant);

				x_1 += (int)(sin_slant * (float)(tempval - y_1));
				x_2 += (int)(sin_slant * (float)(tempval - y_2));

#endif /* NOFLOAT */
			}

			/* If necessary, rotate vectors based on angle.	*/

			if (graphics.strokefont.angle_flag)  {

				i_rot_2d_s( &x_1, &y_1, theta);
				i_rot_2d_s( &x_2, &y_2, theta);
			}

			/* Translate to screen location.		*/

			x_1 += x;
			y_1 += y;
			x_2 += x;
			y_2 += y;

			/* Draw the line.				*/

			if (n_line( x_1, y_1, x_2, y_2)) istat = 1;
		}
	}

	/* Move the cursor.						*/

	if (n_movepen(x + xinc, y + yinc)) istat = 1;

	return(istat);
}

