#ifndef lint
static char sccsid[] = "@(#) mode.c 5.1 89/02/20";
#endif

/*
 *	Copyright (c) David T. Lewis 1987, 1988
 *	All rights reserved.
 *
 *	Permission is granted to use this for any personal noncommercial use.
 *	You may not distribute source or executable code for profit, nor
 *	may you distribute it with a commercial product without the written
 *	consent of the author.  Please send modifications to the author for
 *	inclusion in updates to the program.  Thanks.
 */

/* dtlewis 7-13-1987 
** Take command line argument to set graphics mode.  If no argument, then
** read standard input until end of file.
*/

#define NORMAL_MODE 2

#include <stdio.h>
#include "config.h"

main(argc,argv) 
int argc;
char *argv[];
{
	int setmode();
	int modevalue, stat;
	char *inbuf[20];

	if (argc > 2) {
		printf("Usage:  mode n\n");
		exit(0);
	}

	else if (argc == 2)  {
		if (sscanf(argv[1],"%d",&modevalue) != 1)  {
			printf("Unknown mode %s\n",argv[1]);
			exit(1);
		}
		setmode(modevalue);
	}
	else if (argc == 1)  {
#ifdef DEBUG
		for ( ; ; ) {
			stat=scanf("%d", &modevalue);
			if (stat == EOF) exit(0);
			/* Clear input stream if bad read. */
			if (stat == 0) gets(inbuf, 20, stdin); 
			if (stat == 1 && modevalue >= 0 && modevalue <=11) 
				setmode(modevalue);
			}
#endif /* DEBUG */
		setmode(NORMAL_MODE);
		}
	}
