#ifndef lint
static char sccsid[] = "@(#) machdep.c 5.1 89/02/20";
#endif

/*
 *	Copyright (c) David T. Lewis 1989
 *	All rights reserved.
 *
 *	Permission is granted to use this for any personal noncommercial use.
 *	You may not distribute source or executable code for profit, nor
 *	may you distribute it with a commercial product without the written
 *	consent of the author.  Please send modifications to the author for
 *	inclusion in updates to the program.  Thanks.
 */

/* Mon Jan 23 00:01:41 EST 1989						*/
/* Miscellaneous machine dependent routines required to support MS-DOS	*/

#include <stdio.h>
#include "config.h"
#include "bitmaps.h"
#include "gf_types.h"
#include "graphics.h"
#if MIX_C
#include <stdlib.h>
#else
#include <sys/types.h>
#include <math.h>
#if MS_DOS
#include <dos.h>
#endif /* MS_DOS */
#endif /* MIX_C */

#ifndef M_PI
#define M_PI	3.14159265358979323846
#endif /* M_PI */

#define PTR_OK_STAT (0x90)
#define BIOS_PTR_INT (0x17)
#define DOS_KBY_STAT 0x0b

extern struct GL_graphics graphics;

#if MS_DOS
static REGISTERS inreg, outreg;
#endif /* MS_DOS */

/* The next two routines can take the place of macros defined in	*/
/* graphics.h, for compilers that can't use them.			*/

#if N_TO_P_MACRO
#else

int n_to_p_x(x)
int x;
{
	long lval;
	lval = x;
	lval *= graphics.x_extent;
	lval /= NRM_X_RANGE;
	return (lval);
}

int n_to_p_y(y)
int y;
{
	long lval;
	lval = y;
	lval *= graphics.y_extent;
	lval /= NRM_Y_RANGE;
	return (lval);
}
#endif /* N_TO_P_MACRO */

#if HAS_FMOD
#else
/* fmod(3M) replacement for MIX-C compiler, MS-DOS.	*/

double fmod(x,y)
double x, y;
{
	/* x = i*y + f for some value i such that |f| < |y|. 	*/
	/* Solve for f.						*/

	long lval;
	double dval;

	/* Check for zero or overflow	*/
	if (x == 0L || y == 0L) return(0L);

	dval = x / y;
	lval = (long)dval;
	return (x - (double)lval * y);
}
#endif /* HAS_FMOD */

#if HAS_ATAN2
#else
/* atan2(3M) replacement for MIX-C compiler, MS-DOS.	*/
/* Returns arctan of y/x.				*/

double atan2(y,x)
double y, x;
{
	if (x>=0)  {
		/* atan() works fine when angle is in	*/
		/* 1st or 4th quadrant.			*/
		return (atan (y/x));
	}
	else  {
		if (y<0)  {
			/* 3rd quadrant			*/
			return ( -(M_PI - atan (y/x)));
		}
		else  {
			/* 2nd quadrant			*/
			return (M_PI - atan (y/x));
		}
	}
}
#endif /* HAS_ATAN2 */

#if HAS_SLEEP
#else
/* Replacement for the sleep() function (for some MS-DOS compilers).	*/

int sleep(seconds)  
int seconds;
{
/* It's OK for this to be inefficient, since we are only wasting	*/
/* time anyhow.  Therefore, use the DOS call rather than BIOS.  That	*/
/* way, we don't screw up the DOS system clock if we call BIOS at	*/
/* midnight.								*/
#define TICKS_PER_SEC 18.2
#define A_BIG_NUMBER 360000
	long time_to_return;
	long now;
	/* Get the current time using DOS function 0x2c			*/
	inreg.AH = DOS_GET_TIME;
	DO_BIOS(DOS, &inreg, &outreg);
	time_to_return = outreg.DL		/* Hundredths		*/
			+ (outreg.DH * 100)	/* Seconds		*/
			+ (outreg.CL * 6000)	/* Minutes		*/
			+ (outreg.CH * 360000)	/* Hours		*/
			+ (seconds * 100);	/* Add delay time	*/
	now = 0L;
	while (now < time_to_return)  {
		/* Check the time until done.				*/
		inreg.AH = DOS_GET_TIME;
		DO_BIOS(DOS, &inreg, &outreg);
		now = outreg.DL 		/* Hundredths		*/
			+ (outreg.DH * 100)	/* Seconds		*/
			+ (outreg.CL * 6000)	/* Minutes		*/
			+ (outreg.CH * 360000);	/* Hours		*/
		/* Check for rollover at midnight			*/
		if ((time_to_return - now) > A_BIG_NUMBER)  {
			/* Subtract 24 hours				*/
			time_to_return -= 360000 * 24;
		}
	}
	return (0);
}

#endif /* HAS_SLEEP */

#if MS_DOS
/* Routines to get and set video modes for MS-DOS.  See the defines in	*/
/* config.h to understand how the register assignments work.  		*/

int g_setmod(mode)  
int mode;
{
	/* BIOS interrupt 0x10 function 0				*/
	inreg.AH = SET_VIDEO_MODE;
	inreg.AL = mode;	/* Video mode				*/
	DO_BIOS(VIDEO_BIOS, &inreg, &outreg);
	return (0);
}

int g_getmod()
{
	/* BIOS interrupt 0x10 function 0x0f				*/
	inreg.AH = GET_VIDEO_MODE;
	DO_BIOS(VIDEO_BIOS, &inreg, &outreg);
	return (outreg.AL);
}

int bios_print(buffer, itemsize, no_of_items)
char *buffer;
int itemsize;
int no_of_items;
{
	int idx, jdx;
	int pstat = 0;
	int size = itemsize * no_of_items;
	for (idx=0 ;idx < size; idx++)
	{
		/* Wait for printer ready status	*/
		for (jdx = 0, pstat = -1; pstat != PTR_OK_STAT; jdx++)
		{
			inreg.AH = 2;
			DO_BIOS(BIOS_PTR_INT, &inreg, &outreg);
			pstat = (0xf8) & (outreg.AH);
			if (jdx > 30000)
			{
				fprintf(stderr,"Timeout on printer device\n",0);
				return(0);
			}
		}

		/* Send a byte				*/
		inreg.AH = 0;
		inreg.AL = buffer[idx];
		DO_BIOS(BIOS_PTR_INT, &inreg, &outreg);

		/* Call to get keyboard status, so DOS can check for	*/
		/* interrupt signal (^C).				*/
		inreg.AH = DOS_KBY_STAT;
		DO_BIOS(DOS, &inreg, &outreg);
	}
	return(no_of_items);
}

#endif /* MS_DOS */


