
/*	@(#) graphics.h 5.1 89/02/20	*/
/*
 *	Copyright (c) David T. Lewis 1987, 1988
 *	All rights reserved.
 *
 *	Permission is granted to use this for any personal noncommercial use.
 *	You may not distribute source or executable code for profit, nor
 *	may you distribute it with a commercial product without the written
 *	consent of the author.  Please send modifications to the author for
 *	inclusion in updates to the program.  Thanks.
 */

/* Sun Dec 20 18:31:11 EST 1987						*/
/* system5 dtlewis 2 2.2-U AT						*/

#if XENIX_286	/* Support mixed memory model for MS compilers.		*/
#define FAR far
#else
#define FAR 
#endif /* XENIX_286 */

#define TRUE (1)
#define FALSE (0)

/*
 *	The following are for MS-DOS and BIOS calls.
 */
#define DOS 0x021
#define VIDEO_BIOS 0x010
#define SET_VIDEO_MODE 0x00
#define GET_VIDEO_MODE 0x0f
#define DOS_GET_TIME 0x2c
#define WRT_PIXEL 0x0C

/*
 *	The following are masks for the four possible 2-bit pixel
 *	positions in CGA 320x200 mode.
 */
#define PIX0 0x0C0
#define PIX1 0x030
#define PIX2 0x0C
#define PIX3 0x03

/*
 *	Define range of the normalized 2D coordinate system
 */
#define NRM_X_MIN 0
#define NRM_Y_MIN 0
#define NRM_X_MAX 32767
#define NRM_Y_MAX 32767
#define NRM_X_RANGE 0x7FFFL
#define NRM_Y_RANGE 0x7FFFL

/*
 *	Define TRIG_SCALE, F_TRIG_SCALE and PTS_PER_QUADRANT for use in
 *	trig.c and related routines.
 */
#define TRIG_SCALE 32768	/* Factor by which the cos and sin	*/
				/* tables are multiplied in order to	*/
				/* be able to use them in integer math.	*/
				/* This also effects contents of	*/
				/* cos_table and sin_table.		*/

#define F_TRIG_SCALE 32768.0	/* Floating point version.		*/

#define PTS_PER_QUADRANT 64	/* Don't change this without also	*/
				/* changing the initializations for the	*/
				/* cos_table and sin_table tables also!	*/

#define X_CELL_BITS 8		/* Number of bits per character cell	*/
				/* in X direction.			*/

#define Y_CELL_BITS 8		/* Number of bits per character cell	*/
				/* in Y direction.			*/

/* Define transforms for normalized 2-D drawing space to pixel space.	*/
/* These routines convert from normalized (x,y) coordinates to local	*/
/* screen pixel coordinates.  The normalized coordinate system extends	*/
/* from 0 to 32767 in the x direction, and from 0 to 32767 in the	*/
/* downward y direction,  with the origin at the upper left of the	*/
/* screen.  Screen aspect ratio is not taken into account.		*/

#if N_TO_P_MACRO
#define n_to_p_x(x) ((int)(((long)x * graphics.x_extent) / NRM_X_RANGE))
#define n_to_p_y(y) ((int)(((long)y * graphics.y_extent) / NRM_Y_RANGE))
#else
/* See the machdep.c file for alternative routines for dumb compilers.	*/
#endif /* N_TO_P_MACRO */

struct GL_graphics	{

	int initialized;	/* Set true by call to g_init().	*/

	/* Pointers to structures representing screen (or printer)	*/
	/* bitmaps.  A separate pointer(s) are used for each possible	*/
	/* bitmap type.							*/

	CGA_BUF_TYPE FAR *cgamem; /* Pointer to video memory segment.	*/
				/* Will be used by the p_wr_pix() 	*/
				/* routine.				*/

	EGA_BUF_TYPE FAR *egamem; /* Pointer to video memory segment.	*/
				/* Will be used by the p_wr_pix() 	*/
				/* routine.				*/

	HERC_BUF_TYPE FAR *hercmem; /* Pointer to video memory segment.	*/
				/* Will be used by the p_wr_pix() 	*/
				/* routine.				*/

	PR_BUF_TYPE FAR *printbuf1; /* Pointers to IBM/Epson printer	*/
	PR_BUF_TYPE FAR *printbuf2; /* bit map segments.  Will be used	*/
	PR_BUF_TYPE FAR *printbuf3; /* by the p_wr_pix() routine.	*/

	LJ_BUF_TYPE FAR *lj_buf1; /* Pointers to Laserjet printer bit	*/
	LJ_BUF_TYPE FAR *lj_buf2; /* map segments.  Will be used by	*/
	LJ_BUF_TYPE FAR *lj_buf3; /* the p_wr_pix() routine.		*/

	/* The graphics "cursor" is used by all routines operating in	*/
	/* normalized 2-D coordinate space.				*/

	int x_cursor;		/* Graphics cursor position in pixel	*/
				/* units on x axis.			*/
	int y_cursor;		/* Graphics cursor position in pixel	*/
				/* units on y axis.			*/

	/* Dimensions of the physical screen.  The width of the screen	*/
	/* in pixels is, for example, 639 for a screen with 640 	*/
	/* horizontal pixels.  Aspect ratio varies according to the	*/
	/* graphics mode and physical monitor used.			*/

	int	x_extent,	/* Width and height of screen in units	*/
		y_extent;	/* of pixels.				*/

	float	aspect_ratio;	/* Height of screen divided by width.	*/

	/* Variables used for coordinate transformations (partially 	*/
	/* implemented).				 		*/

	float	xlate_x,	/* Translation prior to rotation and	*/
		xlate_y,	/* scaling, perspective, viewports, and	*/
		xlate_z;	/* windows.				*/

	float	offset_x,	/* Offset from origin of world 		*/
		offset_y,	/* coordinates	(after translation), 	*/
		offset_z;	/* about which we will rotate, scale, 	*/
				/* and do perspective.			*/

	float	theta_x,	/* Angle of rotation about x axis.	*/
				/* (z to y right hand rule.)		*/
		theta_y,	/* Angle of rotation about y axis.	*/
				/* (z to x right hand rule.)		*/
		theta_z;	/* Angle of rotation about x axis.	*/
				/* (x to y right hand rule.)		*/

	/* Factors used in the 3D to 2D rotation matrix.  We want to	*/
	/* calculate them once, then use them repeatedly.		*/

	float	c_tz_c_ty,	/* cos(theta_z)*cos(theta_y)		*/
		s_tz,		/* sin(theta_z)				*/
		s_ty,		/* sin(theta_y)				*/
		c_tz_c_tx,	/* cos(theta_z)*cos(theta_x)		*/
		s_tx;		/* sin(theta_x)				*/

	float	scale_factor;	/* Scaling factor, after rotation,	*/
				/* before perspective.			*/

	float	perspect_dist;	/* Perspective viewing distance.	*/

	int	x_vport_ll,	/* Lower left and upper right x and y	*/
		y_vport_ll,	/* coordinates of the viewport in the	*/
		x_vport_ur,	/* normalized coordinate space.		*/
		y_vport_ur;

	int	x_window_ll,	/* Lower left and upper right x and y	*/
		y_window_ll,	/* coordinates of the active windo in	*/
		x_window_ur,	/* terms of normalized coordinate	*/
		y_window_ur;	/* space.				*/

	/* Drawing control variables.					*/

	int grafmode;	 	/* Video display mode			*/

	int color;		/* Color of line to draw		*/

	int lineweight;		/* Line thickness			*/

	long linestyle;		/* Line style (e.g. dot-dash)		*/

	int wrt_mode; 		/* Pixel writing mode (OR, XOR, etc)	*/

	/* Stroke font control parameters.				*/

	struct  {
		int xtic;	/* Character to character distance	*/
		int ytic;	/* Line to line distance		*/
		int xsize;	/* Vertical character size		*/
		int ysize;	/* Horizontal character size		*/
		float angle;	/* Rotation angle of text line, in	*/
				/* counterclockwise radians.		*/
		float slant;	/* Char slant angle, in clockwise	*/
				/* radians.				*/
		int angle_flag;	/* Set TRUE if angle is non-zero.	*/
				/* If TRUE, we need to do extra work to	*/
				/* draw characters.			*/
		int slant_flag;	/* Set TRUE if slant is non-zero.	*/
				/* If TRUE, we need to do extra work to	*/
				/* draw characters.			*/
	} strokefont, default_strokefont;

	/* Bitmap font parameters.					*/

	struct  {
		int chars_per_line;
		int lines_per_screen;
		int xtic;	/* Character to character distance	*/
		int ytic;	/* Line to line distance		*/
		int xmult;	/* If 2, then make double wide, etc.	*/
		int ymult;	/* If 2, then make double high, etc.	*/
	} cellfont;
};

