/*	@(#) gl.h 5.1 89/02/20	*/
/*
 *	Copyright (c) David T. Lewis 1988
 *	All rights reserved.
 *
 *	Permission is granted to use this for any personal noncommercial use.
 *	You may not distribute source or executable code for profit, nor
 *	may you distribute it with a commercial product without the written
 *	consent of the author.  Please send modifications to the author for
 *	inclusion in updates to the program.  Thanks.
 */

/*	This file defines the interface to the graphics library, and should
 *	be included in user programs.
 */

/* Definition of programming interface to gl library.	*/

extern int g_clear();
extern int g_init();
extern int g_finish();
extern int g_pix_mode();
extern int g_pix_color();
extern int g_fontctl();
extern long g_style();
extern int g_weight();
extern int p_wr_pix();
extern int c_cellchar();
extern int c_cellstr();
extern int c_cursor();
extern int n_movepen();
extern int n_box();
extern int n_line();
extern int n_draw();
extern int n_grafchar();
extern int n_grafstr();
extern int n_arc();
extern int n_ellipse();
extern int n_point();

/* Everything that follows should be identical to gf_types.h and modes.h. */

/*	@(#) gf_types.h 1.4 88/12/26	*/

/* Define pixel setting modes. 			*/

#define CLEAR 0
#define AND 1
#define OR 2
#define XOR 3

/* Define colors.	 			*/

#define BLACK        0
#define BLUE         1
#define GREEN        2
#define CYAN         3
#define RED          4
#define MAGENTA      5
#define BROWN        6
#define WHITE        7
#define GREY         8
#define LT_BLUE      9
#define LT_GREEN    10
#define LT_CYAN     11
#define LT_RED      12
#define LT_MAGENTA  13
#define YELLOW      14
#define LT_WHITE    15

/* Define line styles.	*/

#define SOLID 0xffffffffL	/* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX  */
#define DOTTED 0x66666666L	/* XX..XX..XX..XX..XX..XX..XX..XX..  */
#define DASHED 0xffe0ffe0L	/* XXXXXXXXXXX.....XXXXXXXXXXX.....  */
#define SHORTDASHED 0xf8f8f8f8L	/* XXXXX...XXXXX...XXXXX...XXXXX...  */
#define LONGDASHED 0xffffff00L	/* XXXXXXXXXXXXXXXXXXXXXXXX........  */
#define DOTDASHED 0xfc30fc30L	/* XXXXXX....XX....XXXXXX....XX....  */

/* Define line weights (not yet implemented).	*/

#define LIGHT 1
#define MEDIUM 2
#define HEAVY 4

/*	@(#) modes.h 1.4 89/01/10	*/

/*
 *	Mode definitions.  These will be used by init(), and by the mode
 *	program or shell script.  As much as possible, the numeric mode
 *	values should correspond to those used by the uPort screen driver
 *	and by DOS.  The values given for hercules and for printers are
 *	arbitrary, but should not conflict with other "standard" assignments.
 */

/* ENV_MODE means take the mode setting from an environment variable. */
#define ENV_MODE 0

/* CGA text modes */
#define MONO_TEXT 0x02
#define COLOR_TEXT 0x03

/* CGA modes (for CGA or EGA) */
#define CGA_COLOR_MODE 0x04
#define CGA_HI_RES_MODE 0x06

/* Monochrome text mode */
#define MDA_TEXT 0x07

/* Hercules mono graphics, page 0 and page 1 */
/* Note:  Modes 8 and 9 were used by the IBM PC Junior.  I trust that 	*/
/* they will not be found on your machine.				*/
#define HERC_P0_MODE 0x08
#define HERC_P1_MODE 0x09

/* EGA 640 x 350 color mode */
#define EGA_COLOR_MODE 0x010

/* Anything beyond MAXVIDEO is not a video board.  Printers and other	*/
/* hardcopy would fall in this category.				*/

#define MAXVIDEO 0x0FF

/* Non-video modes follow.						*/

#define IBM_PRINTER 0x100


