#ifndef lint
static char sccsid[] = "@(#) g_print.c 5.1 89/02/20";
#endif

/*
 *	Copyright (c) David T. Lewis 1987, 1988, 1989
 *	All rights reserved.
 *
 *	Permission is granted to use this for any personal noncommercial use.
 *	You may not distribute source or executable code for profit, nor
 *	may you distribute it with a commercial product without the written
 *	consent of the author.  Please send modifications to the author for
 *	inclusion in updates to the program.  Thanks.
 */

/* Sat Feb 18 15:54:14 EST 1989						*/
/* Printer specific code.						*/

#include <stdio.h>
#include "config.h"
#if MS_DOS
#include <stdlib.h>
#endif /* MS_DOS */
#if XENIX_286
#include <sys/fcntl.h>
#include <sys/machdep.h>
#include <sys/sysmacros.h>
#endif /* XENIX_286 */
#include "bitmaps.h"
#include "gf_types.h"
#include "graphics.h"
#include "modes.h"

/* Use BIOS output for printer on MS-DOS.	*/
#if MS_DOS
extern int bios_print();
#define FWRITE(a,b,c,d) bios_print(a,b,c)
#else
#define FWRITE(a,b,c,d) fwrite(a,b,c,d)
#endif /* MS_DOS */

extern struct GL_graphics graphics;

#define FORM_FEED (014)

#define EPSON_START_GRAPHICS 033, 'A', 07, 033, 02
#define IBM_START_GRAPHICS 033, '1'
#define IBM_PAGE_END 033, 'A', 014, 033, 02
#define IBM_LINE_START 033, 'L', 0300, 03
#define IBM_LINE_END 015, 012

static char IBM_pg_top[] = {EPSON_START_GRAPHICS, IBM_START_GRAPHICS};
static char IBM_pg_end[] = {IBM_PAGE_END};
static char IBM_pg_ff_end[] = {IBM_PAGE_END, FORM_FEED};
static char IBM_ln_start[] = {IBM_LINE_START};
static char IBM_ln_end[] = {IBM_LINE_END};

#define LJ_RESET 033, 'E'
#define LJ_150_DPI 033, '*', 't', '1', '5', '0', 'R'	/* 150 dpi graphics */
#define LJ_CUR_HOME 033, '&', 'a', '3', 'C'	      /* Cursor to column 3 */
#define LJ_START_GRAPHICS 033, '*', 'r', '1', 'A'
#define LJ_XFER_GRAPHICS 033, '*', 'b', '1', '4', '0', 'W'     /* 140 bytes */
#define LJ_END_GRAPHICS 033, '*', 'r', 'B'

static char LJ_pg_top[]={LJ_RESET, LJ_150_DPI, LJ_CUR_HOME, LJ_START_GRAPHICS};
static char LJ_pg_end[] = {LJ_END_GRAPHICS, LJ_RESET};
static char LJ_pg_ff_end[] = {LJ_END_GRAPHICS, LJ_RESET};
static char LJ_ln_start[] = {LJ_XFER_GRAPHICS};
static char LJ_ln_end[] = {0};	/* No line end needed */

/* A do-nothing function.  The printer function pointers will initially	*/
/* point to this, just to avoid core dumps later on.			*/

static int null_function(fp)
FILE *fp;
{
	return(0);
}

/* For printers, the following four functions send data required to	*/
/* start the print, end the print, start each line, and end each line.	*/
/* These function pointers are defined globally here, and are used to	*/
/* send data to printers in g_finish().  These are initialized to a	*/
/* safe value now, and set to the appropriate values for the current	*/
/* graphics mode later in g_init().					*/

int (*pr_head)() = null_function;
int (*pr_tail)() = null_function;
int (*pr_lnst)() = null_function;
int (*pr_lnend)() = null_function;

/* Following is the device specific code for each printer (sorry, there	*/
/* is only one working so far, but I like to plan ahead).		*/

/* Start of IBM or Epson compatible dot matrix printer code.		*/

int IBM_head(fp)
FILE *fp;
{
	/* Begin graphics mode; set line spacing	*/
	if((FWRITE(IBM_pg_top,sizeof(char),sizeof(IBM_pg_top),fp)) <
		sizeof(IBM_pg_top)) return(1);
	else return(0);
}

int IBM_tail(fp)
FILE *fp;
{
	/* End of page, begin text mode					*/
#if HAS_PIPES
	if((FWRITE(IBM_pg_end,sizeof(char),sizeof(IBM_pg_end),fp)) <
		sizeof(IBM_pg_end)) return(1);
	else return(0);
#else
	/* If we are not piping to a print spooler program, then we	*/
	/* need to supply our own form feed command.			*/
	if((FWRITE(IBM_pg_ff_end,sizeof(char),sizeof(IBM_pg_ff_end),fp)) <
		sizeof(IBM_pg_ff_end)) return(1);
	else return(0);
#endif /* HAS_PIPES */
}

int IBM_lnst(fp)
FILE *fp;
{
	/* Start a line of graphics data	*/
	if((FWRITE(IBM_ln_start,sizeof(char),sizeof(IBM_ln_start),fp)) <
		sizeof(IBM_ln_start)) return(1);
	else return(0);
}

int IBM_lnend(fp)
FILE *fp;
{
	/* End line of graphics data		*/
	if((FWRITE(IBM_ln_end,sizeof(char),sizeof(IBM_ln_end),fp)) <
		sizeof(IBM_ln_end)) return(1);
	else return(0);
}

int IBM_send_print(fp)
FILE *fp;
#define MODULE "IBM_send_print"
{
	int idx;

	/* Dump the print image to the file	*/

	/* Set line feed pitch for graphics	*/

	(*pr_head)(fp);

	/* Write the lines of data (3 buffers full) */
	for (idx=0; idx<PRINTLINES; idx++)  {
		(*pr_lnst)(fp);
		FWRITE(&(graphics.printbuf1->buf[idx][0]),
			sizeof(char), PRINTDENSITY, fp);
		(*pr_lnend)(fp);
	}
	for (idx=0; idx<PRINTLINES; idx++)  {
		(*pr_lnst)(fp);
		FWRITE(&(graphics.printbuf2->buf[idx][0]),
			sizeof(char), PRINTDENSITY, fp);
		(*pr_lnend)(fp);
	}
	for (idx=0; idx<PRINTLINES; idx++)  {
		(*pr_lnst)(fp);
		FWRITE(&(graphics.printbuf3->buf[idx][0]),
			sizeof(char), PRINTDENSITY, fp);
		(*pr_lnend)(fp);
	}

	/* Set line feed pitch back for text	*/

	if ((*pr_tail)(fp))  {
		fprintf(stderr,"%s: unable to write to printer\n",MODULE);
		return(1);
	}
	return(0);
}

/* End of IBM or Epson compatible dot matrix printer code.		*/


/* Start of Laserjet+ printer code.		*/

int LJ_head(fp)
FILE *fp;
{
	/* Begin graphics mode; set line spacing	*/
	if((FWRITE(LJ_pg_top,sizeof(char),sizeof(LJ_pg_top),fp)) <
		sizeof(LJ_pg_top)) return(1);
	else return(0);
}

int LJ_tail(fp)
FILE *fp;
{
	/* End of page, reset and eject page	*/
	if((FWRITE(LJ_pg_end,sizeof(char),sizeof(LJ_pg_end),fp)) <
		sizeof(LJ_pg_end)) return(1);
	else return(0);
}

int LJ_lnst(fp)
FILE *fp;
{
	/* Start a line of graphics data	*/
	if((FWRITE(LJ_ln_start,sizeof(char),sizeof(LJ_ln_start),fp)) <
		sizeof(LJ_ln_start)) return(1);
	else return(0);
}

int LJ_lnend(fp)
FILE *fp;
{
	/* End line of graphics data		*/
	return(0);
}

int LJ_send_print(fp)
FILE *fp;
#undef MODULE
#define MODULE "LJ_send_print"
{
	int idx;

	/* Dump the print image to the file	*/

	/* Start page of graphics */

	(*pr_head)(fp);

	/* Write the lines of data (3 buffers full) */
	for (idx=0; idx<LJ_LINES; idx++)  {
		(*pr_lnst)(fp);
		FWRITE(&(graphics.lj_buf1->buf[idx][0]),
			sizeof(char), LJ_BYTES_PER_LINE, fp);
		(*pr_lnend)(fp);
	}
	for (idx=0; idx<LJ_LINES; idx++)  {
		(*pr_lnst)(fp);
		FWRITE(&(graphics.lj_buf2->buf[idx][0]),
			sizeof(char), LJ_BYTES_PER_LINE, fp);
		(*pr_lnend)(fp);
	}
	for (idx=0; idx<LJ_LINES; idx++)  {
		(*pr_lnst)(fp);
		FWRITE(&(graphics.lj_buf3->buf[idx][0]),
			sizeof(char), LJ_BYTES_PER_LINE, fp);
		(*pr_lnend)(fp);
	}

	/* End of page */

	if ((*pr_tail)(fp))  {
		fprintf(stderr,"%s: unable to write to printer\n",MODULE);
		return(1);
	}
	return(0);
}

/* End of Laserjet+ printer code.		*/


