
#ifndef lint
static char sccsid[] = "@(#) g_pixctl.c 5.1 89/02/20";
#endif

/*
 *	Copyright (c) David T. Lewis 1988
 *	All rights reserved.
 *
 *	Permission is granted to use this for any personal noncommercial use.
 *	You may not distribute source or executable code for profit, nor
 *	may you distribute it with a commercial product without the written
 *	consent of the author.  Please send modifications to the author for
 *	inclusion in updates to the program.  Thanks.
 */

/*
 *	This module contains routines for setting pixel color and writing
 *	mode, and for setting line weight and style.
 */

#include "config.h"
#include "bitmaps.h"
#include "gf_types.h"
#include "graphics.h"
#include "modes.h"

#define ROT_MASK ((long)0x80000000L)

extern struct GL_graphics graphics;
extern int p_wr_pix();

static int p_mask_pix();
static long current_style;

int (*p_do_pix)();	/* Called by n_draw()	*/

/* Set the color to be used for all pixel operations.  The returned 	*/
/* value is the previous color setting.					*/

int g_pix_color(color)
int color;
{
	int last_color;
	last_color = graphics.color;
	graphics.color = color;
	if (graphics.grafmode == EGA_COLOR_MODE)  {
		/* Write to EGA registers.  Not yet implemented. */
		/* Ditto for VGA. */
	}
	return(last_color);
}

/* Set the pixel writing mode to update pixels in either OR mode	*/
/* (set the pixel on, regardless of previous state), or XOR mode	*/
/* (pixel is XORed with its previous value).  XOR mode is used for	*/
/* things like graphics cursors which may be placed on the screen	*/
/* without destroying the previous screen contents.			*/
/* The returned value is the previous state of the pixel mode.		*/

int g_pix_mode(mode_val)
int mode_val;
{
	int last_mode;
	last_mode = graphics.wrt_mode;
	switch (mode_val)  {
		case CLEAR:	/* (Not yet implemented) */
			graphics.wrt_mode = CLEAR;
			break;
		case AND:	/* (Not yet implemented) */
			graphics.wrt_mode = AND;
			break;
		case OR:
			graphics.wrt_mode = OR;
			break;
		case XOR:
			graphics.wrt_mode = XOR;
			break;
		default:
			graphics.wrt_mode = OR;
			break;
	}
	return(last_mode);
}

/* Set the line thickness to be used for all line drawing operations.	*/
/* The returned value is the previous line weight setting.		*/

int g_weight(lineweight)
int lineweight;
{
	int last_weight;
	last_weight = graphics.lineweight;
	graphics.lineweight = lineweight;
	return(last_weight);
}

/* P_mask_pix() will be used only if a line style is desired.	*/
/* Otherwise, we will directly invoke p_wr_pix().		*/

static int p_mask_pix(x, y)
int x, y;
{
	/* If high bit in graphics.linestyle is a 1, then	*/
	/* write the pixel; otherwise, don't write it.		*/

	if (((current_style & ROT_MASK)) != 0)  {
		/* High bit set, rotate the line style mask	*/
		/* and write the pixel.				*/
		current_style = current_style<<1;
		current_style++;
		return (p_wr_pix(x, y));
	}
	else  {
		/* Rotate mask, but don't write pixel.		*/
		current_style = current_style<<1;
		return(0);
	}
}

/* Line style (e.g. dot-dash)		*/

/* Set the line style (e.g. dot-dash) to be used for all line drawing	*/
/* operations.  The returned value is the previous line style setting.	*/

long g_style(linestyle)
long linestyle;
{
	long last_style;
	last_style = graphics.linestyle;

	/* The current "state" of linestyle is stored in	*/
	/* graphics.linestyle, and a copy of this value is	*/
	/* kept locally in current_style, to be manipulated by	*/
	/* the g_mask_pix() routine (above).			*/
	graphics.linestyle = current_style = linestyle;

	/* Decide what type of pixel routine to use.  If we	*/
	/* have to consider line style, then we will use	*/
	/* mask_pix().						*/
	if (linestyle == SOLID)  {
		p_do_pix = p_wr_pix;
	}
	else  {
		p_do_pix = p_mask_pix;
	}
	return(last_style);
}


