#ifndef lint
static char sccsid[] = "@(#) g_init.c 5.1 89/02/20";
#endif

/*
 *	Copyright (c) David T. Lewis 1987, 1988, 1989
 *	All rights reserved.
 *
 *	Permission is granted to use this for any personal noncommercial use.
 *	You may not distribute source or executable code for profit, nor
 *	may you distribute it with a commercial product without the written
 *	consent of the author.  Please send modifications to the author for
 *	inclusion in updates to the program.  Thanks.
 */

/* Sat Nov 28 17:10:53 EST 1987 */
/* Initialize shared or video memory for use in graphics I/O.  For 	*/
/* Microport System V/AT we presume that shared memory segments have	*/
/* been defined (usually at system boot time) such that the shared	*/
/* memory keys are "B8000L" for CGA adapter, and so on (or change	*/
/* the definitions in config.h).  For Xenix, we can directly address	*/
/* video memory via the appropriate segment selector.			*/

#define MODULE "g_init()"

#include <stdio.h>
#include "config.h"
#if MIX_C
#else
#include <sys/types.h>
#include <math.h>
#if TCC
#else
#include <malloc.h>
#endif /* TCC */
#endif /* MIX_C */
#if MS_DOS
#include <stdlib.h>
/* Mode to return to before exiting	*/
int g_text = -1;
#else
#include <sys/ipc.h>
#endif /* MS_DOS */
#if XENIX_286
#include <sys/fcntl.h>
#include <sys/machdep.h>
#include <sys/sysmacros.h>
#endif /* XENIX_286 */
#if HAS_SIG
#include <signal.h>
#endif /* HAS_SIG */
#include "bitmaps.h"
#include "gf_types.h"
#include "graphics.h"
#include "modes.h"

#ifndef HUGE
#define HUGE (3.4e+38)
#endif /* HUGE */

struct GL_graphics graphics;
extern int (*p_do_pix)();
extern int g_clear();
extern int g_finish();
extern int p_wr_pix();
extern char *getenv();

#if TCC
#else
extern char *calloc();
#endif /* TCC */

#if HAS_SIG
/* Global variable to save previous interrupt signal handler (usually	*/
/* SIG_DFL, but someone may have their own handler for closing files	*/
/* or other cleanup).  This value is restored when g_finish() is	*/
/* called.								*/
SIG_TYPE (*gl_last_int_handler)();

/* This is the default interrupt signal handler, which is in effect	*/
/* starting with the call to g_init(), until the call to g_finish().	*/
SIG_TYPE gl_sig_catch() {
	/* Don't take any more signals while we work.			*/
	signal (SIGINT, SIG_IGN);

	/* Clean up and exit.  Don't bother cleaning up for printers,	*/
	/* since we are only interested in clearing the screen and	*/
	/* detaching from shared memory segments.			*/
	if (graphics.grafmode <= MAXVIDEO)  {
		g_finish();
	}
	exit(1);
}
#endif /* HAS_SIG */

/* Warning for System V/AT problems.					*/
static void bad_key_warning(key)  
long key;
{
	system(MODEPROG);
	fprintf (stderr,"Cannot attach to shared memory key %lx for mode ",key);
	fprintf (stderr,"%d in routine %s.\n", graphics.grafmode, MODULE);
	fprintf (stderr,"The problem is most likely caused by ",0);
	fprintf (stderr,"lack of a shared memory key.\n",0);
	fprintf (stderr,"You must use a kernel with shared memory ",0);
	fprintf (stderr,"enabled, and define the keys\n",0);
	fprintf (stderr,"using the shmcreate(1) utility.\n",0);
}

/* Warning for Xenix 286 problems.					*/
static void bad_sel_warning(device_name)  
char device_name[];
{
	system(MODEPROG);
	fprintf (stderr,"Cannot locate selector for the ",0);
	fprintf (stderr,"requested video adapter %s.\n", device_name);
	fprintf (stderr,"Graphics mode %d was requested in routine %s.\n",
		graphics.grafmode, MODULE);
	fprintf (stderr,"The most likely problem is that your ",0);
	fprintf (stderr,"physical board does not match the\n",0);
	fprintf (stderr,"type you tried to attach to (see ",0);
	fprintf (stderr,"the \"config.h\" file for the gl library).\n",0);
}

int not_enuf_mem()  {
	fprintf(stderr,
		"%s: Insufficient memory for in-core print buffer.\n",
		MODULE);
	return(1);
}

/* For printers, the following four functions send data required to	*/
/* start the print, end the print, start each line, and end each line.	*/
/* These function pointers will point to routines in g_print.c.		*/

extern int (*pr_head)(), (*pr_tail)(), (*pr_lnst)(), (*pr_lnend)();

/* There will be one set of these functions for each printer type.	*/

extern int IBM_head(), IBM_tail(), IBM_lnst(), IBM_lnend();
extern int LJ_head(), LJ_tail(), LJ_lnst(), LJ_lnend();

int g_init(mode)
int mode;
/* Mode is the video mode that will be used when in graphics mode.	*/
/* By implication, this gives us the memory location we want to attach	*/
/* to, as well as the dimensions of the screen.				*/

{
	char *env_mode;
	extern int errno;
	int istat;
	char command[40], modebuf[10];

#if SVAT
	long key;
	char *shmat();
	int shmid;
#endif /* SVAT */

#if XENIX_286
	int fd, selector;
	char device_name[20];
	int map_request;

#if GL_EGA
	map_request = MAPEGA;
	strcpy(device_name,"/dev/ega");
#else
#if GL_HERC
	map_request = MAPMONO;
	strcpy(device_name,"/dev/monochrome");
#else
#if GL_PGA
	map_request = MAPPGA;
	strcpy(device_name,"/dev/pga");
#else
#if GL_VGA
	/* No support for this.  Wait for later Xenix release, I guess.	*/
	map_request = MAPCONS;
	strcpy(device_name,"/dev/console");
#else
#if GL_CGA
	map_request = MAPCGA;
	strcpy(device_name,"/dev/color");
#else
	/* May as well default to CGA.	*/
	map_request = MAPCGA;
	strcpy(device_name,"/dev/console");
#endif /* GL_CGA */
#endif /* GL_VGA */
#endif /* GL_PGA */
#endif /* GL_HERC */
#endif /* GL_EGA */

#endif /* XENIX_286 */

#if MS_DOS
	/* Save the mode we started in so we can exit in text mode.	*/
	if (g_text == -1) g_text = g_getmod();
#endif /* MS_DOS */

	/* If we have already initialized, then call g_finish() before	*/
	/* proceeding.							*/

	if (graphics.initialized == TRUE)  {
		if ((istat=g_finish()) != 0) return(istat);
	}
	else graphics.initialized = FALSE;

	/* Remember what mode we are in.				*/

	graphics.grafmode = mode;

	/* If mode is ENV_MODE, then get mode from the 		*/
	/* environment.  Get the default video mode if 		*/
	/* specified in an  environment variable; otherwise,	*/
	/* use the compiled-in default value.			*/

	if (graphics.grafmode==ENV_MODE)  
#if HAS_ENV
	{
		if ((env_mode = getenv(GL_ENV_MODE)) == NULL)  {
			/* No environment variable; use the default.	*/
			/* Put warning message to standard error, then	*/
			/* continue.					*/
			fprintf(stderr,
			"Use environment variable %s to control mode.\n",
				GL_ENV_MODE);
			fprintf(stderr,"Continuing with default mode %d.\n",
				DEFAULT_MODE);
			graphics.grafmode = DEFAULT_MODE;
			sleep(2);
		}
		else if(sscanf(env_mode,"%d",&(graphics.grafmode)) != 1)  {
			fprintf (stderr,
				"WARNING:  Routine %s checking environment ",
				MODULE);
			fprintf (stderr,
				"variable %s.\n",
				GL_ENV_MODE);
			fprintf (stderr,
				"Cannot understand mode \"%s\".  Integer ",
				env_mode);
			fprintf (stderr,
				"value is required.\n",0);
			return(1);
		}
	}
#else
	{
		/* Some systems do not understand getenv()	*/
		graphics.grafmode = DEFAULT_MODE;
	}
#endif /* HAS_ENV */

	/* Tell the hardware to go into the appropriate mode, using	*/
	/* the MODEPROG program.					*/

	if (graphics.grafmode <= MAXVIDEO)  {
#if MS_DOS
		g_setmod(graphics.grafmode);
#else
		strcpy(command, MODEPROG);
		strcat(command," ");
		sprintf(modebuf,"%d\0", graphics.grafmode);
		strcat(command, modebuf);
		system(command);
#endif /* MS_DOS */
	}

	/* Attach to the appropriate shared memory segment, and set the	*/
	/* values of graphics.x_extent and graphics.y_extent, according	*/
	/* to the video mode requested.					*/

	switch (graphics.grafmode)  {
	case CGA_COLOR_MODE:
		graphics.x_extent = 319;
		graphics.y_extent = 199;
		graphics.x_window_ll = 0;
		graphics.y_window_ll = 0;
		graphics.x_window_ur = 319;
		graphics.y_window_ur = 199;
		graphics.aspect_ratio = CGA_ASPECT_RATIO;
		graphics.cellfont.chars_per_line = 40;
		graphics.cellfont.lines_per_screen = 25;
#if SVAT
		key = CGA_KEY;
		if ((shmid = shmget(key, 32768, IPC_CREAT)) < 0)  {
			bad_key_warning(key);
			return(shmid);
		}
		graphics.cgamem = (CGA_BUF_TYPE *)shmat(shmid, 0L, 0);
#else
#if XENIX_286
		fd = open(device_name, O_WRONLY);
		selector = ioctl(fd,map_request,0);
		if (selector < 0)  {
			bad_sel_warning(device_name);
			return(selector);
		}
		graphics.cgamem = (CGA_BUF_TYPE *)sotofar(selector,0);
#else
#if MS_DOS
		graphics.cgamem = (CGA_BUF_TYPE *)DOS_CGA;
#endif /* MS_DOS */
#endif /* XENIX_286 */
#endif /* SVAT */
		break;
	case CGA_HI_RES_MODE:
		graphics.x_extent = 639;
		graphics.y_extent = 199;
		graphics.x_window_ll = 0;
		graphics.y_window_ll = 0;
		graphics.x_window_ur = 639;
		graphics.y_window_ur = 199;
		graphics.aspect_ratio = CGA_ASPECT_RATIO;
		graphics.cellfont.chars_per_line = 80;
		graphics.cellfont.lines_per_screen = 25;
#if SVAT
		key = CGA_KEY;
		if ((shmid = shmget(key, 32768, IPC_CREAT)) < 0)  {
			bad_key_warning(key);
			return(shmid);
		}
		graphics.cgamem = (CGA_BUF_TYPE *)shmat(shmid, 0L, 0);
#else
#if XENIX_286
		fd = open(device_name, O_WRONLY);
		selector = ioctl(fd,map_request,0);
		if (selector < 0)  {
			bad_sel_warning(device_name);
			return(selector);
		}
		graphics.cgamem = (CGA_BUF_TYPE *)sotofar(selector,0);
#else
#if MS_DOS
		graphics.cgamem = (CGA_BUF_TYPE *)DOS_CGA;
#endif /* MS_DOS */
#endif /* XENIX_286 */
#endif /* SVAT */
		break;
	case HERC_P0_MODE:
	case HERC_P1_MODE:
		graphics.x_extent = 719;
		graphics.y_extent = 347;
		graphics.x_window_ll = 0;
		graphics.y_window_ll = 0;
		graphics.x_window_ur = 719;
		graphics.y_window_ur = 347;
		graphics.aspect_ratio = HERC_ASPECT_RATIO;
		graphics.cellfont.chars_per_line = 90;
		graphics.cellfont.lines_per_screen = 43;
#if SVAT
		if (mode == HERC_P0_MODE) key = HERC_P0KEY;	/* Page 0 */
		else key = HERC_P1KEY;				/* Page 1 */
		if ((shmid = shmget(key, 32768, IPC_CREAT)) < 0)  {
			bad_key_warning(key);
			return(shmid);
		}
		graphics.hercmem = (HERC_BUF_TYPE *)shmat(shmid, 0L, 0);
#else
#if XENIX_286
		/* Note: I don't know how page 0 and 1 will be selected	*/
		/* under Xenix.  Microport can use two different shared	*/
		/* memory keys. dtl 1-8-89				*/
		fd = open(device_name, O_WRONLY);
		selector = ioctl(fd,map_request,0);
		if (selector < 0)  {
			bad_sel_warning(device_name);
			return(selector);
		}
		graphics.hercmem = (HERC_BUF_TYPE *)sotofar(selector,0);
#else
#if MS_DOS
		graphics.hercmem = (HERC_BUF_TYPE *)DOS_H_P0;
#endif /* MS_DOS */
#endif /* XENIX_286 */
#endif /* SVAT */
		break;
	case EGA_COLOR_MODE:
		graphics.x_extent = 639;
		graphics.y_extent = 349;
		graphics.x_window_ll = 0;
		graphics.y_window_ll = 0;
		graphics.x_window_ur = 639;
		graphics.y_window_ur = 349;
		graphics.aspect_ratio = EGA_ASPECT_RATIO;
		graphics.cellfont.chars_per_line = 80;
		graphics.cellfont.lines_per_screen = 43;
#if SVAT
		key = EGA_KEY;
		if ((shmid = shmget(key, 32768, IPC_CREAT)) < 0)  {
			bad_key_warning(key);
			return(shmid);
		}
		graphics.egamem = (EGA_BUF_TYPE *)shmat(shmid, 0L, 0);
#else
#if XENIX_286
		fd = open(device_name, O_WRONLY);
		selector = ioctl(fd,map_request,0);
		if (selector < 0)  {
			bad_sel_warning(device_name);
			return(selector);
		}
		graphics.egamem = (EGA_BUF_TYPE *)sotofar(selector,0);
#else
#if MS_DOS
		graphics.egamem = (EGA_BUF_TYPE *)DOS_EGA;
#endif /* MS_DOS */
#endif /* XENIX_286 */
#endif /* SVAT */
		break;
	case IBM_PRINTER:
		/* Initialize the function pointers for this printer.	*/
		pr_head = IBM_head;
		pr_tail = IBM_tail;
		pr_lnst = IBM_lnst;
		pr_lnend = IBM_lnend;
		graphics.x_extent = 719;
		graphics.y_extent = 959;
		graphics.x_window_ll = 0;
		graphics.y_window_ll = 0;
		graphics.x_window_ur = 719;
		graphics.y_window_ur = 959;
		graphics.aspect_ratio = IBM_PR_ASPECT_RATIO;
		graphics.cellfont.chars_per_line = 90;
		graphics.cellfont.lines_per_screen = 120;
		/* Memory will be g_cleared by calloc(), no need	*/
		/* to call g_clear() later.			*/
		if ((graphics.printbuf1 = (PR_BUF_TYPE *) calloc
			(1,sizeof(PR_BUF_TYPE)))==NULL) return(not_enuf_mem());
		if ((graphics.printbuf2 = (PR_BUF_TYPE *) calloc
			(1,sizeof(PR_BUF_TYPE)))==NULL) return(not_enuf_mem());
		if ((graphics.printbuf3 = (PR_BUF_TYPE *) calloc
			(1,sizeof(PR_BUF_TYPE)))==NULL) return(not_enuf_mem());
		break;
	case LJ_PRINTER:
		/* Initialize the function pointers for this printer.	*/
		pr_head = LJ_head;
		pr_tail = LJ_tail;
		pr_lnst = LJ_lnst;
		pr_lnend = LJ_lnend;
		graphics.x_extent = 1379;
		graphics.y_extent = 1119;
		graphics.x_window_ll = 0;
		graphics.y_window_ll = 0;
		graphics.x_window_ur = 1379;
		graphics.y_window_ur = 1119;
		graphics.aspect_ratio = LJ_PR_ASPECT_RATIO;
		graphics.cellfont.chars_per_line = 138;
		graphics.cellfont.lines_per_screen = 94;
		/* Memory will be g_cleared by calloc(), no need	*/
		/* to call g_clear() later.			*/
		if ((graphics.lj_buf1 = (LJ_BUF_TYPE *) calloc
			(1, LJ_BUF_SIZE))==NULL) return(not_enuf_mem());
		if ((graphics.lj_buf2 = (LJ_BUF_TYPE *) calloc
			(1, LJ_BUF_SIZE))==NULL) return(not_enuf_mem());
		if ((graphics.lj_buf3 = (LJ_BUF_TYPE *) calloc
			(1, LJ_BUF_SIZE))==NULL) return(not_enuf_mem());
		break;
	default:
		/* The programmer is probably confused at this point.	*/
		/* Print a warning and return.				*/
		system(MODEPROG);
		fprintf (stderr,"Unable to initialize in routine %s.  Mode %d requested.\n",MODULE,graphics.grafmode);
		return(1);
	}

	/* Set other variables to reasonable values.			*/

	graphics.color = 2;
	graphics.lineweight = LIGHT;
	graphics.linestyle = SOLID;
	graphics.wrt_mode = OR;

	graphics.xlate_x = 0;
	graphics.xlate_y = 0;
	graphics.xlate_z = 0;
	graphics.offset_x = 0;
	graphics.offset_y = 0;
	graphics.offset_z = 0;
	graphics.theta_x = 0;
	graphics.theta_y = 0;
	graphics.theta_z = 0;
	graphics.c_tz_c_ty = 1.0;
	graphics.s_tz = 0.0;
	graphics.s_ty = 0.0;
	graphics.c_tz_c_tx = 1.0;
	graphics.s_tx = 0.0;
	graphics.scale_factor = 1.0;
	graphics.perspect_dist = HUGE;
	graphics.x_vport_ll = NRM_X_MIN;
	graphics.y_vport_ll = NRM_Y_MAX;
	graphics.x_vport_ur = NRM_X_MIN;
	graphics.y_vport_ur = NRM_Y_MAX;

	/* Character cell spacing in normalized coordinates.  This is	*/
	/* the distance in normalized coordinates.			*/

	/* The horizontal size of a line of cell text is the width of	*/
	/* a pixel (NRM_Y_RANGE divided by the number of pixels across	*/
	/* the screen) times the number of pixels in a line of text.	*/
	/* Rearrange this for computational accuracy.			*/

	graphics.cellfont.xtic = 
		NRM_X_RANGE * X_CELL_BITS / graphics.x_extent;

	/* The vertical size of a line of cell text is the size of	*/
	/* a scan line (NRM_Y_RANGE divided by the number of lines	*/
	/* we need) times the number of scan lines for a line of text.	*/
	/* Rearrange this for computational accuracy.			*/

	graphics.cellfont.ytic =
		NRM_Y_RANGE * Y_CELL_BITS / graphics.y_extent;

	graphics.cellfont.xmult = 1;	/* Cell size multipliers	*/
	graphics.cellfont.ymult = 1;

	graphics.default_strokefont.xtic
		 = graphics.strokefont.xtic = graphics.cellfont.xtic;
	graphics.default_strokefont.ytic
		= graphics.strokefont.ytic = graphics.cellfont.ytic;
	graphics.default_strokefont.xsize
		= graphics.strokefont.xsize = graphics.strokefont.xtic / 8;
	graphics.default_strokefont.ysize
		= graphics.strokefont.ysize = graphics.strokefont.ytic /10;
	graphics.default_strokefont.angle
		= graphics.strokefont.angle = 0;
	graphics.default_strokefont.slant
		= graphics.strokefont.slant = 0;
	graphics.default_strokefont.angle_flag
		= graphics.strokefont.angle_flag = FALSE;
	graphics.default_strokefont.slant_flag
		= graphics.strokefont.slant_flag = FALSE;

	/* Erase graphics memory and set video mode.  Anything beyond	*/
	/* MAXVIDEO is not a video board.  Assume it is a printer; no	*/
	/* need to clear memory.					*/

	if (graphics.grafmode <= MAXVIDEO)  {
		if (g_clear() != 0)  {
			system(MODEPROG);
			return(1);
		}
	}

	/* Initialize the p_do_pix function pointer to point to the	*/
	/* p_wr_pix routine (see the p_do_pix routine in		*/
	/* g_pixctl.c).  This corresponds to the current linestyle	*/
	/* value of SOLID.						*/

	p_do_pix = p_wr_pix;

	graphics.initialized = TRUE;

#if HAS_SIG
#if DO_CLEANUP
	/* Catch interrupt signals, and clean up before exiting.	 */
	gl_last_int_handler = signal(SIGINT, gl_sig_catch);
#endif /* DO_CLEANUP */
#endif /* HAS_SIG */

	return(0);
}

