/*	@(#) config.h 5.1 89/02/20	*/
/*
 *	Copyright (c) David T. Lewis 1987, 1988
 *	All rights reserved.
 *
 *	Permission is granted to use this for any personal noncommercial use.
 *	You may not distribute source or executable code for profit, nor
 *	may you distribute it with a commercial product without the written
 *	consent of the author.  Please send modifications to the author for
 *	inclusion in updates to the program.  Thanks.
 */

/* User modifiable parameters for GL graphics library.			*/
/* ===> BEGIN USER MODIFIABLE PARAMETERS <===				*/

/* Select one of the following to specify your target system (Xenix	*/
/* cross compile to MS_DOS should select MS_DOS).			*/

#define SVAT 1
#define XENIX_286 0
#define MS_DOS 0
#define UNIX_386 0	/* (not yet supported) */
#define XENIX_386 0	/* (not yet supported) */

/* If you defined MS_DOS 1, then specify your compiler here.		*/

#if MS_DOS
#define XEN2DOS 1	/* Compile on Xenix 286 for DOS target system	*/
#define USOFT 0		/* Microsoft C under DOS			*/
#define TCC 0		/* Borland Turbo-C				*/
#define MIX_C 0		/* The old CP/M derived MIX-C compiler		*/
#endif /* MS_DOS */

/* The following should be defined if you do NOT have a numeric		*/
/* coprocessor.  It will cause some trig functions to be done with	*/
/* integer math (see trig.c).						*/

#define NOFLOAT 1

/* The following should be defined if you want the gl library to handle	*/
/* interrupt signals.  This will clear the screen and return to text	*/
/* mode when the interrupt key (or ^C, for MS-DOS) is pressed.  If you	*/
/* need to do your own signal routine (to close files, for example),	*/
/* you may prefer not to have this defined.				*/

#define DO_CLEANUP 1

/* VIDEO stuff:								*/

/* Define the name of the program or shell script which will be used	*/
/* to switch video modes (UNIX only).  This will be made from either	*/
/* the mode.c program, or the mode.sh shell script, or some equivalent	*/
/* program that works with your system and video adapter.		*/

#define MODEPROG "mode"
/* Another possible choice:						*/
/* #define MODEPROG "/usr/local/bin/mode"				*/

/* Define the name of the environment variable that you wish to use to 	*/
/* indicate your default graphics mode.  If we call g_init(ENV_MODE),	*/
/* then we will use this environment variable to set the graphics mode.	*/

#define GL_ENV_MODE "GLMODE"

/* If the environment variable is not set, then fall back to 		*/
/* DEFAULT_MODE as a last resort.  Mode 4 is CGA color mode, a safe	*/
/* choice for most systems.						*/

#define DEFAULT_MODE 4

/* PRINTER stuff:							*/

/* Define name of the environment variable that you wish to set to 	*/
/* indicate your default print device.					*/

#define GL_PLOT_DEV "PLOTDEV"

/* For MS-DOS, define your printer device name (and ignore the rest	*/
/* of the printer stuff that follows).  Note: Microsoft compilers will	*/
/* send output to "stdprn" regardless of how you define this; other 	*/
/* compilers will use the device you define below.  See code in 	*/
/* g_finish.c if you need to change this.				*/

#define DOSPRINTER "PRN:"

/* Define the standard print spooler program for your system (UNIX).	*/

#define PRINTPROG "/usr/bin/lp"
#define LP_DEV_FLAG "-d"

/* Define the device to use if GL_PLOT_DEV is not set.			*/
/* Note:  Use "lp" only if you plan to manually put the printer		*/
/* driver in transparency mode (see lpset(1M)).				*/
/* On Microport, your printer devices might look something like the	*/
/* following, where /dev/lp is the standard printer driver, and		*/
/* /dev/lpt is the transparency mode printer driver.  See the "Readme"	*/
/* file for more information.						*/
/* 									*/
/* $ ls -li /dev/lp*							*/
/*   82 crw-rw-rw-   2 root     sys        7,  0 Oct  9 18:03 /dev/lp	*/
/*   82 crw-rw-rw-   2 root     sys        7,  0 Oct  9 18:03 /dev/lp0	*/
/*   83 crw-rw-rw-   1 root     sys        7,  1 Feb 11  1988 /dev/lp1	*/
/*  295 crw-rw-rw-   2 root     sys        7,128 Oct  9 18:08 /dev/lpt	*/
/*  295 crw-rw-rw-   2 root     sys        7,128 Oct  9 18:08 /dev/lpt0	*/
/*  291 crw-rw-rw-   1 root     sys        7,129 May 22 18:42 /dev/lpt1	*/

#define PRINTDEV "lpt"

/* You may need to tweak the following in order to get round circles.	*/

#define HERC_ASPECT_RATIO 0.7
#define CGA_ASPECT_RATIO 0.85
#define EGA_ASPECT_RATIO 0.6
#define IBM_PR_ASPECT_RATIO 0.7
#define LJ_PR_ASPECT_RATIO 0.81

/* For Xenix System V 286, you must indicate the video adapter you	*/
/* are using.  Microport users can ignore this (they must, however, 	*/
/* create a shared memory key with shmcreate(1).  MS-DOS users may	*/
/* also ignore this.							*/

#define GL_CGA 0
#define GL_EGA 1
#define GL_HERC 0
#define GL_PGA 0	/* (not implemented)				*/
#define GL_VGA 0	/* (easy to do, but not implemented)		*/

/* The following definitions specify the shared memory key identifiers	*/
/* which are used by Microport System V/AT.  You are free to use any	*/
/* identifiers you want to map to video memory with shmcreate(1).	*/
/* The following are the recommended values.  If you use these, the	*/
/* key values will be the same as the physical memory addresses.	*/
/* Change these definitions only if you are using different shared	*/
/* memory keys for your system.  Xenix users may ignore this.		*/

#define MCA_KEY 0xB0000L
#define CGA_KEY 0xB8000L
#define HERC_P0KEY 0xB0000L
#define HERC_P1KEY 0xB8000L
#define EGA_KEY 0xA0000L

/* ===> END USER MODIFIABLE PARAMETERS <===				*/

/* The following definitions specify the physical memory locations of	*/
/* video memory, for use with MS-DOS.					*/

#define DOS_MCA 0xB0000000L
#define DOS_CGA 0xB8000000L
#define DOS_H_P0 0xB0000000L
#define DOS_H_P1 0xB8000000L
#define DOS_EGA 0xA0000000L

/* Some specific system dependent characteristics.			*/

#if MIX_C
#define HAS_SIG 0	/* System does not have ^C interrupt handling	*/
#else
#if USOFT
#define HAS_SIG 0	/* System does not have ^C interrupt handling	*/
#else
#if XEN2DOS
#define HAS_SIG 0	/* System does not have ^C interrupt handling	*/
#else
#define HAS_SIG 1	/* System has ^C interrupt handling		*/
#endif /* XEN2DOS */
#endif /* USOFT */
#endif /* MIX_C */

#if MIX_C
#define HAS_ENV 0	/* System does not have getenv() call		*/
#else
#define HAS_ENV 1	/* System has getenv() call			*/
#endif /* MIX_C */

#if MS_DOS
#define HAS_PIPES 0	/* System does not have popen() call		*/
#else
#define HAS_PIPES 1	/* System has popen() call			*/
#endif /* MS_DOS */

#if USOFT
#define HAS_SLEEP 0	/* System does not have sleep() call		*/
#else
#if XEN2DOS
#define HAS_SLEEP 0	/* System does not have sleep() call		*/
#else
#if MIX_C
#define HAS_SLEEP 0	/* System does not have sleep() call		*/
#else
#define HAS_SLEEP 1	/* System has sleep() call			*/
#endif /* MIX_C */
#endif /* XEN2DOS */
#endif /* USOFT */

#if MIX_C
#define HAS_FMOD 0	/* System does not have fmod() call		*/
#else
#define HAS_FMOD 1	/* System has fmod() call			*/
#endif /* MIX_C */

#if MIX_C
#define HAS_ATAN2 0	/* System does not have atan2() call		*/
#else
#define HAS_ATAN2 1	/* System has atan2() call			*/
#endif /* MIX_C */

/* Some MS-DOS compilers have "stdprn" predefined for stream output to	*/
/* the printer.								*/

#if USOFT
#define HAS_STDPRN 1
#else
#if XEN2DOS
#define HAS_STDPRN 1
#else
#if TCC
#define HAS_STDPRN 1
#else /* "stdprn" is not predefined	*/
#define HAS_STDPRN 0
#endif /* TCC */
#endif /* XEN2DOS */
#endif /* USOFT */

/* The following should be defined for 286 versions, in which an	*/
/* integer is 16 bits.  Other machines must do extra work to check	*/
/* for out of range on the normalized 2-D screen space (0 through	*/
/* 32767).								*/

#if MS_DOS
#else
#if XENIX_286
#else
#if SVAT
#define INT16 1
#else	/* Not a 16 bit integer machine	*/
#define INT16 0
#endif /* SVAT */
#endif /* XENIX_286 */
#endif /* MS_DOS */

/* Parameter to signal call is system dependent.  Define a macro to 	*/
/* handle the difference between pointer to void and pointer to int.	*/

#if TCC
#define SIG_TYPE void
#else
#define SIG_TYPE int
#endif /* TCC */

/* Some compilers can use a macro for the calculation for transform 	*/
/* from normalized 2-D to screen coordinates.  If yours can't, then	*/
/* define N_TO_P_MACRO as 0.						*/
/* (All the compilers I've tried are working now with the macro.  Leave	*/
/* this here just in case...)						*/

#define N_TO_P_MACRO 1

/* Compiler specific stuff for MS-DOS.					*/

/* For MS-DOS, use the DO_BIOS macro to point to the library routine	*/
/* that invokes a BIOS call.  Int is the interrupt number, and reg 	*/
/* is a pointer to a structure representing machine registers.		*/
/* Define REGISTERS as the name of the data structure for machine	*/
/* registers (probably declared in <stdlib.h>).				*/
/* The remaining macros (AL, AH ...) specify individual registers	*/
/* within the REGISTERS data structure, as they would be referenced	*/
/* in a	REGISTERS structure (e.g. "inreg.AH").				*/

#if MIX_C
#define DO_BIOS(int,inreg,outreg) bios(int,inreg) 
#define REGISTERS REGS
#define AL byte.al
#define AH byte.ah
#define BL byte.bl
#define BH byte.bh
#define CL byte.cl
#define CH byte.ch
#define DL byte.dl
#define DH byte.dh
#endif /* MIX_C */

#if USOFT
#define DO_BIOS(int,inreg,outreg) int86(int,inreg,outreg)
#define REGISTERS union REGS
#define AL h.al
#define AH h.ah
#define BL h.bl
#define BH h.bh
#define CL h.cl
#define CH h.ch
#define DL h.dl
#define DH h.dh
#endif /* USOFT */

#if XEN2DOS
#define DO_BIOS(int,inreg,outreg) int86(int,inreg,outreg)
#define REGISTERS union REGS
#define AL h.al
#define AH h.ah
#define BL h.bl
#define BH h.bh
#define CL h.cl
#define CH h.ch
#define DL h.dl
#define DH h.dh
#endif /* XEN2DOS */

#if TCC
#define DO_BIOS(int,inreg,outreg) int86(int,inreg,outreg)
#define REGISTERS union REGS
#define AL h.al
#define AH h.ah
#define BL h.bl
#define BH h.bh
#define CL h.cl
#define CH h.ch
#define DL h.dl
#define DH h.dh
#endif /* TCC */

