
# @(#) msc.mak 5.1 89/02/20

# Makefile for MS-DOS with Microsoft C and the Microsoft "make" utility.
# Use the command "make msc.mak" to build the system.
#
# Edit the config.h file for your system before running make.
# Run "make" to build the GL library and demo programs.
# Follow instructions in the INSTALL file before running demos.

CC = msc
# Note:  Do NOT use the optimizer!  You must compile with the "/Od" switch.
CFLAGS = /AL /Od
LIB = lib

HDR = bitmaps.h cellfont.h config.h font.h graphics.h modes.h gl.h gf_types.h

OBJ1= g_clear.obj n_mvpen.obj n_draw.obj n_box.obj n_line.obj p_wr_pix.obj 
OBJ2= n_gfchar.obj n_gfstr.obj g_finish.obj c_cellch.obj c_cellst.obj 
OBJ3= c_cursor.obj g_pixctl.obj n_curves.obj n_point.obj plot.obj g_fntctl.obj 
OBJ4= xform.obj trig.obj machdep.obj g_init.obj g_print.obj

.c.obj:
	$(CC) $(CFLAGS) .c;
	$(LIB) gl.lib -+.obj;

gl.lib:	$(OBJ1) $(OBJ2) $(OBJ3) $(OBJ4) $(HDR)
	$(LIB) gl.lib;

demo.obj:	demo.c $(HDR)
	$(CC) $(CFLAGS) .c;

testpat.obj:	testpat.c $(HDR)
	$(CC) $(CFLAGS) .c;

xdemo.obj:	xdemo.c $(HDR)
	$(CC) $(CFLAGS) .c;

g_clear.obj:	g_clear.c $(HDR) 

n_mvpen.obj:	n_mvpen.c $(HDR)

n_draw.obj:	n_draw.c $(HDR)

n_box.obj:	n_box.c $(HDR)

n_line.obj:	n_line.c $(HDR)

p_wr_pix.obj:	p_wr_pix.c $(HDR)

n_gfchar.obj:	n_gfchar.c $(HDR)

n_gfstr.obj:	n_gfstr.c $(HDR)

g_finish.obj:	g_finish.c $(HDR)

c_cellch.obj:	c_cellch.c $(HDR)

c_cellst.obj:	c_cellst.c $(HDR)

c_cursor.obj:	c_cursor.c $(HDR)

g_pixctl.obj:	g_pixctl.c $(HDR)

n_curves.obj:	n_curves.c $(HDR)

n_point.obj:	n_point.c $(HDR)

plot.obj:	plot.c $(HDR)

g_fntctl.obj:	g_fntctl.c $(HDR)

xform.obj:	xform.c $(HDR)

trig.obj:	trig.c $(HDR)

machdep.obj:	machdep.c $(HDR)

g_print.obj:	g_print.c $(HDR)

g_init.obj:	g_init.c $(HDR)

demo.exe:	demo.obj testpat.obj gl.lib
	link demo.obj testpat.obj,demo.exe,,gl.lib;

xdemo.exe:	demo.obj testpat.obj gl.lib
	link xdemo.obj ,xdemo.exe,,gl.lib;


