#ifndef lint
static char sccsid[] = "@(#) g_fntctl.c 5.1 89/02/20";
#endif

/*
 *	Copyright (c) David T. Lewis 1988
 *	All rights reserved.
 *
 *	Permission is granted to use this for any personal noncommercial use.
 *	You may not distribute source or executable code for profit, nor
 *	may you distribute it with a commercial product without the written
 *	consent of the author.  Please send modifications to the author for
 *	inclusion in updates to the program.  Thanks.
 */

/* Control size, aspect ratio, spacing, angle and slant of stroke font.	*/
/* Size, aspect ratio and spacing control height, relative width and	*/
/* relative spacing of characters, with 1.0 selecting default values.	*/
/* Changing size will change the width and spacing appropriately.	*/
/* Changing width will change the spacing.				*/
/* Angle is the angle of a text string in radians, with positive	*/
/* values rotating the text clockwise.  Slant is the character slant	*/
/* in radians (typically a number on the order of 0.2), with positive	*/
/* values slanting the text to the "right," as in italics.		*/

#include "config.h"
#include "bitmaps.h"
#include "graphics.h"

extern struct GL_graphics graphics;

int g_fontctl(size, aspect_ratio, spacing, angle, slant)
float size, aspect_ratio, spacing, angle, slant;

{
	graphics.strokefont.xtic
		= (int)(size * aspect_ratio * spacing *
		(float)graphics.default_strokefont.xtic);
	graphics.strokefont.ytic
		= (int)(size * (float)graphics.default_strokefont.ytic);
	graphics.strokefont.xsize
		= (int)(size * aspect_ratio * 
		(float)graphics.default_strokefont.xsize);
	graphics.strokefont.ysize
		= (int)(size * (float)graphics.default_strokefont.ysize);
	graphics.strokefont.angle = angle;
	graphics.strokefont.slant = slant;

	if (angle == 0.0) graphics.strokefont.angle_flag = FALSE;
	else graphics.strokefont.angle_flag = TRUE;

	if (slant == 0.0) graphics.strokefont.slant_flag = FALSE;
	else graphics.strokefont.slant_flag = TRUE;

	return(0);
}

