#ifndef lint
static char sccsid[] = "@(#) demo.c 5.1 89/02/20";
#endif

/*
 *	Copyright (c) David T. Lewis 1987, 1988
 *	All rights reserved.
 *
 *	Permission is granted to use this for any personal noncommercial use.
 *	You may not distribute source or executable code for profit, nor
 *	may you distribute it with a commercial product without the written
 *	consent of the author.  Please send modifications to the author for
 *	inclusion in updates to the program.  Thanks.
 */

#include "config.h"
#include "gl.h"
#include <stdio.h>
#if MIX_C
#else
#include <time.h>
#endif /* MIX_C */

extern int lines(), strings(), chars(), strokeset(), fillscreen();
extern int charset(), ellipses(), arcs(), testplot(), showcursor();
extern int linestyles(), curvestyles();

static int mode;

void usage(progname)  
char *progname;
{
	fprintf (stderr,"Usage:  %s <mode>\n\n",progname);
	fprintf (stderr,"Where <mode> is:\n",0);
	fprintf (stderr,"\t4 (CGA 4 color 320 x 200)\n",0);
	fprintf (stderr,"\t6 (CGA 2 color 640 x 200)\n",0);
	fprintf (stderr,"\t8 (Hercules page 0, 720 x 348)\n",0);
	fprintf (stderr,"\t9 (Hercules page 1, 720 x 348)\n",0);
	fprintf (stderr,"\t16 (EGA color 640 x 350)\n",0);
	fprintf (stderr,"\t256 (IBM / Epson compatible printer)\n",0);
	fprintf (stderr,"\t257 (Laserjet+ printer)\n\n",0);
}

main(argc,argv)
int argc;
char *argv[];
{
	char str[80];
	long time();
	struct tm *gmtime();
	void srand();

	printf("\nThis demonstration will show the operation of the gl ",0);
	printf("graphics functions.\n",0);
	printf("The <delete> key stops the demo.  Press <return> ",0);
	printf("to view each\n",0);
	printf("successive screen.\n\n",0);
	printf("Note: The GLMODE shell variable may be used to specify ",0);
	printf("the graphics\n",0);
	printf("mode to use.\n\n",0);
	printf("Press <return> to continue...",0);
	gets(str);

	/* Get the mode to use. */

	if (argc < 2) mode = ENV_MODE;
	else if (argc == 2)  {
		if (sscanf(argv[1],"%d",&(mode)) != 1)  {
			usage(argv[0]);
			exit (1);
		}
	}
	else  {
		usage(argv[0]);
		exit (1);
	}

	/* Set video mode.	*/
	if (g_init(mode))  {
		usage(argv[0]);
		fprintf(stderr,"WARNING:  Possible invalid shared memory ",0);
		fprintf(stderr,"key for requested video mode.\n",0);
		exit (1);
	}

	/* Draw patterns.	*/

	if (mode > MAXVIDEO) printf("\nRasterizing output...",0);
	if (lines()) fprintf(stderr,"Failed call to lines().\n");
	if (mode > MAXVIDEO)
		printf("\nPress <Return> to send to printer...",0);
	gets(str);

	if (mode > MAXVIDEO) printf("\nRasterizing output...",0);
	g_clear();
	if (linestyles()) fprintf(stderr,"Failed call to linestyles().\n");
	if (mode > MAXVIDEO)
		printf("\nPress <Return> to send to printer...",0);
	gets(str);

	if (mode > MAXVIDEO) printf("\nRasterizing output...",0);
	g_clear();
	if (strings()) fprintf(stderr,"Failed call to strings().\n");
	if (mode > MAXVIDEO)
		printf("\nPress <Return> to send to printer...",0);
	gets(str);

	if (mode > MAXVIDEO) printf("\nRasterizing output...",0);
	g_clear();
	slanttext();
	if (mode > MAXVIDEO)
		printf("\nPress <Return> to send to printer...",0);
	gets(str);

	if (mode > MAXVIDEO) printf("\nRasterizing output...",0);
	g_clear();
	strokeset();
	if (mode > MAXVIDEO)
		printf("\nPress <Return> to send to printer...",0);
	gets(str);

	if (mode > MAXVIDEO) printf("\nRasterizing output...",0);
	g_clear();
	if (chars()) fprintf(stderr,"Failed call to chars().\n");
	if (mode > MAXVIDEO)
		printf("\nPress <Return> to send to printer...",0);
	gets(str);

	if (mode > MAXVIDEO) printf("\nRasterizing output...",0);
	g_clear();
	fillscreen();
	if (mode > MAXVIDEO)
		printf("\nPress <Return> to send to printer...",0);
	gets(str);

	if (mode > MAXVIDEO) printf("\nRasterizing output...",0);
	g_clear();
	charset();
	if (mode > MAXVIDEO)
		printf("\nPress <Return> to send to printer...",0);
	gets(str);

	if (mode > MAXVIDEO) printf("\nRasterizing output...",0);
	g_clear();
	ellipses();
	if (mode > MAXVIDEO)
		printf("\nPress <Return> to send to printer...",0);
	gets(str);

	if (mode > MAXVIDEO) printf("\nRasterizing output...",0);
	g_clear();
	curvestyles();
	if (mode > MAXVIDEO)
		printf("\nPress <Return> to send to printer...",0);
	gets(str);

	if (mode > MAXVIDEO) printf("\nRasterizing output...",0);
	g_clear();
	arcs();
	showcursor();

	g_finish();

	printf("\n\n\n\nThe next demonstration screen will use the ",0);
	printf("plot(3) interface, rather than\n",0);
	printf("direct calls to the gl library.  The plot(3) interface ",0);
	printf("determines graphic \n",0);
	printf("mode from the GLMODE shell variable, or if GLMODE is not ",0);
	printf("defined, uses a \n",0);
	printf("default mode value (defined in config.h). \n\n",0);
	printf("If you called this program with an argument on the ",0);
	printf("command line, the \n",0);
	printf("next screen may use a different graphics mode ",0);
	printf("than you specified. \n\n",0);
	printf("Press <return> to continue or <delete> to stop...",0);

	gets(str);

	testplot();
	gets(str);
}
