/*****************************************************************
 * tga2fbm.c: FBM Library 0.93 (Beta test) 03-May-89  Michael Mauldin
 *
 * Copyright (C) 1989 by Michael Mauldin.  Permission is granted to
 * use this file in whole or in part provided that you do not sell it
 * for profit and that this copyright notice is retained unchanged.
 *
 * tga2fbm.c: convert a bitmap to Targa format
 *
 * USAGE
 *	% tga2fbm [ image ] > image.tga
 *
 * EDITLOG
 *	LastEditDate = Wed May  3 21:50:43 1989 - Michael Mauldin
 *	LastFileName = /usr2/mlm/src/misc/fbm/tga2fbm.c
 *
 * HISTORY
 * 03-May-89  Michael Mauldin (mlm) at Carnegie Mellon University
 *	Beta release (version 0.93) mlm@cs.cmu.edu
 *****************************************************************/

# include <stdio.h>
# include <math.h>
# include "fbm.h"

# define USAGE\
"Usage: tga2fbm [ image ] > image.tga"

#ifndef lint
static char *fbmid =
	"$FBM tga2fbm.c <0.93> 03-May-89  (C) 1989 by Michael Mauldin$";
#endif

main (argc, argv)
int argc;
char *argv[];
{ FBM image;

  /* Clear pointers */
  image.cm = image.bm = (unsigned char *) NULL;

  /* Open input if given */
  if (argc > 1)
  { if (freopen (argv[1], "r", stdin) != stdin)
    { perror (argv[1]);
      exit(1);
    }
  }

  if (read_tga (&image, stdin, "", 0) &&
       write_fbm (&image, stdout))
  { exit(0); }
  else
  { exit (1); }
}

