/*****************************************************************
 * flrdfb.c: FBM Library 0.9 (Beta test) 07-Mar-89  Michael Mauldin
 *
 * Copyright (C) 1989 by Michael Mauldin.  Permission is granted to
 * use this file in whole or in part provided that you do not sell it
 * for profit and that this copyright notice is retained unchanged.
 *
 * flrdfb.c: 
 *
 * CONTENTS
 *	read_fbm (image, rfile, mstr, mlen)
 *	read_hdr_fbm (image, rfile, mstr, mlen)
 *
 * EDITLOG
 *	LastEditDate = Tue Mar  7 19:57:26 1989 - Michael Mauldin
 *	LastFileName = /usr2/mlm/src/misc/fbm/flrdfb.c
 *
 * HISTORY
 * 07-Mar-89  Michael Mauldin (mlm) at Carnegie Mellon University
 *	Beta release (version 0.9) mlm@cs.cmu.edu
 *
 * 12-Nov-88  Michael Mauldin (mlm) at Carnegie-Mellon University
 *	Created.
 *****************************************************************/

# include <stdio.h>
# include <math.h>
# include <ctype.h>
# include "fbm.h"

/****************************************************************
 * read_fbm: Read an FBM format bitmap into memory
 ****************************************************************/

#ifndef lint
static char *fbmid =
	"$FBM flrdfb.c <0.9> 07-Mar-89  (C) 1989 by Michael Mauldin$";
#endif

read_fbm (image, rfile, mstr, mlen)
register FBM *image;
register FILE *rfile;
char *mstr;
int mlen;
{ register int j, k, rowlen, plnlen;
  register unsigned char *bmptr;

  if (!read_hdr_fbm (image, rfile, mstr, mlen))
  { return (0); }

  alloc_fbm (image);

  rowlen = image->hdr.rowlen;
  plnlen = image->hdr.plnlen;

  if (image->hdr.clrlen >  0)
  { if (! fread (image->cm, image->hdr.clrlen, 1, rfile))
    { fprintf (stderr, "can't read colormap (%d bytes)\n", image->hdr.clrlen);
      return (0);
    }
  }

  for (k=0; k<image->hdr.planes; k++)
  { bmptr = &(image->bm[k*plnlen]);

    for (j=0; j < image->hdr.rows; j++, bmptr += rowlen)
    { if (fread (bmptr, 1, rowlen, rfile) != rowlen)
      { fprintf (stderr, "premature EOF on input\n");
        return (0);
      }
    }
  }
    
  return (1);
}

/****************************************************************
 * read_hdr_fbm: Read an FBM format bitmap header into memory
 ****************************************************************/

read_hdr_fbm (image, rfile, mstr, mlen)
register FBM *image;
register FILE *rfile;
char *mstr;
int mlen;
{ FBMFILEHDR file_hdr;
  register char *hp;

  hp = (char *) &file_hdr;

  if (mlen > 0) strncpy (hp, mstr, mlen);

  if (! fread (hp+mlen, sizeof (file_hdr) - mlen, 1, rfile))
  { perror ("read_fbm (header)"); return (0); }

  if (strncmp (FBM_MAGIC, file_hdr.magic, 2) != 0)
  { fprintf (stderr, "Bad magic number, input is not an FBM image\n");
    return (0);
  }

  image->hdr.cols = atoi (file_hdr.cols);
  image->hdr.rows = atoi (file_hdr.rows);
  image->hdr.planes = atoi (file_hdr.planes);
  image->hdr.bits = atoi (file_hdr.bits);
  image->hdr.physbits = atoi (file_hdr.physbits);
  image->hdr.rowlen = atoi (file_hdr.rowlen);
  image->hdr.plnlen = atoi (file_hdr.plnlen);
  image->hdr.clrlen = atoi (file_hdr.clrlen);
  image->hdr.aspect = atof (file_hdr.aspect);
  strncpy (image->hdr.title, file_hdr.title, FBM_MAX_TITLE);
  strncpy (image->hdr.credits, file_hdr.credits, FBM_MAX_TITLE);
    
  if (image->hdr.cols < 1 || image->hdr.cols > 32767)
  { fprintf (stderr, "Invalid number of cols (%d) on input\n",
	     image->hdr.cols);
    return (0);
  }

  if (image->hdr.rows < 1 || image->hdr.rows > 32767)
  { fprintf (stderr, "Invalid number of rows (%d) on input\n",
	     image->hdr.rows);
    return (0);
  }

  if (image->hdr.planes != 1 && image->hdr.planes != 3)
  { fprintf (stderr, "Invalid number of planes (%d) on input %s\n",
	     image->hdr.planes, "(must be 1 or 3)");
    return (0);
  }

  if (image->hdr.bits < 1 || image->hdr.bits > 8)
  { fprintf (stderr, "Invalid number of bits (%d) on input %s\n",
	     image->hdr.bits, "(must be [1..8])");
    return (0);
  }

  if (image->hdr.physbits != 1 && image->hdr.physbits != 8)
  { fprintf (stderr, "Invalid number of physbits (%d) on input %s\n",
	     image->hdr.physbits, "(must be 1 or 8)");
    return (0);
  }

  if (image->hdr.rowlen < 1 || image->hdr.rowlen > 32767)
  { fprintf (stderr, "Invalid row length (%d) on input\n",
	     image->hdr.rowlen);
    return (0);
  }

  if (image->hdr.planes > 1 && image->hdr.plnlen < 1)
  { fprintf (stderr, "Invalid plane length (%d) on input\n",
	     image->hdr.plnlen);
    return (0);
  }

  if (image->hdr.aspect < 0.01 || image->hdr.aspect > 100.0)
  { fprintf (stderr, "Invalid aspect ratio %lg on input\n",
	     image->hdr.aspect);
    return (0);
  }

  return (1);
}
