/*****************************************************************
 * flalfb.c: FBM Library 0.9 (Beta test) 07-Mar-89  Michael Mauldin
 *
 * Copyright (C) 1989 by Michael Mauldin.  Permission is granted to
 * use this file in whole or in part provided that you do not sell it
 * for profit and that this copyright notice is retained unchanged.
 *
 * flalfb.c: Fuzzy bitmap allocation
 *
 * CONTENTS
 *	alloc_fbm (image)
 *	free_fbm (image)
 *
 * EDITLOG
 *	LastEditDate = Tue Mar  7 19:56:45 1989 - Michael Mauldin
 *	LastFileName = /usr2/mlm/src/misc/fbm/flalfb.c
 *
 * HISTORY
 * 07-Mar-89  Michael Mauldin (mlm) at Carnegie Mellon University
 *	Beta release (version 0.9) mlm@cs.cmu.edu
 *
 * 12-Nov-88  Michael Mauldin (mlm) at Carnegie-Mellon University
 *	Created.
 *****************************************************************/

# include <stdio.h>
# include <math.h>
# include <ctype.h>
# include "fbm.h"

/****************************************************************
 * alloc_fbm: Allocate enough bytes for the bitmap and colormap
 *	of an image where the header has already been filled in.
 ****************************************************************/

#ifndef lint
static char *fbmid =
	"$FBM flalfb.c <0.9> 07-Mar-89  (C) 1989 by Michael Mauldin$";
#endif

alloc_fbm (image)
FBM *image;
{ unsigned bmsize, cmsize;

  if (! free_fbm (image)) return (0);

  /* Calculate bytes needed */
  bmsize = (image->hdr.planes * image->hdr.plnlen);
  cmsize = image->hdr.clrlen;
  
  if (! (image->bm = (unsigned char *) malloc (bmsize)) ||
      (cmsize && ! (image->cm = (unsigned char *) malloc (cmsize))))
  { perror ("alloc_fbm"); exit (1); }

  return (1);
}

/****************************************************************
 * free_fbm: Free the storage allocate by alloc_fbm
 ****************************************************************/

free_fbm (image)
FBM *image;
{
  if (image->bm)
  { free ((char *) image->bm); image->bm = (unsigned char *) NULL; }

  if (image->cm)
  { free ((char *) image->cm); image->cm = (unsigned char *) NULL; }

  return (1);
}
