/*****************************************************************
 * fbm2tga.c: FBM Library 0.93 (Beta test) 03-May-89  Michael Mauldin
 *
 * Copyright (C) 1989 by Michael Mauldin.  Permission is granted to
 * use this file in whole or in part provided that you do not sell it
 * for profit and that this copyright notice is retained unchanged.
 *
 * fbm2tga.c: convert a bitmap to Targa format
 *
 * USAGE
 *	% fbm2tga [ image ] > image.tga
 *
 * EDITLOG
 *	LastEditDate = Wed May  3 21:50:43 1989 - Michael Mauldin
 *	LastFileName = /usr2/mlm/src/misc/fbm/fbm2tga.c
 *
 * HISTORY
 * 03-May-89  Michael Mauldin (mlm) at Carnegie Mellon University
 *	Beta release (version 0.93) mlm@cs.cmu.edu
 *****************************************************************/

# include <stdio.h>
# include <math.h>
# include "fbm.h"

# define USAGE\
"Usage: fbm2tga [ image ] > image.tga"

#ifndef lint
static char *fbmid =
	"$FBM fbm2tga.c <0.93> 03-May-89  (C) 1989 by Michael Mauldin$";
#endif

main (argc,argv)
int argc; char *argv[];
{ FBM image;

  /* Clear pointers */
  image.cm = image.bm = (unsigned char *) NULL;

  /* Read anything, write targa */
  if (read_bitmap (&image, (argc > 0) ? *argv : (char *) NULL) &&
      write_tga (&image, stdout))
  {
    exit (0);
  }
  else
  { exit (1); }
}
