/*****************************************************************
 * fbedge.c: FBM Library 0.9 (Beta test) 07-Mar-89  Michael Mauldin
 *
 * Copyright (C) 1989 by Michael Mauldin & Gary Sherwin.
 * Permission is granted to use this file in whole or in part provided
 * that you do not sell it for profit and that this copyright notice
 * is retained unchanged.
 *
 * fbedge.c: Take derivative and edge detect image
 *
 * USAGE
 *      % fbedge [ flag ] < image > image2
 *
 * EDITLOG
 *	New Filename = fbedge.c  Mon Nov 7 09:24:00 1988 - Gary Sherwin
 *	LastEditDate = Mon Oct 31 08:34:55 1988 - Michael Mauldin
 *	LastFileName = /usr2/mlm/src/misc/images/bsharp.c
 *      LastEditDate = Tue Mar  7 17:50:04 1989 - Michael Mauldin
 *      LastFileName = /usr2/mlm/src/misc/fbm/fbedge.c
 *
 * HISTORY
 * 07-Mar-89  Michael Mauldin (mlm) at Carnegie Mellon University
 *	Beta release (version 0.9) mlm@cs.cmu.edu
 *
 * 07-Nov-88  Gary W. Sherwin (sherwin) at Westinghouse R&D
 *	Changed to fbedge.
 *
 * 10-Sep-88  Michael Mauldin (mlm) at Carnegie-Mellon University
 *	Created.
 *****************************************************************/

# include <stdio.h>
# include <math.h>
# include "fbm.h"

# define USAGE "Usage: fbedge [ -t<threshhold> ] < bitmap > bitmap"

#ifndef lint
static char *fbmid =
	"$FBM fbedge.c <0.9> 07-Mar-89  (C) 1989 by Michael Mauldin$";
#endif

main (argc, argv)
char *argv[];
{ int w, h, k;
  int blacktrp = 0;
  int outtype = DEF_1BIT;
  FBM input, output;

  /* Get the options */
  while (--argc > 0 && (*++argv)[0] == '-')
  { while (*++(*argv))
    { switch (**argv)
      { case 't':	blacktrp = atoi (*argv+1); SKIPARG; break;
	case 'A':	outtype = FMT_ATK; break;
	case 'B':	outtype = FMT_FACE; break;
	case 'F':	outtype = FMT_FBM; break;
	case 'G':	outtype = FMT_GIF; break;
	case 'I':	outtype = FMT_IFF; break;
	case 'L':	outtype = FMT_LEAF; break;
	case 'M':	outtype = FMT_MCP; break;
	case 'P':	outtype = FMT_PBM; break;
	case 'S':	outtype = FMT_SUN; break;
	case 'T':	outtype = FMT_TIFF; break;
	case 'X':	outtype = FMT_X11; break;
	case 'Z':	outtype = FMT_PCX; break;
        default:        fprintf (stderr, "%s\n", USAGE);
                        exit (1);
      }
    }
  }
  
  /* Clear the memory pointers so alloc_fbm won't be confused */
  input.cm  = input.bm  = (unsigned char *) NULL;
  output.cm = output.bm = (unsigned char *) NULL;

  /* Read the image and clean it */
  if (read_bitmap (&input, (char *) NULL))
  {
    if (input.hdr.bits != 8 || input.hdr.physbits != 8)
    { fprintf (stderr,
	       "Can't handle images with %d bits and %d physbits per pixel\n",
	       input.hdr.bits, input.hdr.physbits);
      exit (1);
    }

    /* Determine output height & width (oh*ow <= size) */
    h = input.hdr.rows;
    w = input.hdr.cols;
    k = input.hdr.planes;

    fprintf (stderr,
	     "Edge detect\"%s\", Black-trip %2d [%dx%dx%d]\n",
	     input.hdr.title[0] ? input.hdr.title : "(untitled)",
	     blacktrp, w, h, k);

    /* Edge detect the image using a digitial Laplacian */
    if (findedge_fbm (&input, &output, blacktrp) &&
        write_bitmap (&output, stdout, outtype))
    { exit (0); }
  }
  
  exit (1);
}
