/*****************************************************************
 * fbclean.c: FBM Library 0.9 (Beta test) 07-Mar-89  Michael Mauldin
 *
 * Copyright (C) 1989 by Michael Mauldin & Gary Sherwin.
 * Permission is granted to use this file in whole or in part provided
 * that you do not sell it for profit and that this copyright notice
 * is retained unchanged.
 *
 * fbclean.c: Normalize contrast and brightness of image
 *
 * USAGE
 *      % fbclean [ flag ] < image > image2
 *
 * EDITLOG
 *	New Filename = fbclean.c  Mon Nov 7 09:24:00 1988 - Gary Sherwin
 *	LastEditDate = Mon Oct 31 08:34:55 1988 - Michael Mauldin
 *	LastFileName = /usr2/mlm/src/misc/images/bsharp.c
 *      LastEditDate = Tue Mar  7 17:46:17 1989 - Michael Mauldin
 *      LastFileName = /usr2/mlm/src/misc/fbm/fbclean.c
 *
 * HISTORY
 * 07-Mar-89  Michael Mauldin (mlm) at Carnegie Mellon University
 *	Beta release (version 0.9) mlm@cs.cmu.edu
 *
 * 07-Nov-88  Gary W. Sherwin (sherwin) at Westinghouse R&D
 *	Changed to fbclean.
 *
 * 10-Sep-88  Michael Mauldin (mlm) at Carnegie-Mellon University
 *	Created.
 *****************************************************************/

# include <stdio.h>
# include <math.h>
# include "fbm.h"

# define USAGE \
  "Usage: fbclean [ -b<cleaner> -t<threshhold> -n<nbr> ]\n\
	       [ -<type> ] < bitmap > bitmap"

#ifndef lint
static char *fbmid =
	"$FBM fbclean.c <0.9> 07-Mar-89  (C) 1989 by Michael Mauldin$";
#endif

main (argc, argv)
char *argv[];
{ int w, h, k;
  int cleaner = 5;
  int blacktrp = 0;
  int nbr = 5;
  int outtype = DEF_1BIT;
  FBM input, output;

  /* Get the options */
  while (--argc > 0 && (*++argv)[0] == '-')
  { while (*++(*argv))
    { switch (**argv)
      { case 'b':       cleaner = atoi (*argv+1); SKIPARG; break;
        case 't':	blacktrp = atoi (*argv+1); SKIPARG; break;
        case 'n':	nbr = atoi (*argv+1); SKIPARG; break;
	case 'A':	outtype = FMT_ATK; break;
	case 'B':	outtype = FMT_FACE; break;
	case 'F':	outtype = FMT_FBM; break;
	case 'G':	outtype = FMT_GIF; break;
	case 'I':	outtype = FMT_IFF; break;
	case 'L':	outtype = FMT_LEAF; break;
	case 'M':	outtype = FMT_MCP; break;
	case 'P':	outtype = FMT_PBM; break;
	case 'S':	outtype = FMT_SUN; break;
	case 'T':	outtype = FMT_TIFF; break;
	case 'X':	outtype = FMT_X11; break;
	case 'Z':	outtype = FMT_PCX; break;
        default:        fprintf (stderr, "%s\n", USAGE);
                        exit (1);
      }
    }
  }
  
  /* Clear the memory pointers so alloc_fbm won't be confused */
  input.cm  = input.bm  = (unsigned char *) NULL;
  output.cm = output.bm = (unsigned char *) NULL;

  /* Read the image and clean it */
  if (read_bitmap (&input, (char *) NULL))
  {
    if (input.hdr.bits != 8 || input.hdr.physbits != 8)
    { fprintf (stderr,
	       "Can't handle images with %d bits and %d physbits per pixel\n",
	       input.hdr.bits, input.hdr.physbits);
      exit (1);
    }

    /* Determine output height & width (oh*ow <= size) */
    h = input.hdr.rows;
    w = input.hdr.cols;
    k = input.hdr.planes;

    fprintf (stderr,
	     "Cleaning \"%s\", # of Neighbors %2d, nbr %d [%dx%dx%d]\n",
	     input.hdr.title[0] ? input.hdr.title : "(untitled)",
	     cleaner, nbr, w, h, k);

    /* Clean the image using a digitial Laplacian */
    if (clean_fbm (&input, &output, cleaner, blacktrp, nbr) &&
        write_bitmap (&output, stdout, outtype))
    { exit (0); }
  }
  
  exit (1);
}
