/*****************************************************************
 * raw2fbm.c: FBM Library 0.94 (Beta test) 20-May-89  Michael Mauldin
 *
 * Copyright (C) 1989 by Michael Mauldin.  Permission is granted to
 * use this file in whole or in part provided that you do not sell it
 * for profit and that this copyright notice is retained unchanged.
 *
 * raw2fbm.c: Convert raw format (for example Amiga rasters)
 *
 * USAGE
 *	 % raw2fbm -t'title'
 *		   -c'credits'
 *		   -a<aspect>
 *		   -w<width>
 *		   -h<height>
 *		   -d'<planes>	< rawfile > fbm
 *
 * EDITLOG
 *	LastEditDate = Sat May 20 19:07:44 1989 - Michael Mauldin
 *	LastFileName = /usr2/mlm/src/misc/fbm/raw2fbm.c
 *
 * HISTORY
 * 20-May-89  Michael Mauldin (mlm) at Carnegie Mellon University
 *	Bug fix from Dave Cohrs <dave@cs.wisc.edu>
 *
 * 07-Mar-89  Michael Mauldin (mlm) at Carnegie Mellon University
 *	Beta release (version 0.9) mlm@cs.cmu.edu
 *
 * 20-Aug-88  Michael Mauldin (mlm) at Carnegie-Mellon University
 *	Created.
 *****************************************************************/

# include <stdio.h>
# include "fbm.h"

# define USAGE \
"Usage: raw2fbm [ -t'title' -c'credits' -a<aspect>\n\
		 -w<width> -h<height> -d'<planes> ] < rawfile > fbm"

#ifndef lint
static char *fbmid =
	"$FBM raw2fbm.c <0.94> 20-May-89  (C) 1989 by Michael Mauldin$";
#endif

main (argc, argv)
char *argv[];
{ register int j, k, rowlen;
  double aspect = 1.2;	/* Default for Digiview 640x400 bitmaps */
  int rows = 400, cols = 640, planes = 1;
  FBMHDR hdr;
  unsigned char *buf;
  char title[FBM_MAX_TITLE], credits[FBM_MAX_TITLE];

  title[0] = '\0';
  credits[0] = '\0';

  /* Get the options */
  while (--argc > 0 && (*++argv)[0] == '-')
  { while (*++(*argv))
    { switch (**argv)
      { case 'a':	aspect  = atof (*argv+1); SKIPARG; break;
	case 'w':	cols   = atoi (*argv+1); SKIPARG; break;
	case 'h':	rows  = atoi (*argv+1); SKIPARG; break;
	case 'd':	planes   = atoi (*argv+1); SKIPARG; break;
	case 't':	strncpy (title, *argv+1, FBM_MAX_TITLE);
			title[FBM_MAX_TITLE-1] = '\0';
			CLRARG; break;
	case 'c':	strncpy (credits, *argv+1, FBM_MAX_TITLE);
			credits[FBM_MAX_TITLE-1] = '\0';
			CLRARG; break;
	default:	fprintf (stderr, "%s\n", USAGE);
			exit (1);
      }
    }
  }

  if (argc > 0)		cols = atoi (argv[0]);
  if (argc > 1)		rows = atoi (argv[1]);
  if (argc > 2)		planes = atoi (argv[2]);
  if (argc > 3)		aspect = atof (argv[3]);
  
  if (cols < 1 || rows < 1)
  { fprintf (stderr, "Both width (%d) and height (%d) must be positive\n",
	     cols, rows);
    exit (1);
  }

  if (planes != 1 && planes != 3)
  { fprintf (stderr, "Depth must be 1 for B+W or 3 for RGB color\n");
    exit (1);
  }

  if (aspect < 0.01 || aspect > 100.0)
  { fprintf (stderr, "Pixel aspect ratio (%lg) must be in [0.01 to 100.0]\n",
	     aspect);
    exit (1);
  }

  rowlen = 2 * ((cols * 8 + 15) / 16);

  /* Build header */
  hdr.rows = rows;
  hdr.cols = cols;
  hdr.planes = planes;
  hdr.bits = 8;
  hdr.physbits = 8;
  hdr.rowlen = rowlen;
  hdr.plnlen = hdr.rowlen * rows;
  hdr.clrlen = 0;
  hdr.aspect = aspect;
  strcpy (hdr.title, title);
  strcpy (hdr.credits, credits);
  
  write_hdr_fbm (&hdr, stdout);
  
  buf = (unsigned char *) malloc (cols);
  
  for (k=0; k<planes; k++)
  { for (j=0; j<rows; j++)  
    { if (! fread (buf, cols, 1, stdin))
      { fprintf (stdout, "premature end of file on input\n");
        exit (1);
      }

      if (! fwrite (buf, rowlen, 1, stdout))
      { perror ("raw2fbm"); exit (1); }
    }
  }
  
  exit (0);
}
