/*****************************************************************
 * flbyte.c: FBM Library 0.94 (Beta test) 20-May-89  Michael Mauldin
 *
 * Copyright (C) 1989 by Michael Mauldin.  Permission is granted to
 * use this file in whole or in part provided that you do not sell it
 * for profit and that this copyright notice is retained unchanged.
 *
 * flbyte.c: 
 *
 * CONTENTS
 *	get_long (rfile, order)
 *	get_short (rfile, order)
 *	put_long (long, wfile, order)
 *	put_short (word, wfile, order)
 *	machine_byte_order ()
 *
 *	order	BIG	msb first (Sun, IBM-RT, 68000)
 *		LITTLE	lsb first (Vax, 6502)
 *
 * EDITLOG
 *	LastEditDate = Sat May 20 19:11:04 1989 - Michael Mauldin
 *	LastFileName = /usr2/mlm/src/misc/fbm/flbyte.c
 *
 * HISTORY
 * 20-May-89  Michael Mauldin (mlm) at Carnegie Mellon University
 *	Bug fix from Dave Cohrs <dave@cs.wisc.edu>
 *
 * 07-Mar-89  Michael Mauldin (mlm) at Carnegie Mellon University
 *	Beta release (version 0.9) mlm@cs.cmu.edu
 *
 * 12-Nov-88  Michael Mauldin (mlm) at Carnegie-Mellon University
 *	Created.
 *****************************************************************/

# include <stdio.h>
# include "fbm.h"

/****************************************************************
 * get_long: get a long integer from a file
 ****************************************************************/

#ifndef lint
static char *fbmid =
	"$FBM flbyte.c <0.9> 07-Mar-89  (C) 1989 by Michael Mauldin$";
#endif

long
get_long (file, order)
FILE *file;
int order;
{ register long word;

  if (order == BIG)
  { word = fgetc (file) & 0x0ff;
    word = word << 8 | (fgetc (file) & 0x0ff);
    word = word << 8 | (fgetc (file) & 0x0ff);
    word = word << 8 | (fgetc (file) & 0x0ff);
  }
  else
  { word = fgetc (file) & 0x0ff;
    word = word | ((fgetc (file) & 0x0ff) << 8);
    word = word | ((fgetc (file) & 0x0ff) << 16);
    word = word | ((fgetc (file) & 0x0ff) << 24);
  }

  return (word);
}

/****************************************************************
 * put_long: Write a long integer to a file
 ****************************************************************/

put_long (word, file, order)
register long word;
FILE *file;
int order;
{
  if (order == BIG)
  { fputc ((word >> 24) & 0x0ff, file);	/* Put out biggest byte */
    fputc ((word >> 16) & 0x0ff, file);	/* Put out 2nd byte */
    fputc ((word >> 8) & 0x0ff, file);	/* Put out 3rd byte */
    fputc (word & 0x0ff, file);		/* Put out littlest byte */
  }
  else
  { fputc (word & 0x0ff, file);		/* Put out littlest byte */
    fputc ((word >> 8) & 0x0ff, file);	/* Put out 3rd byte */
    fputc ((word >> 16) & 0x0ff, file);	/* Put out 2nd byte */
    fputc ((word >> 24) & 0x0ff, file);	/* Put out biggest byte */
  }
}

/****************************************************************
 * get_short: get a short integer from a file
 ****************************************************************/

get_short (file, order)
FILE *file;
int order;
{ register int word;

  if (order == BIG)
  { word = fgetc (file) & 0x0ff;
    word = word << 8 | (fgetc (file) & 0x0ff);
  }
  else
  { word = fgetc (file) & 0x0ff;
    word = word | ((fgetc (file) & 0x0ff) << 8);
  }

  return (word);
}

/****************************************************************
 * put_short: Write a short integer to a file
 ****************************************************************/

put_short (word, file, order)
register int word;
FILE *file;
int order;
{
  if (order == BIG)
  { fputc ((word >> 8) & 0x0ff, file);	/* Put out 3rd byte */
    fputc (word & 0x0ff, file);		/* Put out littlest byte */
  }
  else
  { fputc (word & 0x0ff, file);		/* Put out littlest byte */
    fputc ((word >> 8) & 0x0ff, file);	/* Put out 3rd byte */
  }
}

/****************************************************************
 * machine_byte_order: Return BIG or LITTLE for the current machine
 ****************************************************************/

machine_byte_order ()
{ short testshort;
  char *teststr = (char*) &testshort;

  teststr[0] = '\1'; teststr[1] = '\0';

  if (testshort == 1)
  { return (LITTLE); }
  else
  { return (BIG); }
}
