/*****************************************************************
 * fbmask.c: FBM Library 0.9 (Beta test) 07-Mar-89  Michael Mauldin
 *
 * Copyright (C) 1989 by Michael Mauldin.  Permission is granted to
 * use this file in whole or in part provided that you do not sell it
 * for profit and that this copyright notice is retained unchanged.
 *
 * fbmask.c: Mask a rectangle with a value (or average)
 *
 * USAGE
 *	% fbmask [ flags ] arguments
 *
 * EDITLOG
 *	LastEditDate = Tue Mar  7 19:56:33 1989 - Michael Mauldin
 *	LastFileName = /usr2/mlm/src/misc/fbm/fbmask.c
 *
 * HISTORY
 * 07-Mar-89  Michael Mauldin (mlm) at Carnegie Mellon University
 *	Beta release (version 0.9) mlm@cs.cmu.edu
 *
 * 29-Aug-88  Michael Mauldin (mlm) at Carnegie-Mellon University
 *	Created.
 *****************************************************************/

# include <stdio.h>
# include <math.h>
# include "fbm.h"

# define USAGE "Usage: fbmask [ -<type> ] x0 y0 x1 y1 value < 8bit > 8bit"

#ifndef lint
static char *fbmid =
	"$FBM fbmask.c <0.9> 07-Mar-89  (C) 1989 by Michael Mauldin$";
#endif

main (argc, argv)
char *argv[];
{ FBM image;
  register int j, i, val, rowlen;
  int x1, x0, y1, y0, n;
  int outtype = DEF_8BIT;

  /* Clear the memory pointer so alloc_fbm won't be confused */
  image.cm  = image.bm  = (unsigned char *) NULL;

  /* Get the options */
  while (--argc > 0 && (*++argv)[0] == '-')
  { while (*++(*argv))
    { switch (**argv)
      {
	case 'A':	outtype = FMT_ATK; break;
	case 'B':	outtype = FMT_FACE; break;
	case 'F':	outtype = FMT_FBM; break;
	case 'G':	outtype = FMT_GIF; break;
	case 'I':	outtype = FMT_IFF; break;
	case 'L':	outtype = FMT_LEAF; break;
	case 'M':	outtype = FMT_MCP; break;
	case 'P':	outtype = FMT_PBM; break;
	case 'S':	outtype = FMT_SUN; break;
	case 'T':	outtype = FMT_TIFF; break;
	case 'X':	outtype = FMT_X11; break;
	case 'Z':	outtype = FMT_PCX; break;
	default:        fprintf (stderr, "%s\n", USAGE);
                        exit (1);
      }
    }
  }

  /* Get arguments */
  if (argc != 5)
  { fprintf (stderr, "%s\n", USAGE);
    exit (1);
  }

  x0  = atoi (argv[0]);
  y0  = atoi (argv[1]);
  x1  = atoi (argv[2]);
  y1  = atoi (argv[3]);
  val = atoi (argv[4]);
  
  /* Assure x0<x1 and y0<y1, swap if necessary */
  if (x0 > x1) { n=x0; x0=x1; x1=n; }
  if (y0 > y1) { n=y0; y0=y1; y1=n; }

  if (read_bitmap (&image, (char *) NULL))
  {
    if (image.hdr.planes > 1 ||
        image.hdr.clrlen > 0 ||
        image.hdr.physbits != 8)
    { fprintf (stderr, "fbmask works only for 8bit grayscale files\n");
      exit (1);
    }

    rowlen = image.hdr.rowlen;

    for (j=y0; j<=y1; j++)
    { for (i=x0; i<=x1; i++)
      { image.bm[j*rowlen + i] = val; }
    }
    
    write_bitmap (&image, stdout, outtype);
  }
  else
  { exit (1); }
  
  exit (0);
}
