/*****************************************************************
 * qrt2fbm.c: FBM Library 0.91 (Beta Test)  7-Apr-89  Michael Mauldin
 *
 * Copyright (C) 1989 by Michael Mauldin.  Permission is granted to
 * use this file in whole or in part provided that you do not sell it
 * for profit and that this copyright notice is retained unchanged.
 *
 * qrt2fbm.c: Convert QRT format (from the QRT ray tracer)
 *
 * USAGE
 *	 % qrt2fbm -t'title' -c'credits' < qrtfile > fbm
 *
 * EDITLOG
 *	LastEditDate = Wed May  3 23:35:24 1989 - Michael Mauldin
 *	LastFileName = /usr2/mlm/src/misc/fbm/qrt2fbm.c
 *
 * HISTORY
 *  7-Apr-89  Michael Mauldin (mlm) at Carnegie-Mellon University
 *	Installed, code by Butler Hines.
 *
 *****************************************************************/

# include <stdio.h>
# include "fbm.h"

# define USAGE \
"Usage: qrt2fbm [ -t'title' -c'credits' ] < qrtfile > fbm"

#ifndef lint
static char *fbmid =
	"$FBM qrt2fbm.c <0.91> 07-Apr-89  (C) 1989 by Michael Mauldin$";
#endif

main (argc, argv)
char *argv[];
{ register int j, k, rowlen;
  double aspect = 0.56;
  int rows, cols, line, len, planes=3;
  FBMHDR hdr;
  unsigned char *buf;
  char title[FBM_MAX_TITLE], credits[FBM_MAX_TITLE];

  /* Get the options */
  while (--argc > 0 && (*++argv)[0] == '-')
  { while (*++(*argv))
    { switch (**argv)
      { 
	case 't':	strncpy (title, *argv+1, FBM_MAX_TITLE);
			title[FBM_MAX_TITLE-1] = '\0';
			CLRARG; break;
	case 'c':	strncpy (credits, *argv+1, FBM_MAX_TITLE);
			credits[FBM_MAX_TITLE-1] = '\0';
			CLRARG; break;
	default:	fprintf (stderr, "%s\n", USAGE);
			exit (1);
      }
    }
  }

  cols = getchar();
  cols |= (getchar()<<8);
  rows = getchar();
  rows |= (getchar()<<8);
  
  rowlen = 2 * ((cols * 8 + 15) / 16);

  /* Build header */
  hdr.rows = rows;
  hdr.cols = cols;
  hdr.planes = planes;
  hdr.bits = 8;
  hdr.physbits = 8;
  hdr.rowlen = rowlen;
  hdr.plnlen = hdr.rowlen * rows;
  hdr.clrlen = 0;
  hdr.aspect = aspect;
  strcpy (hdr.title, title);
  strcpy (hdr.credits, credits);
  
  write_hdr_fbm (&hdr, stdout);
  
  len = planes*cols; 
  buf = (unsigned char *) malloc (rows*len);

  for (j=0; j<rows; j++){
    line = getchar();
    line |= (getchar()<<8);
    if (! fread (&buf[j*len], len, 1, stdin))
      { fprintf (stderr, "premature end of file on input at line %d\n", line);
        break;
      }
    }

  for(k=0; k<planes; k++){
    for (j=0; j<rows; j++){
      if (! fwrite (&buf[j*len+k*cols], rowlen, 1, stdout))
        { perror ("qrt2fbm"); exit (1); }
      }
    }
  
  exit (0);
}
