/*****************************************************************
 * flwrfb.c: FBM Library 0.9 (Beta test) 07-Mar-89  Michael Mauldin
 *
 * Copyright (C) 1989 by Michael Mauldin.  Permission is granted to
 * use this file in whole or in part provided that you do not sell it
 * for profit and that this copyright notice is retained unchanged.
 *
 * flwrfb.c: 
 *
 * CONTENTS
 *	write_fbm (image, wfile)
 *	write_hdr_fbm (image, wfile)
 *
 * EDITLOG
 *	LastEditDate = Tue Mar  7 19:57:39 1989 - Michael Mauldin
 *	LastFileName = /usr2/mlm/src/misc/fbm/flwrfb.c
 *
 * HISTORY
 * 07-Mar-89  Michael Mauldin (mlm) at Carnegie Mellon University
 *	Beta release (version 0.9) mlm@cs.cmu.edu
 *
 * 12-Nov-88  Michael Mauldin (mlm) at Carnegie-Mellon University
 *	Created.
 *****************************************************************/

# include <stdio.h>
# include <math.h>
# include <ctype.h>
# include "fbm.h"

/****************************************************************
 * write_fbm: Write an image to a stream
 ****************************************************************/

#ifndef lint
static char *fbmid =
	"$FBM flwrfb.c <0.9> 07-Mar-89  (C) 1989 by Michael Mauldin$";
#endif

write_fbm (image, wfile)
register FBM *image;
register FILE *wfile;
{ register int k, j, rowlen, plnlen;
  register unsigned char *bmptr;

  if (! write_hdr_fbm (image, wfile)) return (0);

  rowlen = image->hdr.rowlen;
  plnlen = image->hdr.plnlen;
  
  if (image->hdr.clrlen > 0)
  { if (!fwrite (image->cm, image->hdr.clrlen, 1, wfile))
    { perror ("write_fbm (colormap)"); return (0); }
  }

  for (k=0; k<image->hdr.planes; k++)
  { bmptr = &(image->bm[k*plnlen]);
    
    for (j=0; j<image->hdr.rows; j++, bmptr += rowlen)
    { if (! fwrite (bmptr, 1, rowlen, wfile))
      { perror ("write_fbm"); return (0); }
    }
  }
    
  return (1);
}

/****************************************************************
 * write_hdr_fbm: Write an image header to a stream
 ****************************************************************/

write_hdr_fbm (image, wfile)
register FBM *image;
register FILE *wfile;
{ FBMFILEHDR file_hdr;

  strncpy (file_hdr.magic, FBM_MAGIC, 8);
  sprintf (file_hdr.cols, "%7d", image->hdr.cols);
  sprintf (file_hdr.rows, "%7d", image->hdr.rows);
  sprintf (file_hdr.planes, "%7d", image->hdr.planes);
  sprintf (file_hdr.bits, "%7d", image->hdr.bits);
  sprintf (file_hdr.physbits, "%7d", image->hdr.physbits);
  sprintf (file_hdr.rowlen, "%11d", image->hdr.rowlen);
  sprintf (file_hdr.plnlen, "%11d", image->hdr.plnlen);
  sprintf (file_hdr.clrlen, "%11d", image->hdr.clrlen);
  sprintf (file_hdr.aspect, "%11.6lf", image->hdr.aspect);
  strncpy (file_hdr.title, image->hdr.title, FBM_MAX_TITLE);
  strncpy (file_hdr.credits, image->hdr.credits, FBM_MAX_TITLE);

  if (! fwrite (&file_hdr, sizeof (file_hdr), 1, wfile))
  { perror ("write_fbm (header)"); return (0); }
    
  return (1);
}
