/*****************************************************************
 * pbmtitle.c: FBM Library 0.9 (Beta test) 07-Mar-89  Michael Mauldin
 *
 * Copyright (C) 1989 by Michael Mauldin.  Permission is granted to
 * use this file in whole or in part provided that you do not sell it
 * for profit and that this copyright notice is retained unchanged.
 *
 * pbmtitle.c: Add a title to a pbm bitmap
 *
 * USAGE
 *	% pbmtitle [ flags ] arguments
 *
 * EDITLOG
 *	LastEditDate = Tue Mar  7 19:57:46 1989 - Michael Mauldin
 *	LastFileName = /usr2/mlm/src/misc/fbm/pbmtitle.c
 *
 * HISTORY
 * 07-Mar-89  Michael Mauldin (mlm) at Carnegie Mellon University
 *	Beta release (version 0.9) mlm@cs.cmu.edu
 *
 * 23-Sep-88  Michael Mauldin (mlm) at Carnegie-Mellon University
 *	Created.
 *****************************************************************/

# include <stdio.h>

# define USAGE "Usage: pbmtitle 'new title' < pbm > pbm"

#ifndef lint
static char *fbmid =
	"$FBM pbmtitle.c <0.9> 07-Mar-89  (C) 1989 by Michael Mauldin$";
#endif

main (argc, argv)
char *argv[];
{ char buf[BUFSIZ];
  int lines=0;

  if (argc != 2 || argv[1][0] == '-')
  { fprintf (stderr, "%s\n", USAGE);
    exit (1);
  }
  
  while (fgets (buf, BUFSIZ, stdin))
  { if (buf[0] != '#') { printf ("%s", buf); lines++; }
    else if (strncmp (buf, "# Title: ", 9)) printf ("%s", buf);
    
    if (lines == 2) printf ("# Title: %s\n", argv[1]);
  }
  
  exit (0);
}
