/*****************************************************************
 * fbhist.c: FBM Library 0.9 (Beta test) 07-Mar-89  Michael Mauldin
 *
 * Copyright (C) 1989 by Michael Mauldin.  Permission is granted to
 * use this file in whole or in part provided that you do not sell it
 * for profit and that this copyright notice is retained unchanged.
 *
 * fbhist.c: 
 *
 * USAGE
 *	% fbhist [-h] < image
 *
 * EDITLOG
 *	LastEditDate = Tue Mar  7 17:52:50 1989 - Michael Mauldin
 *	LastFileName = /usr2/mlm/src/misc/fbm/fbhist.c
 *
 * HISTORY
 * 07-Mar-89  Michael Mauldin (mlm) at Carnegie Mellon University
 *	Beta release (version 0.9) mlm@cs.cmu.edu
 *
 * 21-Aug-88  Michael Mauldin (mlm) at Carnegie-Mellon University
 *	Created.
 *****************************************************************/

# include <stdio.h>
# include <math.h>
# include "fbm.h"

#define USAGE "Usage: fbhist [ -h ] < 8bit"

#ifndef lint
static char *fbmid =
	"$FBM fbhist.c <0.9> 07-Mar-89  (C) 1989 by Michael Mauldin$";
#endif

main (argc, argv)
char *argv[];
{ FBM image;
  register int ch, size, cnt;
  register unsigned char *bmptr, *tail;
  int min = BYTE, max = -1;
  int hist[BYTE], dohist = 0;
  double sum = 0.0, sumsq = 0.0, avg, std;

  /* Get the options */
  while (--argc > 0 && (*++argv)[0] == '-')
  { while (*++(*argv))
    { switch (**argv)
      { case 'h':	dohist++; break;
	default:        fprintf (stderr, "%s\n", USAGE);
                        exit (1);
      }
    }
  }

  /* Clear the memory pointer so alloc_fbm won't be confused */
  image.cm  = image.bm  = (unsigned char *) NULL;

  /* Clear the histogram */
  for (ch=0; ch<BYTE; ch++)
  { hist[ch] = 0; }

  /* Read the file and count the gray levels */
  if (read_bitmap (&image, (char *) NULL))
  { size = image.hdr.rows * image.hdr.cols;
    bmptr = image.bm;
    tail = bmptr+size;

    while (bmptr < tail)
    { hist[*bmptr++]++; }
    
    for (ch=0; ch<BYTE; ch++)
    { cnt = hist[ch];

      if (cnt && ch < min) min = ch;
      if (cnt && ch > max) max = ch;
      
      sum += cnt * ch;
      sumsq += cnt * ch*ch;
    }
    
    avg = sum / size;

    if (size < 2)
    { std = 0.0; }
    else
    { double t1 = (size * sumsq - sum * sum);
      double t2 = ((double) size * (size-1));
      std = sqrt (t1 / t2);
    }

    printf ("%s [%dx%d  %d bits  %1.3lf aspect ratio]\n",
	    *image.hdr.title ? image.hdr.title : "Untitled",
	    image.hdr.cols, image.hdr.rows, image.hdr.bits, image.hdr.aspect);

    printf ("Mean %1.2lf +- %1.2lf, range %d..%d\n",
	    avg, std, min, max);

    if (dohist)
    { for (ch=0; ch<BYTE; ch++)
      { if (hist[ch]) printf ("%3d: %6d\n", ch, hist[ch]); }
    }
    
  }
  else
  { exit (1); }
  
  exit (0);
}
