/*****************************************************************
 * clr2gray.c: FBM Library 0.9 (Beta test) 07-Mar-89  Michael Mauldin
 *
 * Copyright (C) 1989 by Michael Mauldin.  Permission is granted to
 * use this file in whole or in part provided that you do not sell it
 * for profit and that this copyright notice is retained unchanged.
 *
 * USAGE
 *	% clr2gray [ -r<red> -g<grn> -b<blu> ] [ -<type> ] < color > gray
 *
 * EDITLOG
 *	LastEditDate = Tue Mar  7 19:56:03 1989 - Michael Mauldin
 *	LastFileName = /usr2/mlm/src/misc/fbm/clr2gray.c
 *
 * HISTORY
 * 07-Mar-89  Michael Mauldin (mlm) at Carnegie Mellon University
 *	Beta release (version 0.9) mlm@cs.cmu.edu
 *
 * 06-Mar-89  Michael Mauldin (mlm) at Carnegie Mellon University
 *	Added options for RGB weights
 *
 *  1-Dec-88  Michael Mauldin (mlm) at Carnegie-Mellon University
 *	Created.
 *****************************************************************/

# include <stdio.h>
# include <math.h>
# include "fbm.h"

# define USAGE \
"Usage: clr2gray [ -r<red> -g<grn> -b<blu> ] [ -<type> ] < color > gray"

#ifndef lint
static char *fbmid =
	"$FBM clr2gray.c <0.9> 07-Mar-89  (C) 1989 by Michael Mauldin$";
#endif

main (argc, argv)
char *argv[];
{ FBM input, output;
  int outtype = DEF_8BIT;
  int rw=0, gw=0, bw=0;

  /* Get the options */
  while (--argc > 0 && (*++argv)[0] == '-')
  { while (*++(*argv))
    { switch (**argv)
      { 
	case 'r':	rw = atoi (*argv+1); SKIPARG; break;
	case 'g':	gw = atoi (*argv+1); SKIPARG; break;
	case 'b':	bw = atoi (*argv+1); SKIPARG; break;
	case 'A':	outtype = FMT_ATK; break;
	case 'B':	outtype = FMT_FACE; break;
	case 'F':	outtype = FMT_FBM; break;
	case 'G':	outtype = FMT_GIF; break;
	case 'I':	outtype = FMT_IFF; break;
	case 'L':	outtype = FMT_LEAF; break;
	case 'M':	outtype = FMT_MCP; break;
	case 'P':	outtype = FMT_PBM; break;
	case 'S':	outtype = FMT_SUN; break;
	case 'T':	outtype = FMT_TIFF; break;
	case 'X':	outtype = FMT_X11; break;
	case 'Z':	outtype = FMT_PCX; break;
	default:        fprintf (stderr, "%s\n", USAGE);
                        exit (1);
      }
    }
  }

  /* Use NTSC weights for defaults */
  if (rw + gw + bw <= 0)
  { rw = 299; gw = 587; bw = 114; }

  /* Clear the memory pointers so alloc_fbm won't be confused */
  input.cm  = input.bm  = (unsigned char *) NULL;
  output.cm = output.bm = (unsigned char *) NULL;

  /* Read the image and convert it, use NTSC weights */
  if (read_bitmap (&input, (char *) NULL) &&
      clr2gray (&input, &output, rw, gw, bw) &&
      write_bitmap (&output, stdout, outtype))
  { exit (0); }

  exit (1);
}
