/*

Copyright (C) 1988, 1989 by Juha Takala, jta@sah.vtt.fi

     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; version 1.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     the file "License for more details

     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


 */

/* Description:
 * Screwed demo to tie your cpu for a while.  Pipe the output of this
 * program to the "draw" that you just made, and "draw"'s output to the
 * device you like.
 */

#include <math.h>
#include <stdio.h>

static char *rcsid =
  "$Id: kiero.c,v 1.3 89/12/08 14:00:54 jta Exp Locker: jta $";

double param[8] = {0.99, -0.7, 3.01, 1.01, 0.1, 15.03, 0.01};
static char *ttbl[] = {
    "#$xrange -2,1,2",
    "#$yrange -2,1,2",
    "#$noaxes",
    "#$init",
    "#$size 2",
    "#$text -2,1.9,See: Computer Recreations",
    "#$text -2,1.7,Scientific American, May -88, p.95",
    "#$size 1.4",
    "#$text -2,-1.75,Hit your interrupt character to stop.",
    NULL
};

int maxn = 100000;

main (argc, argv, envp)
int argc;
char *argv[], *envp[];
{
    double t, *p;
    char **cp;
    int i;
    
    if (argc > 1) {
	maxn = atoi(*(++argv));
	argc--;
    }
    
    p = param;
    while (--argc > 0)
      *(p++) = atof(*(++argv));

    for (cp=ttbl; *cp; cp++)
      printf ("%s\n", *cp);

    t = 0.0;
    for (i=0; i<maxn; i++) {
	printf ("%8.4f %8.4f\n",
		sin(param[0]*t) + param[1] * cos(param[2]*t),
		cos(param[3]*t) + param[4] * sin(param[5]*t));
	t += param[6];
    }
}
