/*

Copyright (C) 1988, 1989 by Juha Takala, jta@sah.vtt.fi

     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; version 1.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     the file "License" for more details

     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


 */


/* $Id: dr_lib.h,v 2.3 89/12/08 14:00:31 jta Exp Locker: jta $
 *
 * This is header file for a subroutine package that contains
 * device level routines to manipulate graphics devices such as
 *  - hpgl output for hp7475 plotter
 *  - gl_plot(3) calls for EGA or matrix printer output
 *  - plot(3) interface
 *
 * Following routines are provided:
 *
 *
 * void circle()
 *    - draw a small circle at current point
 *
 * void dr_set_pen(n)
 * int n;
 *    - select pen n
 *    - n==0 menas 'put it away'
 *    - n = 1..6 means select pen n
 *    - n<0 or n>6 issues error message and selects pen 1
 *
 * void dr_goto(x,y,linetype,penup,relative)
 * float x, y; int linetype, penup;
 *    - move pen to point (x,y)
 *    - if penup!=0, will draw line of type linetype
 *    - if relative!=0, will move relative to current point
 *
 * void dr_draw_line(x1, y1, x2, y2, linetype)
 * float x1, y1, x2, y2; int linetype;
 *    - draw a line of type linetype from poin (x1,y1) to point (x2,y2)
 *
 * void dr_set_shape(x)
 * float x;
 *    - change text 'fatness'
 * 
 * void dr_set_size(x)
 * float x;
 *    - change text size
 * 
 * void dr_draw_array(x, y, n, linetype)
 * float x[], y[]; int n, linetype;
 *    - points (x[i],y[i]) (i = 0..n-1) will be connected
 *      with line of linetype
 *
 * void dr_put_mark(x, y, mark) 
 * float x, y; char mark;
 *    - put marker mark at point (x,y)
 *
 * void dr_put_text(xpos, ypos, xofs, yofs, dir, size, s)
 * float xpos, ypos, xofs, yofs; char *dir, *size, *s;
 *    - put text s to position (xpos+xofs,ypos+yofs) in direction dir
 *
 * int dr_finish()
 *    - finish plotting, report errors, return number of them
 *
 * void dr_start(xlow, xhigh, ylow, yhigh, dev)
 * float xlow, xhigh, ylow, yhigh; int dev;
 *    - prepare plotting for device dev, establish relative drawing area
 *
 * void dr_xgrid(n)
 * int n;
 *    - draw vertical grid lines
 *
 * void dr_ygrid(n)
 * int n;
 *    - draw horizontal grid lines
 *
 * void dr_area_def(xlow, xincr, xhigh, ylow, yincr, yhigh, no_axes)
 * float xlow, xincr, xhigh, ylow, yincr, yhigh;
 * int no_axes;
 *    - establish user coordinates
 *    - draw x- and y-axis and tick marks (only if no_axes == 0)
 *
 * void dr_errmsg(s)
 * char *s;
 *    - send string s to error log file
 */

int dr_set_ltype();
void dr_goto(), dr_draw_line(), dr_draw_array(), dr_put_mark();
void dr_set_pen(), dr_set_shape(), dr_set_size(), dr_put_text(), dr_set_cset();
int dr_finish();
void dr_start(), dr_area_def();
void dr_xgrid(), dr_ygrid(), dr_draw_circle();
void dr_errmsg(), dr_warnmsg();


/* The following devices are supported: */
#define HP7475 1		/* hp 7475 plotter */
#define SCREEN 2		/* ega == dtlewis's gl_plot */
#define PLOTLIB 3		/* UNIX plot(3) interface */
#define FIRSTDEV HP7475
#define LASTDEV PLOTLIB
#define INVDEV -1
#define DEVMASK 0xff

/* the following are paper size coding */
#define SIZE_A4 0x100
#define SIZE_A3 0x200
#define SIZE_A  0x400
#define SIZE_B  0x800
#define SIZEMASK 0xff00

#ifdef PLOT
extern void openpl();
extern void erase();
extern void label();
extern void line();
extern void circle();
extern void arc();
extern void move();
extern void cont();
extern void point();
extern void linemod();
extern void space();
extern void closepl();
#endif

#ifdef MSDOS
#define M_PI_2 1.5707963268
#endif
