/*
	strip7 - strip byte counts from binary f77 writes

	The CRC graphics package

	carl crawford
	purdue university
	west lafayette, indiana 47907

	april 10, 1980

	Modified 11/2/82...to give it bigger buffer for plot3d
						Malcolm

	syntax: strip7 [-r] file1 file2 ...
*/

#include <stdio.h>
#include <signal.h>
#define	MAXBUF	30000

int	files;		/* 1 if multiple files present */
int	new;		/* 1 put stripped file in name.s7 */
int	ofile;		/* 1 open temp or output file */
char	name[50];	/* file name buffer */
char	buf[MAXBUF];

main(argc,argv)
	int	argc;
	char	**argv;
{
	FILE	*fdi,*fdo;
	int     i,j;
	int	rmtmp();

	if(argc > 1 && argv[1][0] == '-' && argv[1][1] == 'r'){
		new = 1;
		argc--;
		argv++;
	}
	if(argc == 1)err("usage: strip7 [-r] file1 ...","");

	signal(SIGHUP,rmtmp);
	signal(SIGINT,rmtmp);
	signal(SIGQUIT,rmtmp);

	if(argc > 2)files = 1;
	while(++argv,--argc){
		if((fdi = fopen(*argv,"r")) == NULL){
			err("can't open: ",*argv);
			goto nfile;
		}
		if(new){
			strcpy(name,*argv);
			strcat(name,".s7");
			if((fdo = fopen(name,"w")) == NULL){
				err("can't create: ",name);
				goto nfile;
			}
		}else{
			if((fdo = fopen("strip7.tmp","w")) == NULL){
				err("can't create temp file\n","");
				goto nfile;
			}
		}
		ofile = 1;
		while(fread(&i,sizeof(int),1,fdi) == 1){
			if(i <= 0 || i > MAXBUF){
				bad(*argv);
				goto nfile;
			}
			if(fread(buf,1,i,fdi) != i){
				bad(*argv);
				goto nfile;
			}
			fwrite(buf,1,i,fdo);
			if(fread(&j,sizeof(int),1,fdi) != 1){
				bad(*argv);
				goto nfile;
			}
			if(j != i){
				bad(*argv);
				goto nfile;
			}
		}
		fclose(fdi);
		fclose(fdo);
		if(!new){
			if(unlink(*argv) == -1){
				err("can't unlink: ",*argv);
				goto nfile;
			}
			if(link("strip7.tmp",*argv) == -1){
				strcpy(buf,"cp strip7.tmp ");
				strcat(buf,*argv);
				system(buf);
			}
			unlink("strip7.tmp");
		}
		ofile = 0;
nfile:
	;
	}
}
bad(s)
char	*s;
{
	if(files){
		fprintf(stderr,"%s:bad data structure\n",s);
	}else{
		fprintf(stderr,"bad data structure\n");
	}
	rmfiles();
}
err(s1,s2)
	char    *s1,*s2;
{
	fprintf(stderr,"%s%s\n",s1,s2);
	rmfiles();
}
rmfiles()
{
	if(!ofile)return;
	if(new){
		unlink(name);
	}else{
		unlink("strip7.tmp");
	}
	ofile = 0;
}

rmtmp()
{
	rmfiles();
	exit(1);
}
