c
c	panel - draw the vertical lines on the front panels.
c
	subroutine panel(x,y,z,nxdim)
	dimension z(nxdim,1),x(1),y(1)
	logical xaxs,yaxs,zaxs,abv,blw,xdir,ydir,print
	real xymin(2),xymax(2),tic(3)
	integer ibyte(3),idig(3),ixlbl(3)
	common /c/ xymin,xymax,tic,ibyte,idig,ixlbl,base,zbmax,zbmin,pi
	common /d/ zlen,nx,ny,numstp,dlmnsm,dm,dl,small
	common /e/ istrt1,iend1,istep1,istrt2,iend2,istep2
	common /flag/ xaxs,yaxs,zaxs,abv,blw,xdir,ydir,print
c
c		set the distance between the vertical lines in the front panels
c
	idxvrt = nx / 8
	if ( nx .lt. 16 ) idxvrt = 1
	idyvrt = ny / 8 
	if ( ny .lt. 16 ) idyvrt = 1
c
c		select the the coordinates of the front edge depending on
c		the direction of line drawing either (istrt1,istrt2) or
c		(istrt2,istrt1).
c
	if( ydir ) then
		idel1 = idxvrt
		idel2 = idyvrt
	else
		idel1 = idyvrt
		idel2 = idxvrt
	endif
c
c		setup the first row depending on the direction options,
c		either in x direction or y direction. absx and absy are
c		the absolute coordinate sizes for plotting.
c
	idel	= idel2 * istep2
	ilimit	= istrt2 + ( ( iend2 - istrt2 ) / idel ) * idel
	do 215 i=istrt2 , iend2 , idel2*istep2
		if( ydir ) then
		    xdum = float( ifix( xcal(x(istrt1),y(i)) *dm))*dl
		    if( ydir ) then
			ydum = ycal( x(istrt1),y(i),z(istrt1,i) )
		    else
			ydum = ycal( x(istrt1),y(i),z(i,istrt1) )
		    endif
		    ybase = ycal( x(istrt1) , y(i) , base )
		else
		    xdum = float( ifix( xcal(x(i),y(istrt1)) *dm))*dl
		    if( ydir ) then
			ydum = ycal( x(i),y(istrt1),z(istrt1,i) )
		    else
			ydum = ycal( x(i),y(istrt1),z(i,istrt1) )
		    endif
		    ybase = ycal( x(i) , y(istrt1) , base )
		endif
		if( print ) write(6,*)"x1,y1,iflag",xdum,ydum,"3"
		call plot(xdum,ydum,3)
		if( print ) write(6,*)"alng: x1,y1,iflag",xdum,ybase,"2"
		call plot(xdum,ybase,2)
		if( i .eq. ilimit .and. i .ne. iend2 ) i = iend2 - idel2*istep2
215	continue
	idel	= idel1 * istep1
	ilimit	= istrt1 + ( ( iend1 - istrt1 ) / idel ) * idel
	do 216 i=istrt1 , iend1 , idel1*istep1
		if( .not. ydir ) then
		    xdum = float( ifix( xcal(x(istrt2),y(i)) *dm))*dl
		    if( ydir ) then
			ydum = ycal( x(istrt2),y(i),z(i,istrt2) )
		    else
			ydum = ycal( x(istrt2),y(i),z(istrt2,i) )
		    endif
		    ybase = ycal( x(istrt2) , y(i) , base )
		else
		    xdum = float( ifix( xcal(x(i),y(istrt2)) *dm))*dl
		    if( ydir ) then
			ydum = ycal( x(i),y(istrt2),z(i,istrt2) )
		    else
			ydum = ycal( x(i),y(istrt2),z(istrt2,i) )
		    endif
		    ybase = ycal( x(i) , y(istrt2) , base )
		endif
		if( print ) write(6,*)"x1,y1,iflag",xdum,ydum,"3"
		call plot(xdum,ydum,3)
		if( print ) write(6,*)"alng: x1,y1,iflag",xdum,ybase,"2"
		call plot(xdum,ybase,2)
		if( i .eq. ilimit .and. i .ne. iend1 ) i = iend1 - idel1*istep1
216	continue
	return
	end
c
c	xcal - calculate the absolute x coordinate of a point 
c
	real function xcal(x,y) 
	common /a/ phi1,phi2,cphi1,sphi1,cphi2,s1s2,c1s2,zfct,absxs
	xcal = cphi1 * x + sphi1 * y -absxs
	end
c	
c	ycal - calculate the absolute y coordinate of a point 
c
	real function ycal(x,y,z) 
	common /a/ phi1,phi2,cphi1,sphi1,cphi2,s1s2,c1s2,zfct,absxs
	ycal = - s1s2 * x + c1s2 * y + cphi2 * z * zfct
	end
c
c	perpen - draws the small lines between two adjacent stripes
c
	subroutine perpen(iprpn) 
	parameter(maxstp=8000)
	dimension above(maxstp),below(maxstp)
	dimension absx(512),absy(512),xold(512),yold(512)
	logical xaxs,yaxs,zaxs,abv,blw,xdir,ydir,print
	common /b/ above,below
	common /d/ zlen,nx,ny,numstp,dlmnsm,dm,dl,small
	common /e/ istrt1,iend1,istep1,istrt2,iend2,istep2
	common /f/ xold,yold,absx,absy
	common /flag/ xaxs,yaxs,zaxs,abv,blw,xdir,ydir,print
	x1 = xold(iprpn)
	y1 = yold(iprpn)
	x2 = absx(iprpn)
	y2 = absy(iprpn)
c
c	set the line hiding flags.
c
	m	= x1 * dm + 1.01
	abv	= .false.
	blw	= .false.
	if( y1 .gt. above(m) ) abv	= .true.
	if( y1 .lt. below(m) ) blw = .true.
	if( print ) then
	  if( abv ) write(6,*)"				above"
	  if( blw ) write(6,*)"				below"
	  write(6,*)"-fredg: x1,y1,x2,y2",x1,y1,x2,y2
	endif
	call draw(x1,y1,x2,y2)
	return
	end
