c
c		draw base, axes and label coordinates
c
	subroutine setaxs(xlen,ylen,lbl)
	parameter(maxstp=8000)
	real xcorn(2,2),ycorn(2,2),xymin(2),xymax(2),tic(3)
	integer ibyte(3),idig(3),ixlbl(3)
	real xcindx(2,2),ycindx(2,2)
	dimension above(maxstp),below(maxstp)
	logical xaxs,yaxs,zaxs,abv,blw,xdir,ydir,print
	character*80 lbl(3), tempstr
	common /a/ phi1,phi2,cphi1,sphi1,cphi2,s1s2,c1s2,zfct,absxs
	common /b/ above,below
	common /c/ xymin,xymax,tic,ibyte,idig,ixlbl,base,zbmax,zbmin,pi
	common /d/ zlen,nx,ny,numstp,dlmnsm,dm,dl,small
	common /pos/ xpos,ypos
	common /flag/ xaxs,yaxs,zaxs,abv,blw,xdir,ydir,print
c
c		CHANGE *********------+++++++********-----
c	xcindx(i,*) and ycindx(i,*) are indices of the x and y coordinates of
c	the i th axis (i=1 is the x axis and i=2 is the y axis)
c	xcindx(*,1(2)) is the x comp of the first (last) point of the axis.
c	ycindx(*,1(2)) is the y comp of the first (last) point of the axis.
c	The direction of the axes is preserved.
c	The two axes considered are the ones in front of the object and
c	are also used for axes drawing.
c
c	xcindx(1,1) = xymin(1)
c	ycindx(1,1) = xymin(2)
c	xcindx(1,2) = xymax(1)
c	ycindx(1,2) = xymin(2)
c	if( phi1 .ge. 0.0 ) then
c		xcindx(2,1) = xymax(1)
c		xcindx(2,2) = xymax(1)
c	else
c		xcindx(2,1) = xymin(1)
c		xcindx(2,2) = xymin(1)
c	endif
c	ycindx(2,1) = xymin(2)
c	ycindx(2,2) = xymax(2)
	xcindx(1,1) = 0.0
	ycindx(1,1) = 0.0
	xcindx(1,2) = xlen
	ycindx(1,2) = 0.0
	if( phi1 .ge. 0.0 ) then
		xcindx(2,1) = xlen
		xcindx(2,2) = xlen
	else
		xcindx(2,1) = 0.0
		xcindx(2,2) = 0.0
	endif
	ycindx(2,1) = 0.0
	ycindx(2,2) = ylen
	if( xaxs .or. yaxs .or. zaxs ) then
	    do 90 i=1 , 2
		iflag = 3 
		do 80 j=1 , 2
		    xcorn(i,j) = xcal( xcindx(i,j) , ycindx(i,j) ) 
		    ycorn(i,j) = ycal( xcindx(i,j) , ycindx(i,j) , base )
80		continue
90	    continue
	endif
	if( zaxs ) then
 	    zaxisl	= cphi2 * zlen
	    call axisv(tic(3),idig(3))
c
c		decide which edge should the z-axis be on.
c
	    if( phi1 .ge. 0.0 ) then
		ixzedg = 1
		iyzedg = 1
	    else
		ixzedg = 2
		iyzedg = 2
	    endif
	    x1 = xcorn(ixzedg,iyzedg)
	    y1 = ycorn(ixzedg,iyzedg) 
c		draw the z axis from the min of z to max of z
	    if( base .gt. zbmin ) then
		y1 = y1 - cphi2 * zlen * ( base - zbmin ) / ( zbmax - zbmin ) 
	    endif
	    call plot(x1,y1,3)
	    iflag = 1
	    if( ibyte(3) .eq. 5 ) iflag = 0
	    tempstr = lbl(3)(1:ixlbl(3)) // '\0'
	    call axis(x1,y1,tempstr(1:ixlbl(3)),1,zaxisl,
     $                amin1(base,zbmin),zbmax,iflag)
	endif
	if (xaxs .or. yaxs) then
	    istrt	= 1
	    iend	= 2
	    if( .not. xaxs ) istrt = 2
	    if( .not. yaxs ) iend = 1
c
	    do 110 i=istrt , iend
		call plot(xcorn(i,1),ycorn(i,1),3)
		ang = atan2( ycorn(i,2)-ycorn(i,1) , xcorn(i,2)-xcorn(i,1) ) 
		dumsz =sqrt( (xcorn(i,2)-xcorn(i,1))**2 
     $					+ (ycorn(i,2)-ycorn(i,1)) **2 ) 
		x1 = xcorn(i,1)
		y1 = ycorn(i,1)
		dummin = xymin(i)
		dummax = xymax(i)
		sznew = dumsz
c				if numbers are integer
		if( ibyte(i) .eq. 3 ) then
		    dis = dumsz / ( xymax(i) - xymin(i) )
		    disnum = tic(i) / dis
c				do not have steps of less than 1
		    if( disnum .le. 1.0 ) then
			tic(i) = dis - small / 10.0
		    else
c				modify tic size to suit integer values
			atic = float( ifix( disnum + small / 10.0 )) * dis
			if( abs(tic(i)-atic) .gt. small ) tic(i) = atic - small
		    endif
		    dum = dumsz * float(ifix(dumsz/tic(i))) / (dumsz/tic(i))
		    if( abs(dumsz-dum) .gt. small ) sznew = dum + small / 10.0
		endif
c				do not put the number at the point where
c				the z axis is drawn
		dum = 1.001 * ( dumsz - sznew ) / tic(i)
		if( i .eq. ixzedg .and. dum .lt. 0.4 ) sznew = sznew - tic(i)
		diff = dumsz - sznew
		if( abs(diff) .gt. small ) then
		    if( i .eq. ixzedg .and. iyzedg .eq. 1 ) then
			    dumx = x1
			    dumy = y1
			    x1 = x1 + diff * cos(ang)
			    y1 = y1 + diff * sin(ang)
			    dummin = dummin + (xymax(i)-xymin(i)) * diff / dumsz
		    else
			    dumx = x1 + sznew * cos(ang)
			    dumy = y1 + sznew * sin(ang)
			    dummax = dummax - (xymax(i)-xymin(i)) * diff / dumsz
		    endif
		    call plot(dumx,dumy,3)
		    dumx = dumx + diff * cos(ang)
		    dumy = dumy + diff * sin(ang)
		    call plot(dumx,dumy,2)
		    dumsz = sznew
		endif
		idir = 1
		if( i .eq. 2 .and. phi1 .lt. 0.0 ) idir = - idir 
		if( phi2 .lt. 0.0 ) idir = - idir
		iflag = 0
		if( ibyte(i) .eq. 3 ) iflag = 1
		call axisv(tic(i),idig(i))
		tempstr = lbl(i)(1:ixlbl(i)) // '\0'
		call draxis(x1,y1,tempstr(1:ixlbl(i)),ang*180.0/pi,idir,dumsz
     $			,dummin,dummax,iflag)
110	    continue
	    do 150 ii=1 , 2
		do 130 jj=1 , 2
		    xcorn(ii,jj) = float( ifix ( xcal( xcindx(ii,jj) 
     $				, ycindx(ii,jj) ) * dm ) ) * dl 
		    ycorn(ii,jj) =ycal(xcindx(ii,jj),ycindx(ii,jj),base )
130		continue
c			the direction of the y axis is different for phi1 < 0
		if( ii .eq. 2 .and. phi1 .lt. 0.0 ) then
			y1 = ycorn(ii,2)
			y2 = ycorn(ii,1)
			x1 = xcorn(ii,2)
			x2 = xcorn(ii,1)
		else
			y1 = ycorn(ii,1)
			y2 = ycorn(ii,2)
			x1 = xcorn(ii,1)
			x2 = xcorn(ii,2)
		endif
c			set the hiding lines. Since axes is drawn, everything
c			below(above) the axes should be hided when phi2 is
c			positive(negative).
		if( x1 .ne. x2 ) then
			y21x21 = ( y2 - y1 ) / ( x2 - x1 )
			m = x1 * dm + 1.01
			xdum	= x1
140			continue
				dum	= y1 + (xdum - x1) * y21x21 
				if( phi2 .ge. 0.0 ) then 
					above(m) = dum 
					below(m) = -20.0
				else
					above(m) = 20.0 
					below(m) = dum 
				endif
				xdum	= xdum + dl
				m	= m + 1
				if( abs(xdum-x2) .gt. dl/2.0 ) go to 140
		else
c				if the axis is vertical, it is simple!
			above(m) = amax1(y1,y2) 
			below(m) = amin1(y1,y2) 
		endif
150	    continue
	endif
	return
	end
