#define OLDHP
/*
	hpd - HP daemon program

	The CRC graphics package

	Carl Crawford
	Purdue University
	W. Lafayette, IN 47907

	March 1980
*/

#include <stdio.h>
#include <signal.h>


#ifdef	vax
#include	<sys/file.h>
#endif	vax

#define	ETX	3	/* <etx> */
#define	ESC	27	/* <esc> */

#ifndef OLDHP
#include <sgtty.h>
struct sgttyb Tty,tty;
char pbuf[BUFSIZ];
#endif

int     flag;
char	tickle;
char    ansbuff[32];	/* return from HP */
int     fd,fdi;		/* HP file descriptors */
char    buf[512];	/* input buffer */
char	name[100];	/* path to device */
int	c;		/* input character */
FILE	*ifd;		/* input to program */
int	net = 1;	/* 1=send output across network */
char	host[10] = "a";	/* last resort plotter site */

main(argc,argv)
	int     argc;
	char    **argv;
{
	register i,j;
	char *p;
	int	clean(),timeout();

#ifdef OLDHP
	/* find out default host for plotter */

	if((ifd = fopen("/usr/lib/graphics/hpd.site","r")) != NULL){
		fgets(host,10,ifd);
		fclose(ifd);
		host[strlen(host)-1] = 0;
		if(strcmp(host,"local") == 0){
			net = 0;
		}else{
			net = 1;
		}
	}

	/* see if -mHOST is on the command line */

	if(argc >= 2){
		if(argv[1][0] == '-' && argv[1][1] == 'm' && argv[1][2]){
			strcpy(host,argv[1]+2);
			net = 1;
			argc--;
			argv++;
		}
	}

	/* see if path to plotter is specified */

	if(argc == 2){
		strcpy(name,argv[1]);
	}else{
		strcpy(name,"/dev/plt0");
	}

	/* pipe to another machine if necessary */

	if(net){
		execl("/bin/ns","ns",host,"-S","/usr/lib/graphics/hpd",name,0);
		execl("/usr/bin/ns","ns",host,"-S","/usr/lib/graphics/hpd",name,0);
		execl("/usr/ecn/ns","ns",host,"-S","/usr/lib/graphics/hpd",name,0);
		fprintf(stderr,"hpd: can't exec ns\n");
		exit(1);
	}

	/* drive plotter local to this machine */

	/* find out name of machine */

	if((ifd=fopen("/etc/cpu","r")) != NULL){
		fgets(host,10,ifd);
		host[strlen(host)-1] = 0;
		fclose(ifd);
	}

	/* open plotter for input and output */

	fdi = open(name,0);
	if(fdi == -1)noplot();
	fd = open(name,1);
	if(fd == -1)noplot();

#ifdef	vax
	flock(fdi,LOCK_EX);
#endif	vax
#endif OLDHP

#ifndef OLDHP
	setbuf(stdout,pbuf);
	fdi = fd = 1;
	gtty(fd,&Tty);
	tty = Tty;
	tty.sg_flags &= ~ECHO;
	stty(fd,&tty);
#endif
	/* catch interrupts and reset plotter */

	if (signal(SIGHUP,SIG_IGN) != SIG_IGN)
		signal(SIGHUP,clean);
	if (signal(SIGINT,SIG_IGN) != SIG_IGN)
		signal(SIGINT,clean);
	if (signal(SIGQUIT,SIG_IGN) != SIG_IGN)
		signal(SIGQUIT,clean);

	i = 0;
	while(1){
		if((c = getchar()) != EOF)buf[i++] = c;
		if(i == 512 || c == EOF || c == '}'){

			if (write(fd,buf,i) < 0) {
				perror("hpd: write failed");
				exit(69);
			}

			flag = 1;
			alarm(180);	/* have driver time out */
			signal(SIGALRM,timeout);
			/* wait for buffer to empty out */

			while(flag){
				tickle = '\05';

				if (write(fd,&tickle,1) < 0) {
					perror("hpd: write failed"); 
					exit(69);
				}

				if ((i = read(fdi,ansbuff,30)) < 0) {
					perror("hpd: read failed");
					exit(69);
				}

				p = ansbuff;
				for(j = 0;j < i;j++)if(*p++ == 'G')flag = 0;
#ifdef OLDHP
				if(c == EOF && !flag)exit(1);
#else
				if(c == EOF && !flag)clean();
#endif
			}
				
			alarm(0);
			i = 0;
		}
	}
}

noplot()
{
	fprintf(stderr,"Can't open HP plotter on %s!%s\n",host,name);
	exit(1);
}

clean()
{
	int i = 0;

	/* reset plotter and put the pen back */

#ifdef OLDHP
	buf[i++] = ESC;
	buf[i++] = '.';
	buf[i++] = 'K';
#endif
	buf[i++] = ETX;
	buf[i++] = '}';
	buf[i++] = 'v';
	buf[i++] = 0100;
#ifndef OLDHP
	buf[i++] = ESC;
	buf[i++] = '.';
	buf[i++] = ')';
#endif
	write(fd,buf,i);

#ifndef OLDHP
	stty(fd,&Tty);
#endif

	exit(1);
}

timeout()
{
	fprintf(stderr,"Time out HP running on %s!%s\n",host,name);
	clean();
}
