#include	<stdio.h>

/*
	gplp - print bit planes on a Printronix line-printer

	syntax: gplp [-XX] [-i] file1 file2 ... filen

	The CRC graphics package

	carl crawford
	purdue university
	w. lafayette, in 47907

	july 1979


	*****************************************************************

	Modified by Tony Andrews : July, 1982

	Added "-s" option to compensate for different vertical and 
	horizontal pixed densities on the printronix. Define "NSQ" to
	delete the changes making the code identical to the original.

	The compensation is a simple compression so characters will be
	distorted somewhat.

	To avoid a major overhaul of the argument processing, the "-s"
	must come after the "-i" (if present) and before any file names.

*/

#define L       32
#define M       512

FILE	*ofd;			/* output file descriptor */
FILE	*fd;			/* input file descriptor */
char    PLOT    =    005;
char    ENDLINE =    012;
int     nfile;
char	swtab[64];
char	site[10] = "-ep";	/* last resort line-printer */

#ifndef NSQ
int     sflag   =   0;
short   mask[16];

#define MASK(x)  (((short)0x0001) << (15-x))
#endif

main(argc,argv)
	int	argc;
	char	**argv;
{
	FILE    *ifd[20];
	short ibuf[33],buf[33];
	char    obuf[100],*ob;
	register int     i,j,k;
	char    swap();
	FILE	*popen();

	ibuf[32] = 0;	/* clear last byte in vector */
#ifndef NSQ
	for(i=0;i<16;i++)               /* used to speed up masking later */
		mask[i] = MASK(i);
#endif
	if((fd = fopen("/usr/lib/graphics/gplp.site","r")) != NULL){
		fgets(site,10,fd);
		fclose(fd);
		site[strlen(site) - 1] = 0;
	}

	if(argc > 1 && (argv[1][0] == '-' && argv[1][1] && argv[1][2] && !argv[1][3])){
		if(argv[1][1] != 'p' || argv[1][2] != 'l'){
			site[1] = argv[1][1];
			site[2] = argv[1][2];
			site[3] = 0;
		}
		argc--;
		argv++;
	}
	if(argc > 1 && (argv[1][0] == '-' && argv[1][1] && argv[1][2] && argv[1][3] && !argv[1][4])){
		if(argv[1][1] != 'p' || argv[1][2] != 'l'){
			site[1] = argv[1][1];
			site[2] = argv[1][2];
			site[3] = argv[1][3];
			site[4] = 0;
		}
		argc--;
		argv++;
	}

	if(argc > 1 && (argv[1][0] == '-' && argv[1][1] == 'i' && argv[1][2] == '\0')){
		ifd[nfile++] = stdin;
		argv++;
		argc--;
	}
#ifndef NSQ
	if(argc > 1 && (argv[1][0] == '-' && argv[1][1] == 's' && argv[1][2] == '\0')){
		sflag++;
		argv++;
		argc--;
	}
#endif
	if(argc == 1 && !nfile)synerr();
	while(--argc){
		if((ifd[nfile++] = fopen(argv[1],"r")) == NULL){
			fprintf(stderr,"gplp: can't open: %s\n",argv[1]);
			exit(1);
		}
		++argv;
	}
	if (site[0] == '-')
		strcpy(&site[0],&site[1]);

	sprintf(obuf,"exec lpr -l -P%s", site);
	if((ofd = popen(obuf,"w")) == NULL){
		fprintf(stderr,"gplp: can't pipe to lpr\n");
		exit(1);
	}

	for(i=0;i<64;i++)swtab[i] = swap((char) i);
	for(j=0;j<M;j++){
		if(fread(ibuf,sizeof(short),L,ifd[0]) != L){
			fprintf(stderr,"gplp: unexpected EOF\n");
			exit(1);
		}
		i = 0;
		while(++i < nfile){
			if(fread(buf,sizeof(short),L,ifd[i]) != L){
				fprintf(stderr,"gplp: unexpected EOF\n");
				exit(1);
			}
			for(k=0;k<L;k++)ibuf[k] |= buf[k];
		}
#ifndef NSQ
		if(sflag) adjust(ibuf);
#endif
		ob = obuf;
		*ob++ = PLOT;
		for(i=0;i<L;i += 3){
			*ob++ = swtab[(ibuf[i] >> 10) & 077];
			*ob++ = swtab[(ibuf[i] >>4) & 077];
			*ob++ = swtab[((ibuf[i+1] >> 14) & 03) | ((ibuf[i] << 2) & 074)];
			*ob++ = swtab[(ibuf[i+1] >> 8) & 077];
			*ob++ = swtab[(ibuf[i+1] >> 2) & 077];
			*ob++ = swtab[((ibuf[i+2] >> 12) & 017) | ((ibuf[i+1] << 4) & 060)];
			*ob++ = swtab[(ibuf[i+2] >> 6) & 077];
			*ob++ = swtab[ibuf[i+2] & 077];
		}
		while(*(--ob) == 0100);
		*(++ob) = ENDLINE;
		fwrite(obuf,1,ob - obuf + 1,ofd);
	}
	fputc('\f',ofd);         /* eject page */
	pclose(ofd);
	wait(0);
}
char    swap(cc)
	char    cc;
{
	register        int     i;
	register char tmp;

	tmp = 0;
	for(i=0;i<6;i++){
		cc <<= 1;
		tmp |= (cc & 0100);
		tmp >>= 1;
	}
	return(tmp | 0100);
}
synerr()
{
	fprintf(stderr,"syntax: gplp [-XX] [-i] file1 file2 ... filen\n");
	exit(1);
}
#ifndef NSQ
adjust(buf)
short *buf;
{
	register int i;
	short tbuf[33];

	for(i=0; i<L ;i++)              /* clear output buffer */
		tbuf[i] = 0;

	for(i=0; i<M ;i++)
		if(biton(buf,i))
			setbit(tbuf,(int) ( (60.0/72.0) * (float) i));

	for(i=0; i<L ;i++)              /* move adjusted buffer back    */
		buf[i] = tbuf[i];       /* into the original            */
}
biton(b,n)
short *b;
int n;
{
	register int index,offset;

	index = n >> 4;
	offset= n & 0x000f;
	return(b[index] & mask[offset]);
}
setbit(b,n)
short *b;
int n;
{
	register int index,offset;

	index = n >> 4;
	offset= n & 0x000f;
	b[index] |= mask[offset];
}
#endif
