/*
	gp - print bit planes on the Versatec

	The CRC graphics package

	Carl Crawford 
	Purdue University
	West Lafayette, IN 47901

	October 1981

*/

#include	<stdio.h>

#define L    32
#define M    512

FILE    *ofd,*ifd[20],*popen();
FILE	*fd;		/* for getting site name */
short buf[L],ibuf[L],obuf[132];
int nf;			/* number of inout files */
int	form[3] = {3,0,020}; /* stty stuff for some Versatecs */
int     silent;         /* 1=don't print output message */
char	host[10] = "a";	/* last resort site */
int	outlen;		/* size of versatec line */
int	net = 1;	/* 1=go across network */
int     full;           /* 1= 4:1 0= 2:1 */
char gov[] = "/dev/ct/gov0";
char	cbuf[100];	/* character buffer for site determination */
int	dumb;		/* 1=dumb Versatec */

main(argc, argv)
	int     argc;
	char    **argv;
{
	char    c;
	short   map(),map2();
	int     i;
	register        j;
	register short  *p,*q;

	if(argc == 1)synerr();

/* the file /u/lib/graphics/gp.site contains information about which
versatec to use. it two fields: "host # ". the host is the network
machine where graphics will be sent to. the # is the length of the
line. 100 for normal versatecs and 132 for the old one at APPA. if
host is 'local' then the versatec connected directly to the machine
will be used. care should be used so that loops do not occur by
sending output back and forth between machines. */

	if((fd = fopen("/usr/lib/graphics/gp.site","r")) != NULL){
		fgets(host,10,fd);
		for(i=0;i<10;i++){
			if(host[i] == ' ' || host[i] == '\n'){
				host[i] = 0;
				break;
			}
		}
		outlen = atoi(host + i + 1);
		if(outlen == 132 ) dumb = 1;
		fclose(fd);
		if(strcmp(host,"local") == 0){
			net = 0;
		}else{
			net = 1;
		}
	}

	while(argv++ , --argc){
		if(**argv == '-')while(c = *++*argv)switch(c){

		case 'h':       /* 2:1 scaling */
			full = 0;
			break;
		case 'f':       /* 4:1 scaling */
			full = 1;
			break;
		case 'i':       /* standard input */
			ifd[nf++] = stdin;
			break;
		case 's':       /* silent mode */
			silent = 1;
			break;
		case 'm':	/* set up machine */
			strcpy(host,*argv+1);
			net = 1;
			goto nloop;
		default:
			fprintf(stderr,"bad flag: -%c\n",c);
			exit(1);
		}else{
			if(dumb){
				if(**argv >= '0' && **argv <= '2' && !*(*argv + 1)){
					gov[11] = **argv;
					ifd[nf++] = fopen(gov,"r");
					*argv = gov;
				}else{
				ifd[nf++] = fopen(*argv,"r");
				}
			}else{
				ifd[nf++] = fopen(*argv,"r");
			}
			if(ifd[nf-1] == NULL){
				fprintf(stderr,"can't open: %s\n",*argv);
				exit(1);
			}
		}
nloop:
	;
	}

	if(!nf)synerr();
	if(!dumb)full = 0;

	if(net){
		sprintf(cbuf,"exec ns  %s -S  gp -i",host);
		if(silent)strcat(cbuf," -s");
		if(full)strcat(cbuf,"-f");
		silent = 1;
		if((ofd = popen(cbuf,"w")) == NULL){
			fprintf(stderr,"can't execute pipe to '%s'\n",host);
			exit(1);
		}


	}else{
		if((fd=fopen("/etc/cpu","r")) != NULL){
			fgets(host,10,fd);
			host[strlen(host)-1] = 0;
			fclose(fd);
		}
		if( (ofd = fopen("/dev/vc","w")) == NULL){
			fprintf(stderr,"Versatec in use on '%s'\n",host);
			exit(1);
		}
	}
	if(!net && !dumb)stty(fileno(ofd),form);

	for(i=0;i<M;i++){
		input();
		if(net){
			fwrite(ibuf,sizeof(short),L,ofd);
		}else{
			p = ibuf;
			q = obuf + 20;
			if(full)q -= 18;
			for(j=0;j<L;j++){
				if(full){
					*q++ = map(12, *p);
					*q++ = map(8, *p);
					*q++ = map(4, *p);
					*q++ = map(0, *p++);
				}else{
					*q = map2(8, *p) << 8;
					*q++ |= map2(12, *p);
					*q = map2(0, *p) << 8;
					*q++ |= map2(4, *p++);
				}
			}
			for(j=0;j<(2<<full);j++){
				fwrite(obuf,sizeof(short),outlen,ofd);
			}
		}
	}

	if(!net){
		if(!dumb){
			stty(fileno(ofd),form);
		}else{
			for(i=0;i<outlen;obuf[i++] = 0);
			for(i=0;i<1500;i++)fwrite(obuf,sizeof(short),outlen,ofd);
		}
	}else{
		pclose(ofd);
	}
	if(!silent)fprintf(stderr,"output at '%s'\n",host);
}

#define K0	0000000
#define K4	0000017
#define K8	0000360
#define K1	0007400
#define K2	0170000

short tab[] = {
	(K0),
	(K1),
	(K2),
	(K1|K2),
	(K4),
	(K4|K1),
	(K4|K2),
	(K4|K2|K1),
	(K8|K0),
	(K8|K1),
	(K8|K2),
	(K8|K1|K2),
	(K8|K4),
	(K8|K4|K1),
	(K8|K4|K2),
	(K8|K4|K2|K1)
};

short   map(n,d)
	int     n;
	short   d;
{
	return( tab[ (d>>n)&017 ] );
}

#undef K0
#undef K1
#undef K2
#undef K4
#undef K8
#define K0	0000000
#define K1	0000003
#define K2	0000014
#define K4	0000060
#define K8	0000300

short tab2[] = {
	(K0),
	(K1),
	(K2),
	(K1|K2),
	(K4),
	(K4|K1),
	(K4|K2),
	(K4|K2|K1),
	(K8|K0),
	(K8|K1),
	(K8|K2),
	(K8|K1|K2),
	(K8|K4),
	(K8|K4|K1),
	(K8|K4|K2),
	(K8|K4|K2|K1)
};

short   map2(n,d)
	int     n;
	short   d;
{
	return( tab2[ (d>>n)&017 ] );
}


input()
{
	register int i, j;

	fread(ibuf,sizeof(short),L,ifd[0]);
	i = 1;
	while(i < nf){
		fread(buf,sizeof(short),L,ifd[i++]);
		for(j=0; j<L; j++)
			ibuf[j] |= buf[j];
	}
}

synerr()
{
	fprintf(stderr,"syntax: gp [-ifhsm] file1 file2 ... filen\n");
	exit(1);
}
