/*
  
  	crclabel - program to label vectors
  
	The CRC graphics package

	Malcolm Slaney
  	Purdue University
  	W. Lafayette, Indiana
  
        compile with "cc -O crclabel.c -i -lG -lm"
*/

#include	<stdio.h>
#include	<math.h>

#define	DevNum(Major,Minor)	((Major) + (Minor)*8)

#define	BIT	0	/* major device table */
#define GOV	1
#define IMAGE	2
#define	GGOV	3
#define	GIMAGE	4
#define	TEK	6
#define HP	7

#define	STDOUT		0	/* Special Device Numbers */
#define	VERSATEC	8
#define	PRINTRONIX	16
#define	RETRO		14

float   scfac  = 1.0;   /* scale factor in plot */
float	xxs,yys;	/* starting locations for the graph */
int	spd = 36;	/* speed of hp plotter */
char	*tl;		/* top label */
char	*stfl;
char	*host;		/* host overide for all pipes */
float	height = 0.2;	/* character heights */
int     pen   = 1;      /* hp pen color */
char    *siten = "pl";  /* default site for gplp */
int	blank;		/* blank flag */
int     devn;           /* minor device number */
int     dev = PRINTRONIX;/* major device number */

int     size[] = {
		sizeof(char),   /* signed char */
		sizeof(char),   /* unsigned char */
		sizeof(short),  /* short integer */
		sizeof(int),    /* integer */
		sizeof(long),   /* long integer */
		sizeof(float),  /* float */
		sizeof(double), /* double */
	};

#define INT     0
#define FLOAT   1
#define LONG    2
#define CHAR    3

struct hash  {
	char    *label;
	int     type;
	char    **pointer;
	} table[] = {
/* 1 */         {"xp",FLOAT,(char **)&xxs},
/* 2 */		{"yp",FLOAT,(char **)&yys},
/* 3 */		{"pen",INT,(char **)&pen},
/* 4 */		{"scfac",FLOAT,(char **)&scfac},
/* 5 */		{"site",CHAR,&siten},
/* 6 */		{"speed",INT,(char **)&spd},
/* 7 */		{"tl",CHAR,&tl},
/* 8 */		{"op",CHAR,&host},
/* 9 */         {"g",CHAR,&stfl},
		{0,0,0}
	};

main(argc,argv)
	int	argc;
	char	**argv;
{
	FILE    *fd;
	float   xd[514],yd[514];
	int	cx,cy;
	long	atol();
	float	max(),min();
	register int	i,j;
	float	dx,xtmp,ytmp,sftmp;
	char    buf[10];

	if((fd = fopen("/etc/cpu","r")) != NULL){
		fgets(buf,10,fd);
		buf[strlen(buf) -1] = 0;
		if(strcmp(buf,"arpa") == 0)
			dev = DevNum(GOV,0);
		fclose(fd);
	}
	file();
	args();
	parse(argc,argv);
	
	if(dev == DevNum(GOV,0) || dev == DevNum(IMAGE,0) ||
		dev == DevNum(GGOV,0) || dev == DevNum(GIMAGE,0)){
		if(devn){
			devn -= '0';
			if(dev == DevNum(IMAGE,0) || dev == DevNum(GIMAGE,0))
				devn += 1;
		}
		dev |= devn << 3;
	}
	strcpy(buf,"-");
	strcat(buf,siten);
	site(buf);
	fname(stfl);
	if(host)
		dev |= 0100;
	plots(dev,blank,host);
	newpen(pen);
	speed(spd);
	plot(xxs,yys,-3);
	factor(scfac);
	if(tl){		/* top label */
		symbol(0.0,0.0,height,tl,0.0);
	}
	plot(0.0,0.0,999);
}

err(s1,s2)
	char	*s1,*s2;
{
	fprintf(stderr,"%s%s\n",s1,s2);
	exit(1);
}

comm(s)
	char	*s;
{
	register	int	j,r;
	char    *p;
	struct hash *hp;


	for(hp=table;hp->label;hp++){
		for(j=0;(r=hp->label[j]) == s[j] && r;j++);
		if(r == 0 && s[j] == '=')
			if(!s[j+1]){
				s[j] = 0;
				err("empty string: ",s);
			}else{
				switch(hp->type){

				case CHAR:
					*hp->pointer = s + j + 1;
					break;
				case INT:
					*((int *)hp->pointer) = atoi(s+j+1);
					break;
				case FLOAT:
					*((float *)hp->pointer) = atof(s+j+1);
					break;
				case LONG:
					*((long *)hp->pointer) = atol(s+j+1);
					break;
				}
				return(hp - table + 1);
			}
	}
	p = s;
	while(*p){
		if(*p == '='){
			*p = 0;
			break;
		}
		p++;
	}
	err("bad option: ",s);
}


parse(argc,argv)
	int	argc;
	char	**argv;
{
	char    c;
	int     i;

	while(argv++ , --argc){
		if(argv[0][0] == '-')while(c = *++*argv)switch(c){

			case '0':	/* device # */
			case '1':
			case '2':
			case '3':       /* grinell */
			case '4':
				devn = c;
				break;
			case 'G':
				if (dev == IMAGE || dev == GIMAGE)
					dev = GIMAGE;
				else
					dev = GGOV;
				break;
			case 'g':	/* use graphics overlay */
				if (dev == GGOV || dev == GIMAGE)
					dev = GGOV;
				else
					dev = GOV;
				break;
			case 'i':	/* use Image Plane */
				if (dev == GGOV || dev == GIMAGE)
					dev = GIMAGE;
				else
					dev = IMAGE;
				break;
			case 'c':	/* use comtal */
				if (dev == GOV || dev == GGOV)
					dev = GOV;
				else
					dev = IMAGE;
				break;
			case 'b':	/* don't blank display */
				blank = 1;
				break;
			case 'B':	/* blank display */
				blank = 0;
				break;
			case 't':	/* use tektronix */
				dev = TEK;
				break;
			case 'T':	/* use Retro-graphics */
				dev = RETRO;
				break;
			case 'h':	/* use hp plotter */
				dev = HP;
				break;
			case 'o':       /* g=stdout */
				dev = STDOUT;
				stfl = "-";
				break;
			case 'v':       /* direct versatec mode */
				dev = VERSATEC;
				break;
			case 'p':       /* direct line printer mode */
				dev = PRINTRONIX;
				break;
			default:
				fprintf(stderr,"bad flag: -%c\n",c);
				exit(1);
			}
		else
			switch(i = comm(*argv)){

			case 9:	/* output file name */
				dev = STDOUT;
		 		break;
			case 3:		/* pen */
			case 6:		/* speed */
				dev = HP;
				break;
			case 5:	        /* site */
				dev = PRINTRONIX;
				break;
			}
	}
}

args()
{
	char	*argv[20];
	int	argc;
	char	*s,*getenv(),*p;

	if((s=getenv("CRCLABELARGS")) == NULL)return;

	argv[0] = s;
	argc = 1;
	while(*s){
		while(*s == ' ')*s++ = 0;
		if(*s){
			if(*s != '"')argv[argc++] = s;
			else{
				argv[argc++] = ++s;
				while(*s){
					if(*s != '"')s++;
					else{
						*s++ = 0;
						break;
					}
				}
			}
		}
		while( (*s != ' ')  && *s){
			if(*s != '"')s++;
			else{
				p = s;
				while(*p){
					*p = *(p+1);
					p++;
				}
				while(*s){
					if(*s != '"')s++;
					else{
						*s++ = 0;
						break;
					}
				}
			}
		}
	}
	parse(argc,argv);
}

file()
{
	int	argc;
	char	*argv[20];
	static char buf[256];
	char	*b;
	char	*getenv(),*s;
	FILE	*dfd;

	if((s = getenv("HOME")) == NULL)return;
	strcpy(buf,s);
	strcat(buf,"/.crclabelargs");
	if((dfd = fopen(buf,"r")) == NULL)return;
	argc = 1;
	b = buf;
	while(fgets(b,256-((int)(b - buf)),dfd) != NULL){
		b[strlen(b)-1] = 0;
		argv[argc++] = b;
		b += strlen(b)+1;
		if(argc == 20)break;
	}
	parse(argc,argv);
	fclose(dfd);
}

