/*
	plots - initialize graphics system

	The CRC graphics package

	Carl Crawford
	Purdue University
	W. Lafayette, IN 47907

*/

#include	"crc.h"

plots(dev,blank,str)
int	dev;
int	blank;
char	*str;
{
	char	*malloc();
	unsigned int	q;
	FILE	*fd,*popen();
	char	*DeviceSpec;
	int	ustr;	/* 1=used str */
	int	_clean();	/* clean up routine after interrupts */

	_pic = 0;   		/* pointer to bit plane */
	_xp = 0;_yp = 0;        /* integer position */
	_X = 0; _Y = 0;		/* Tek (?) Position */
	_axp = 0;_ayp = 0;      /* real position */
	_xo = 0;_yo = 0;        /* current origin */
	_ud = 0;            	/* indicates up/down for pen */
	_error = 0;         	/* indicates error in plotting */
	_fac = 0;		/* scale factor */
	_ipsz10 = 0;		/* ipsize / 10.0 */

	BLANK = blank;
	DEV = dev & 07;
	DEVN = ((dev&070)>>3);
	if(dev & 0100){
		ustr = 1;
	}else{
		ustr = 0;
	}
	_bufsize = 32768;
	_ipsz = 511.;
	TICDIS = 1.0;
	if(!STORE)STORE = "graph";
	if(!SITE)SITE = "-pl";
	HEIGHT = .2;
	DIGITS = 6;
	PLOTFILT = NULL;
	switch(DEV){

	case BIT:         /* output file mode */
		switch(DEVN){

		case 0:         /* file */
			_pipe_fd = stdout;      /* override error message */
			break;
		case 1:         /* gp */
			strcpy(_abuf,"exec gp -i ");
			if(ustr)strcat(_abuf,str);
			_pipe_fd = popen(_abuf,"w");
			break;
		case 2:        /* gplp */
			strcpy(_abuf,"exec gplp ");
			strcat(_abuf,SITE);
			strcat(_abuf," -i ");
			if(ustr)strcat(_abuf,str);
			_pipe_fd = popen(_abuf,"w");
			break;
		}
		break;
	case GOV:		/* graphics overlay */
	case IMAGE:		/* comtal image */
	case GGOV:		/* Grinnell Graphics Overlay */
	case GIMAGE:		/* Grinnell Image Plane */
		DeviceSpec = "0";
		if (DEV == IMAGE || DEV == GIMAGE){
			if (DEVN == 0)
				*DeviceSpec = NULL;
			else
				*DeviceSpec += DEVN - 1;
		} else {
			*DeviceSpec += DEVN;
		}
		sprintf(_abuf,"exec /usr/lib/graphics/gd -%c%c%s%c ",
			(DEV == GOV || DEV == IMAGE) ? 'C' : 'G',
			(DEV == GOV || DEV == GGOV) ? 'o' : 'i',
			DeviceSpec,
			BLANK ? 'b' : ' ');
		if(ustr)strcat(_abuf,str);
		_pipe_fd = popen(_abuf,"w");
		break;
	case PLOT:
		if (ustr && str){
			char	buffer[BUFSIZ];

			sprintf(buffer,"%s -T%s\n",PLOTBIN,str);
			PLOTFILT = str;
			_pipe_fd = popen(buffer,"w");
		} else if( str != NULL &&  *str != '\0' ){
			if( ( _pipe_fd = fopen(str , "a" )) == NULL ){
				fprintf(stderr,"ERROR in opening file %s \nExiting\n",  str);
				exit(-1);
			}
		} else {
			_pipe_fd = fdopen(dup(1),"w");
		}
		p_space(0,0,7800,7800);
		if (!BLANK)
			p_erase();
		break;
	case TEK:         /* tektronix */
		_pipe_fd = fdopen(dup(1),"w"); /* buffer Tek info */
		break;
	case HP:        /* HP */
		strcpy(_abuf,"exec /usr/lib/graphics/hpd ");
		if(ustr)strcat(_abuf,str);
		_pipe_fd = popen(_abuf,"w");
		break;
	default:
		fprintf(stderr,"plots: bad device number\n");
		exit(1);
	}
	if(_pipe_fd == NULL){
		fprintf(stderr,"can't execute pipe\n");
		exit(1);
	}
	if(DEV <= MBIT){
		if( (_pic = (unsigned short *) malloc(_bufsize)) == NULL){
			_err("plots: can't allocate space","");
		}
		if(BLANK&&DEV==0&&DEVN==0&&((fd=fopen(STORE,"r"))!=NULL)){
			fread(_pic,sizeof(*_pic),16384,fd);
			fclose(fd);
		}else{
			for(q=0;q<16384;_pic[q++] = 0);
		}
	}
	else{
		plotinit();
		_hsig = signal(SIGHUP,_clean);
		_isig = signal(SIGINT,_clean);
		_qsig = signal(SIGQUIT,_clean);
		_ipsz = 7790.;
	}
	_ipsz10 = _ipsz / 10.0;
	_xo = _yo = _axp = _ayp = 0.0;
	_xp = _yp = _error= 0;
	_ud = 1;
	_fac = 1.0;
}

plotinit()
{
	register i,j;
	int	tty[3];
	register char *p;


	if(DEV == TEK){
		_CM = 0;

		/* set to 'bs0' and 'lcase' */

		gtty(0,_intty);
		tty[0] = _intty[0];
		tty[1] = _intty[1];
		tty[2] = _intty[2] & ~000004 & ~0100000;
		stty(0,tty);

		if(!BLANK){	/* blank sreen if necessary */
			switch(DEVN) {
			    case 0:
			    case 2:
				plotp(ESC);	
				plotp(FF);
				fflush(_pipe_fd);
				sleep(2);
				break;
			    case 1:	/* extra stuff for Retrographics */
				plotp(GS);
				plotp(SUB);
				plotp(EM);
				plotp(ESC);	
				plotp(FF);
				plotp(US);
				fflush(_pipe_fd);
			    }
		}
		_FILL = 0;
		plotp(ESC);	/* set proper vector type */
		plotp('`');
		return;
	}

	if(DEV == HP){
		_CM = 0;
		plotp(ESC);    
		plotp('.');	
		plotp('(');
		plotp(ESC);  
		plotp('.'); 
		plotp('M');
		plotp(':');  
		plotp(ESC);
		p = ".I513;5;71;10:";
		while(*p)plotp(*p++);
		/*  Set handshake mode 2, buff size 513 bytes, enquire  = ^E,
			GO string singal = "G\n" */
		plotp('~');	
		plotp('W');
		pmbpo(380,366);
		pmbpo(13903,10668);
		plotp('~');	
		plotp('S');
		pmbpo(10244,7804);
		plotp('}');
		_CM = 1;
		plotp(ETX); /* set proper vector type */
		plotp('}');
		plotp('~');
		plotp('R');
		plotp('}');
		alpha();
		newpen(1);
	}
}
