#include	"crc.h"

/*
	plot - draw vectors

	The CRC graphics package

	Carl Crawford
	Purdue University
	West Lafayette, IN 47907

	September 1980

*/


#define MASK	0100000

plot(x,y,i)
float x,y;
int i;
{
	int l,m;

	switch((i>0)? i : -i){
	case 1:
		break;
	case 2:
		_ud = 0;
		break;
	case 3:
		_ud = 1;
		break;
	case 999:
		if(DEV > MBIT)_plotend();
		else{
			dsply();
			free(_pic);
		}
		return;
	default:
		return;
	}

	if( _fac != 1.0){
		x *= _fac;	
		y *= _fac;
	}
	l = floor( ( x + _xo )*_ipsz10 + 0.5) - _xp;
	m = floor( ( y + _yo )*_ipsz10 + 0.5) - _yp;

#ifdef	OLD
	l = floor( ( x + _xo - _xp/_ipsz10)/10.0 * _ipsz + 0.5 );
	m = floor( ( y + _yo - _yp/_ipsz10)/10.0 * _ipsz + 0.5 );
#endif	OLD

	if(_ud == 0){
		if(DEV <= MBIT)_bresen(l,m);
		else{
			drawr(l, m);
			_xp += l;
			_yp += m;
		}
	}
	else{
		_xp += l;
		_yp += m;
		if(DEV > MBIT)_mover( l,m);
	}
	_axp = _xo + x;
	_ayp = _yo + y;
	if(i<0){
		_xo = _axp;
		_yo = _ayp;
	}
}

_bresen(dx,dy)
int dx,dy;
{
	int ix,iy,major[2],minor[2],nb;
	int	zerozero[2];
	register int na,nc,nctr;

#ifdef	OLD
	if(dx == 0 && dy == 0)return;
#endif	OLD
	/* Resolve to first quadrant */
	ix=1;
	if(dx<0){
		ix = -1;
		dx = -dx;
	}
	iy=1;
	if(dy<0){
		iy = -1;
		dy = -dy;
	}

	/* Resolve to proper octant */
	major[1] = iy;
	major[0] = ix;
	if(dx<dy){
		minor[0] = 0;
		minor[1] = iy;
		na = dy;
		nb = dx + dx;
	}
	else{
		minor[1] = 0;
		minor[0] = ix;
		na = dx;
		nb = dy + dy;
	}
	nc = na + na;
	nctr = na;

	zerozero[0] = zerozero[1] = 0;
	step(zerozero);
	/* Loop through all the steps */
	while(nctr>0){
		na = na + nb;
		if(na>=nc){
			na -= nc;
			step(major);
		}
		else{
			step(minor);
		}
		nctr -= 1;
	}
}

step(a)
int a[];
{
	register int pos,c;
	register unsigned short bit;

	_xp += a[0];
	_yp += a[1];
	if(_xp<0 || _xp>511 || _yp<0 || _yp>511){
		if(_error == 0){
			fprintf(stderr,"attempt to plot outside of picture\n");
		}
		_error = 1;
		return;
	}

	pos = (16352 - (_yp<<5))+(_xp>>4);
	bit = 1<<(15-(_xp&017));
	_pic[pos] |= bit;
}

dsply()
{
						/*
						 * Check to see if output is
						 * to a bit mapped device that
						 * needs an output filter.  
						 * Write the bit map and then
						 * do a pclose to wait for the
						 * end of the proc.
						 */
	if((DEVN && DEV == BIT) || DEV == GOV || DEV == IMAGE
		|| DEV == GGOV || DEV == GIMAGE){
		write(fileno(_pipe_fd), _pic, _bufsize);
		pclose(_pipe_fd);
		return;
	}
	if(STORE[0] == '-' && STORE[1] == '\0'){
		_pipe_fd = stdout;
	}else{
		if((_pipe_fd=fopen(STORE,"w")) == NULL)_err("can't create: ",STORE);
	}
	write(fileno(_pipe_fd), _pic, _bufsize);
	fclose(_pipe_fd);
}

drawr(deltax,deltay)
int deltax,deltay;
/*
 *	Draw to relative postion given by delta-x and delta-y.
 */
{
	register x,y;

	x = deltax + _X;
	while(x < 0)x += 10230;
	if(x > 10230)x %= 10230;
	y = deltay + _Y;
	while(y < 0)y += 7790;
	if(y > 7790)y %= 7790;
	draw(x,y);
}

draw(x,y)
int x,y;
/*
 *	Draw a vector from current co-ordinate to (x,y).
 */
{
	register i;

	x &= 037777;	
	y &= 037777;
	if(DEV == TEK){
		if((_CM & 1) == 0){
			_CM++;
			plotp(GS);
			_CM &= 0177775;
			_CM += 2;
			plotty(_Y);	
			plottx(_X);
			plotfil(x,y);
			plotty(y);
			plottx(x);
			_X = x;	
			_Y = y;
			return;
		}
		if((_CM & 2) == 0){
			plotty(_Y);	
			plottx(_X);
			_CM &= 0177775;	
			_CM += 2;
		}
		plotfil(x,y);
		plotty(y);	
		plottx(x);
		_X = x;	
		_Y = y;
		return;
	}

	if(DEV == HP){
		if((_CM & 1)== 0){
			plotp(ETX);
			_CM&= 0177774;
			_CM += 1;
		}
		if(_CM & 2){		/* next will draw	*/
			pmbpo(x,y);
		}
		else{
			plotp('p');
			pmbpo(_X,_Y);
			pmbpo(x,y);
			_CM &= 0177774;	
			_CM += 3;
		}
		_X = x;	
		_Y = y;
	}

	if (DEV == PLOT){
		p_cont(_X=x,_Y=y);
		_X = x;	
		_Y = y;
	}

}

plotfil(x,y)
int x,y;
/*
 *	Look at magnitude of change in current X andY and
 *	new x and y.  Set correct number of fill charctors.
 */
{

	x -= _X;	
	if(x < 0) x = -x;
	y -= _Y;	
	if(y < 0) y = -y;
	x &= 070000;	
	y &= 070000;
	x >>= 12;	
	y >>= 12;
	_FILL = x;	
	_FILL += y;
	_FILL++;	/* for good measure */
}

_mover(deltax,deltay)
int deltax,deltay;
/*
 *	Routine to move by +- delta-x and +- delta-y
 */
{
	register x,y;

	x = deltax + _X;
	while(x < 0)x += 10230;
	if(x > 10230)x %= 10230;
	y = deltay + _Y;
	while(y < 0)y += 7790;
	if(y > 7790)y %= 7790;
	move(x,y);
}

move(x,y)
int x,y;
/*	
 *	Move to an x,y co-ordinate.  Leave in graphic mode.
 */
{

	x &= 037777;	
	y &= 037777;
	if(DEV == TEK){
		if((_CM & 1) == 0){
			plotp(GS);
			_CM++;
			_CM &= 0177775;	
			_CM += 2;
			plotty(y);	
			plottx(x);
			_X = x;	
			_Y = y;
			return;
		}
		if((_CM & 2) == 2){
			plotp(GS);
		}
		plotty(y);	
		plottx(x);
		_CM &= 0177775;	
		_CM += 2;
		_X = x;	
		_Y = y;
		return;
	}

	if(DEV == HP){
		if((_CM & 1) == 0){
			plotp(ETX);	/* end alpha mode	*/
			_CM &= 0177774;
		}
		if(_CM & 2){
			plotp('}');
		}
		plotp('p');
		pmbpo(x,y);
		_CM |= 3;
		_X = x;	
		_Y = y;
	}

	if (DEV == PLOT)
		p_move(_X=x, _Y=y);

}

plotty(n)
int n;
/*	Prints out a 10-bit Tektronics number supplied in n.
 */
{
	register char c;
	register i,j;

	i = n/10;
	if((n % 10) > 4)i++;
	j = i >> 5;
	plotp((j & 037) + 040);
	plotp((i & 037) + '`');
}

plottx(n)
int n;
/*	Prints out a 10-bit Tektronics number supplied in n.
 */
{
	register char c;
	register i,j;

	i = n/10;
	if((n % 10) > 4)i++;
	j = i >> 5;
	plotp((j & 037) + 040);
	plotp((i & 037) + 0100);
	while(_FILL--)plotp(1);
	_FILL = 0;
}

pmbpo(x,y)
int x,y;
{
	/*	Puts out x and y in HP MBP format.	*/
	register max;
	register char c;

	x &= 037777;	
	y &= 037777;
	max = x;
	if(y > x)max = y;
	if(max < 4){
		plotp(0140 + (x << 2) + y);
		return;
	}
	if(max < 32){
		plotp(0140 + (x >> 1));
		c = ((x <<5) & 040) + y;
		if(!(c & 040))c += 0100;
		plotp(c);
		return;
	}
	if(max < 256){
		plotp(0140 + (x >> 4));
		c = ((x << 2) & 074) + ((y >> 6) & 3);
		if(!(c & 040))c += 0100;
		plotp(c);
		c = y & 077;
		if(!(c & 040))c += 0100;
		plotp(c);
		return;
	}
	if(max < 2048){
		c = 0140 + ((x >> 7) & 017);
		plotp(c);
		c = (x >> 1) & 077;
		if(!(c & 040))c += 0100;
		plotp(c);
		c = ((x << 5) & 040) + ((y >> 6)& 037);
		if(!(c & 040))c += 0100;
		plotp(c);
		c = y & 077;
		if(!(c & 040))c += 0100;
		plotp(c);
		return;
	}
	c = (x >> 10) & 017;
	plotp(c + 0140);
	c = (x >> 4) & 077;
	if(!(c & 040))c += 0100;
	plotp(c);
	c = ((x << 2) & 074) + ((y >> 12) & 3);
	if(!(c & 040))c += 0100;
	plotp(c);
	c = (y >> 6) & 077;
	if(!(c & 040))c += 0100;
	plotp(c);
	c = y & 077;
	if(!(c & 040))c += 0100;
	plotp(c);
}

pmbno(n)
int n;
{
	/*	print out n in HP MBN format	*/
	register char c;

	n &= 0177777;
	if(n < 16){
		plotp(n + '`');
		return;
	}
	if(n < 1024){
		c = '`' + ((n >> 6)& 017);
		plotp(c);
		c = n & 077;
		if(!(c & 040))c += 0100;
		plotp(c);
		return;
	}
	c = (n >> 12) & 07;
	plotp(c + 0140);
	c = (n >> 6) & 077;
	if(!(c & 040))c += 0100;
	plotp(c);
	c = n & 077;
	if(!(c & 040))c += 0100;
	plotp(c);
}
