/*
	laxis - draw logarithmic axes

	The CRC graphics package

	Carl Crawford 
	Purdue University
	West Lafayette, IN 47901

	October 1981
*/

#include	"crc.h"

laxis(x,y,label,xy,size,logmin,logmax,flag)
float x,y,size;
char *label;
int xy,logmin,logmax,flag;

{


	int ns,k,iexp,flg,i,test;
	float t[10],a,b,angle,height,ttt,tt,ht,ipd,length;
	char exp[5];

	_schk((float)logmax,(float)logmin);
	ipd = size/((float)(logmax-logmin));

	if(size <= 0. || ipd <= 0.)_err("parameter error in 'laxis'","");

	height = .7*HEIGHT;

	length=4.*height;
	if(xy == 1 || xy ==3)length=HEIGHT;

	test = (int)(length/ipd) + 1;

	tt=.1;
	ttt=.075;
	ht=.0375;

	t[1]=.301; 
	t[2]=.477; 
	t[3]=.602; 
	t[4]=.699;
	t[5]=.778; 
	t[6]=.845; 
	t[7]=.903; 
	t[8]=.954;

	iexp= logmin-1;

	plot(x,y,-3);

	flg=flag;
	if(flag < 0)flg= -flag;

	ns = _ssize(label);

	switch(xy){
	case 0:
		plot(size,0.,2);
		i=0;
		a= 0.;
		while(a < .01+ size){
			iexp=iexp+1;
			plot(a,0.,3);
			plot(a,-ttt,2);
			if(flag >= 0 && i%test == 0){
				plot(a,0.,3);
				plot(a,-tt,2);
				symbol(a-.714*height,-(tt+1.93*height),height,"10",0.);
				sprintf(exp,"%d",iexp);
				symbol(a+height,-(tt+1.36*height),.8*height,exp,0.);
			}
			k=1;
			b=a+t[1]*ipd;
			while(k < 9 && b < size && flg != 1){
				if((flg == 2 && (k == 1 || k == 4)) || flg != 2){
					plot(b,0.,3);
					plot(b,-ht,2);
				}
				k=k+1;
				b=a+t[k]*ipd;
			}
			i=i+1;
			a=a+ipd;
		}
		a=.5*(size-.857*HEIGHT*ns);
		b= -tt-2.95*HEIGHT-.6*HEIGHT;
		angle=0.;
		break;
	case 1:
		plot(0.,size,2);
		i=0;
		a=0.;
		while(a < .01+ size){
			iexp=iexp+1;
			plot(0.,a,3);
			plot(-ttt,a,2);
			if(flag >= 0 && i%test == 0){
				plot(0.,a,3);
				plot(-tt,a,2);
				symbol(-(tt+4.23*height),a-.5*height,height,"10",0.);
				sprintf(exp,"%d",iexp);
				symbol(-(tt+2.516*height),a+.07*height,.8*height,exp,0.);
			}
			k=1;
			b=a+t[1]*ipd;
			while(k < 9 && b < size && flg != 1){
				if((flg == 2 && (k == 1 || k == 4)) || flg != 2){
					plot(0.,b,3);
					plot(-ht,b,2);
				}
				k=k+1;
				b=a+t[k]*ipd;
			}
			i=i+1;
			a=a+ipd;
		}
		b=.5*(size-.857*HEIGHT*ns);
		a= -tt-3.75*HEIGHT-.6*HEIGHT;
		angle=90.;
		break;
	case 2:
		plot(size,0.,2);
		i=0;
		a=0.;
		while(a < .01+size){
			iexp=iexp+1;
			plot(a,0.,3);
			plot(a,ttt,2);
			if(flag >= 0 && i%test == 0){
				plot(a,0.,3);
				plot(a,tt,2);
				symbol(a-.714*height,tt+.43*height,height,"10",0.);
				sprintf(exp,"%d",iexp);
				symbol(a+height,tt+.86*height,.8*height,exp,0.);
			}
			k=1;
			b=a+t[1]*ipd;
			while(k < 9 && b < size && flg != 1){
				if((flg == 2 && (k == 1 || k == 4)) || flg != 2){
					plot(b,0.,3);
					plot(b,ht,2);
				}
				k=k+1;
				b=a+t[k]*ipd;
			}
			i=i+1;
			a=a+ipd;
		}
		a=.5*(size-.857*HEIGHT*ns);
		b= tt+2.*HEIGHT+.6*HEIGHT;
		angle=0.;
		break;
	case 3:
		plot(0.,size,2);
		i=0;
		a=0.;
		while(a < .01+size){
			iexp=iexp+1;
			plot(0.,a,3);
			plot(ttt,a,2);
			if(flag >= 0 && i%test == 0){
				plot(0.,a,3);
				plot(tt,a,2);
				symbol(tt+.43*height,a-.5*height,height,"10",0.);
				sprintf(exp,"%d",iexp);
				symbol(tt+2.14*height,a+.07*height,.8*height,exp,0.);
			}
			k=1;
			b=a+t[1]*ipd;
			while(k < 9 && b < size && flg != 1){
				if((flg == 2 && (k == 1 || k == 4)) || flg != 2){
					plot(0.,b,3);
					plot(ht,b,2);
				}
				k=k+1;
				b=a+t[k]*ipd;
			}
			i=i+1;
			a=a+ipd;
		}
		b=.5*(size-.857*HEIGHT*ns);
		a= tt+4.76*HEIGHT+.6*HEIGHT;
		angle=90.;
		break;
	default:
		plot(-x,-y,-3);
		return;
	}

	symbol(a,b,HEIGHT,label,angle);
	plot(-x,-y,-3);
	return;
}
