/*
 *	Qplot C Example - Compute and plot a Gaussian Random Variable
 *
 *	Compile with 
 *		cc ex3.c -lm -o ex3
 *
 *	Run with
 *		ex3
 */

#include	<stdio.h>
#include	<math.h>

main(){
	int	i;
	double	x, y, Gauss();
	FILE	*xfile, *yfile;

	xfile = fopen("x","w");			/* Open the x and y files */
	yfile = fopen("y","w");

	if (!xfile || !yfile){			/* Check for Errors */
		printf("Can't open files for output.\n");
		exit(1);
	}

	for (i=0;i<100;i++){			/* Now compute 100 RV's */
		x = Gauss()*3.0;		
		y = Gauss();
						/* Check for out of bounds */
		if (x < -1 || x > 1 || y < -1 || y > 1)
			continue;
		fprintf(xfile,"%f\n",x);	/* Print out the values */
		fprintf(yfile,"%f\n",y);
	}
	fclose(xfile);				/* Close the files */
	fclose(yfile);
}

#define	NUM	25

						/*
						 * Compute a Gaussian random
						 * variable by summing a number
						 * of uniformly distributed
						 * variables.
						 *
						 * The returned value will 
						 * have a mean of 0.
						 */
double
Gauss(){
	int	i;
	float	x;

	x = 0;
	for (i=0;i<NUM;i++)			
		x += (float)random();

						/*
						 * Scale the sum by the 
						 * maximum value from the
						 * random() subroutine and
						 * the number of RV's summed.
						 */
	return(x/((float)0x7fffffff*NUM/2) - 1.0);
}
