c
c	Plot3d Fortran Example - Compute and plot a semi-Gaussian function
c				 for non-uniform values of x and y.
c
c	Compile with
c		f77 ex.4 -lU77 -o ex4
c
c	Run with
c		ex4
c
	real	tmp(32)
	integer	ucreat
c				The damping constant is different for 
c				negative and positive values of x while 
c				it is constant along the y axis.
c				Set the different damping constants
c				of the Gaussian function. 
	sigx1	= 3.5
	sigx2	= 7.5
	sigy	= 12.5
c				Create the z file.
	ifd	= ucreat("z",420)
c				Compute the function.
	do 30 j=1 , 16
	    yfact	= exp( - ( abs(j-3.5) / sigy ) ** 2 )
c				Compute the first half of the Gaussian function.
	    do 10 i=1 , 16
		tmp(i)	= exp( - ( abs(i-16.5) / sigx1 ) ** 2 ) * yfact
10	    continue
c				Compute the second half of the Gaussian
c				function with a different damping constant.
	    do 20 i=17 , 32
		tmp(i)	= exp( - ( abs(i-16.5) / sigx2 ) ** 2 ) * yfact
20	    continue
	    call uwrite(ifd,tmp,4*32)
30	continue
c				Open the file x.
	open(unit=2,file="x",status="unknown",form="formatted")
c				Compute the values of x.
	x	= - 10.0 * 16.0 * 0.5 * 0.5
c				To make the sampling non-uniform,
c				use the random function generater.
	do 40 i=1 , 32
	    x	= x + 10.0 * rand(13*i) * rand(17*i)
	    write(2,*)x
40	continue
c				Close the file x.
	close(2)
c				Open the file x.
	open(unit=3,file="y",status="unknown",form="formatted")
c				Compute the values of y.
	y	= - 30.0 * 8.0 * 0.5 * 0.5
c				To make the sampling non-uniform,
c				use the random function generater.
	do 50 i=1 , 16
	    y	= y + 30.0 * rand(13*i) * rand(17*i)
	    write(3,*)y
50	continue
c				Close the file y.
	close(3)
	stop
	end
