/*
	genfont - generate character font files

	The CRC graphics package

	Carl Crawford 
	Purdue University
	W. Lafayette, IN 47907

	October 1981
*/

/*
     The file generated by 'genfont' has the following format:

short  height     Default character height.
short  size       Bytes of core required to hold coordinates.
short  pnt[256]   Indexes to 1st coordinate of each symbol.
short  crd[size]  Coordinates of symbols

Where each crd[i] has the following format:

  EVSXXXXXXSYYYYYY   (a 'short' is assumed to be 16 bits)
  III     IIIIIIII
  III     I   I----- Y coordinate (sign magnitude format)
  IIIIIIIII
  II   I----- X coordinate (sign magnitude format)
  II----- Line segment visible flag (0=invisible, 1=visible)
  I----- 1=more coordinates; 0=last coordinate


  The file used as input to 'genfont' as the following format:

  \n/x0,y0,v0/x1,y1,v2/.../xm,ym,vm<cr>
  .
  .
  .

  where:
	  'n' is the character in octal.
	  xi, i=1,2,..m is the x coordinate of the i'th segment
	  yi, i=1,2,..m is the x coordinate of the i'th segment
	  vi, i=1,2,..m is the visible indicator of the i'th segment
		v = 0 => invisible
		  = 1 => visible

*/

#include <stdio.h>

FILE	*fd;		/* output file descriptor */
FILE	*ifd;		/* input file descriptor */
char	j[512];		/* input character buffer */
int	i1;		/* general integer */
int	i3;		/* position within file */
int	k1;		/* x position */
int	k2;		/* y position */
int	k3;		/* visib flag */
short	l;		/* formed coordinate */
int	n;		/* character number */
struct{			/* header structure */
	short  height;
	short  coordsz;
	short  pntr1st[256];
}fontcom;

main(argc, argv)
	int  argc;
	char  **argv;
{

	if(argc != 3)synerr();
	if((fd = fopen(argv[1],"w")) == NULL)err("can't create ",argv[1]);
	if(strcmp(argv[1],argv[2])==0){
		err("output and input files have the same name","");
	}
	if((ifd = fopen(argv[2],"r"))==NULL)err("can't open: ",argv[2]);
	for (i1=0; i1<256; i1++)fontcom.pntr1st[i1] = -1;

	/* get height of font */

	if(gread())err("can't read height","");
	fontcom.height = atoi(j);

	/* save space for header */

	fseek(fd,(long)sizeof(fontcom),0);
	
	/* loop through all the entries */

	while(!gread()){
		if (*j == '\\') {
			n = atoi(j+1);
			n = (n/100*64) + (((n/10)%10)*8) + n%10;
			if (n<0 || n>255)err("invalid character number ",j+1);
			fontcom.pntr1st[n] = i3;

			/* terminate previous character */

			fseek(fd,-(long)sizeof(l),1);
			l |= 0100000;
			fwrite(&l,sizeof(l),1,fd);
		}else{
			k1 = atoi(j);
			if(gread())err("incomplete coordinate specified","");
			k2 = atoi(j);
			if(gread())err("incomplete coordinate specified","");
			k3 = atoi(j)&&01;
			l = (k3<<14) | ((abs(k1)%128)<<7) | (abs(k2)%128);
			if(k1 < 0)l |= 0020000;
			if(k2 < 0)l |= 0100;
			fwrite(&l,sizeof(l),1,fd);
			fontcom.coordsz += sizeof(l);
			i3++;
		}
	}

	/* clean up last character */

	fseek(fd,-(long)sizeof(l),1);
	l |= 0100000;
	fwrite(&l,sizeof(l),1,fd);

	/* write header */

	fseek(fd,(long)0,0);
	fwrite(&fontcom,sizeof(fontcom),1,fd);
	exit(0);
}

gread()
{
	char	*c;

	c = j;
	while((*c = fgetc(ifd)) != EOF){
		if(*c == ',' || *c == '/' || *c == '\n')return(0);
		c++;
	}
	return(1);
}

err(s1,s2)
	char	*s1,*s2;
{
	fputs(s1,stderr);
	fputs(s2,stderr);
	fputc('\n',stderr);
	exit(1);
}

synerr(){
	err("syntax: genfont <output file> <input file>","");
}
