
      subroutine hide(x,y,xg,g,xh,h,ng,maxdim,n1,nfns,
     &xlnth,ylnth,xmin,deltax,xlabel,ymin,deltay,ylabel)

c
c     n1 = the number of points plotted in a given call.  If
c          n1 < 0 Y vs X will be plotted in reverse order.
c     x  = a real array containing the horizontal coodinates.
c          The contents of x must be in increasing order.
c          x has dimension n1.
c     y  = a real array containing the vertical coordinates. y has
c          dimension n1.
c     g & xg = two real arrays that hold the current visual
c          maxima.
c     h & xh = two work arrays.
c     ng = a non-positive integer.
c            ng = 0  - draw the 8 1/2 x 11 border and plot visual
c                      maxima.
c            ng = -1 - don't draw the 8 1/2 x 11 border but plot
c                      visual maxima.
c            ng = -2 - draw the border and plot visual minima.  This
c                      results in the "bottom view" of the graph.
c            ng = -3 - don't draw the border but plot the visual
c                      minima.
c     maxdim = the dimension of g, xg, h, xh. If the program is
c          about to go out of bounds in these arrays maxdim will
c          be returned as its negative.  When the subroutine is
c          called with maxdim < 0 it will immediately return.
c     nfns = the total number of curves to be plotted.  If a plot
c          is desired with no shift then nfns is the negative of
c          this number.  nfns = 0 will plot the curve with the
c          same ammount of shift as in the last call.
c     xlnth = length (in inches) of the horizontal axis.
c     ylnth = length (in inches) of the vertical axis.
c     xmin = the minimum value of x.
c     ymin = the minimun value of y.
c     deltax = the x increment per inch.
c     deltay = the y increment per inch.
c
      dimension x(1), y(1), xg(1), g(1), h(1), xh(1)
      character xlabel(1), ylabel(1)
c
c the only purpose of the following equivalence statement
c is to save storage.
c
      equivalence (k1,iwhich), (k2,slope), (fnsm1,z1),
     +            (iggp1,k1), (k1,n2)
c
c eps1 is the relative abcissa increment used to simulate
c discontinuities in the maximum function.
c
      data eps1 /1.0e-3/
c
c the following statement function computes the ordinate on
c the line joining (xi,yi) and (xip1,yip1) corresponding to
c the abcissa xx.
c
      f(xx,xi,yi,xip1,yip1) = yi + (xx - xi) * (yip1 - yi) /
     +                        (xip1 - xi)
      if (maxdim.le.0) return
      ifplot = 1
      if (n1.gt.0) go to 76
      n1 = -n1
      ifplot = 0
   76 do 71 i=2,n1
      if (x(i-1).lt.x(i)) go to 71
      maxdim = 0
      write(6,1020)
1020  format('abcissa array not in increasing order')
      go to 75
   71 continue
      if (ng.gt.0) go to 5000
      if (n1 + 4.0.le.maxdim) go to 74
      maxdim = -maxdim
   75 return
c
c we want sign = 1 if we are plotting maximum, = -1 if
c minimum
c
   74 sign = 1.0
      if (ng.lt.-1) sign = -1.0
c
c the kth curve to be plotted will (optionally) be
c translated by the vector (-dxin,dyin) * (k - 1) to
c simulate stepping in the depth dimension.
c
      fnsm1 = 0.0
      if (nfns.le.0) go to 46
      fnsm1 = nfns - 1
      dxin = (9.0 - abs(xlnth)) * deltax / fnsm1
      dyin = (6.0 - abs(ylnth)) * deltay / fnsm1
c
c systems routine plot moves the pen to a point whose
c coordinates are specified in inches by the first two
c parameters.  the pen is picked up if the absolute value of
c the third parameter is 3, is put down if 2, and is left as
c after last call if 1.  if the third parameter is negative,
c a new reference point will be established.
c
   46 if (ng.eq.-1.or.ng.eq.-3) go to 41
c
c draw 8 1/2 by 11 inch border.
c
      call plot(0.0,0.0,3)
      call plot (11.0,0.0,2)
      call plot (11.0,8.5,1)
      call plot (00.0,8.5,1)
      call plot (00.0,0.0,1)
      call plot (01.625,2.0,-3)
c
c call systems routine to plot the 80-character title.
c the first two arguments are the coordinates in inches
c relative to the reference point of the lower left-hand
c corner of the first character.  the third argument
c determines the height in inches of the characters.  the
c fifth argument gives the angle relative to horizontal of
c the plotted characters.
c
   41 if (xlnth.lt.0.0) go to 42
c
c call systems routine to draw the horizontal axis.  the
c left end is specified in inches relative to the reference
c point by the first two arguments.
c
      call axis (9.0 - xlnth, 0.0, xlabel, 0, xlnth, 
     *xmin, xlnth*deltax+xmin, 1)
      if (ylnth.lt.0.0) go to 43
c
c draw the depth axis.
c
      call plot (9.0 - xlnth, 0.0, 3)
      call plot (0.0, 6.0 - ylnth, 2)
   42 if (ylnth.lt.0.0) go to 43
c
c draw the vertical axis.  the bottom point is specified in
c inches relative to the reference point by the first two
c arguments.
c
      call axis (0.0, 6.0 - ylnth, ylabel, 1, ylnth, ymin,
     *ylnth*deltay+ymin, 0)
c
c curves successively farther in the background will be
c plotted where they are not hidden by g vs xg.  g vs xg
c will be updated each time a new curve is drawn and will be
c the visual maximum (or minimum) function of the curves
c already plotted.
c
   43 indext = 3
      do 3 j=1,n1
      xg(indext) = x(j)
      g(indext) = sign * y(j)
    3 indext = indext + 1
c
c the following precautionary step is used in place of a
c test in subroutine lookup to see if the value for which we
c want an index is outside the table.
c the last xg value will be set equal to the last abcissa
c of the curve to be plotted in the next call to hide.
c
      eps = eps1 * (abs(xmin) + abs(deltax))
      ng = n1 + 4
      xg(1) = -fnsm1 * dxin + xmin - abs(xmin) - abs(xg(3)) - 1.0
      xg(2) = xg(3) - eps
      xg(n1 + 3) = xg(n1 + 2) + eps
      zz = ymin
      if (sign.lt.0.0) zz = -ymin - 50.0 * deltay
      g(1) = zz
      g(2) = zz
      g(n1+3) = zz
      g(ng) = zz
c call systems routine to produce a line plot of
c (x(i), y(i), i=1,n1) - this is the curve farthest in the
c foreground.
c xstart is the x value at the reference point.
c
      xstart = xmin - (9.0 - abs(xlnth)) * deltax
c
      if(ifplot.eq.1) call pdatax(x,y,n1,xstart,deltax,ymin,deltay)
      dxkk = 0.0
      dykk = 0.0
      relinc = deltax / deltay
      xg(ng) = sign
      return
c
c statement 5000 is reached if any except the curve farthest
c in the foreground is to be plotted.
c
 5000 sign = xg(ng)
      xg(ng) = x(n1)
c
c translate the arrays before plotting to simulate stepping
c in the depth dimension.
c
      if (nfns) 52, 48, 49
   49 dxkk = dxkk + dxin
      dykk = dykk + dyin
   48 do 4 j=1,n1
      y(j) = sign * (y(j) + dykk)
    4 x(j) = x(j) - dxkk
   52 call lookup (x(1), xg(1), jj)
      if (jj.ge.maxdim) go to 700
      do 31 j=1,jj
      xh(j) = xg(j)
   31 h(j) = g(j)
      ig = jj + 1
      xh(ig) = x(1)
      h(ig) = f(x(1), xg(jj), g(jj), xg(ig), g(ig))
c
c we will be making table lookups for an increasing sequence
c of numbers - therefore, we do not have to search from the
c first of the (xg and x) tables each time.  hence indexg
c and indext.
c
      indexg = jj
      indext = 1
      z1 = x(1)
      f1 = h(ig) - y(1)
      it = 2
      jj = ig
      if (h(ig).ge.y(1)) go to 32
      if (jj.ge.maxdim) go to 700
      jj = ig + 1
      h(jj) = y(1)
      xh(jj) = z1 + eps
   32 last = 0
      x1 = z1
c
c find the first zero, z2, of the function g-y to the right
c of z1.
c
 1100 if (xg(ig).lt.x(it)) go to 1001
c
c do not jump if we are to look for a zero between x1 and
c x(i).
c
      iwhich = 0
      x2 = x(it)
      f2 = f(x2, xg(ig - 1), g(ig - 1), xg(ig), g(ig)) - y(it)
      it = it + 1
      go to 1002
c
c come to 1001 if we are to look for a zero between x1 and
c xg(ig).
c
 1001 x2 = xg(ig)
      iwhich = 1
      f2 = g(ig) - f(x2, x(it - 1), y(it - 1), x(it), y(it))
      ig = ig + 1
c
c the function (g - y) has a zero z2 such that x1 le z2 le x2
c if and only if (g - y at x1) * (g - y at x2) le 0.
c (g - y is assumed, for plotting purposes, to be linear on
c each interval (x1, x2).)
c
 1002 if (f1 * f2.gt.0.) go to 1005
      if (f1.eq.f2) go to 1005
      slope = (f2 - f1) / (x2 - x1)
      igg = ig - 1 - iwhich
      itt = it - 2 + iwhich
      if (abs(slope * relinc) .gt. eps1) goto 1007
c
c if g and y differ imperceptibly (for plotting purposes)
c on the interval (x1, x2), set z2 = x2.  this step prevents
c division by zero.
c
      z2 = x2
      go to 1006
c
c otherwise, compute the zero z2.
c
 1007 z2 = x1 - f1 / slope
      go to 1006
c
c if no zero was found between x1 and x2, continue the
c search for zeroes.
c
 1005 x1 = x2
      f1 = f2
      if (it.le.n1) go to 1100
c
c if the end of the x table has been reached, consider the
c interval from the last zero found to the end of the x
c table (plot, update maximum function as indicated).
c
 1008 last = 1
      z2 = x(n1)
      call lookup (z2, xg(indexg), igg)
      igg = indexg + igg - 1
      itt = n1 - 1
c
c it is necessary to plot y vs x on the interval (z1, z2)
c only if y is unhidden at each zz such that z1 lt zz lt z2.
c we choose zz near the left end of the interval for
c efficiency in the table lookup.
c note that it is more efficient to choose this value for zz
c than, say, 0.99 * x(indext) + 0.01 * x(indext + 1), which
c would eliminate one of the two table lookups, but would
c necessitate a test to determine if zz was between z1 and z2.
c
 1006 zz = 0.99 * z1 + 0.01 * z2
      call lookup (zz, x(indext), k1)
      call lookup (zz, xg(indexg), k2)
      k1 = k1 + indext - 1
      k2 = k2 + indexg - 1
      if (f(zz, x(k1), y(k1), x(k1 + 1), y(k1 + 1)).gt.
     +       f(zz, xg(k2), g(k2), xg(k2 + 1), g(k2 + 1))) go to 7
c
c if y is hidden between z1 and z2, update the maximum
c function.
c for generality, the maximum function is updated even if
c this is the (nfns)th curve.
c
      if (jj + igg - indexg.ge.maxdim) go to 700
      if (indexg.eq.igg) go to 712
      j1 = indexg + 1
      do 12 i=j1,igg
      jj = jj + 1
      xh(jj) = xg(i)
   12 h(jj) = g(i)
  712 jj = jj +1
      xh(jj) = z2
      h(jj) = f(z2, xg(igg), g(igg), xg(igg + 1), g(igg + 1))
      indexg = igg
      indext = itt
      go to 60
c
c if y is not hidden between z1 and z2, update the maximum
c function and plot.
c
    7 ngraph = itt - indext + 2
      if (jj + ngraph - 1.gt.maxdim) go to 700
      n2 = jj
      if (ngraph.eq.2) go to 9
      j1 = indext + 1
      do 11 i=j1,itt
      jj = jj + 1
      xh(jj) = x(i)
   11 h(jj) = y(i)
    9 jj = jj + 1
      xh(jj) = z2
      h(jj) = f(z2, x(itt), y(itt), x(itt + 1), y(itt + 1))
c
c call systems routine to produce line plot of
c (xh(i), h(i), i=n2, n2 + ngraph - 1).
c
      if(ifplot.eq.1) call pdatax(xh(n2),h(n2),ngraph,xstart,deltax,
     1                            sign*ymin,sign*deltay)
c
      indext = itt
      indexg = igg
   60 if (last.eq.1) go to 61
      x1 = x2
      f1 = f2
      z1 = z2
c
c after plotting and/or updating the maximum function on the
c interval (z1, z2), search for the next zero if the end of
c the abcissa table xt has not been reached.
c
      if (it.le.n1) go to 1100
      go to 1008
c
c after y vs x has been plotted, finish updating and store
c the new maximum function.
c allow for the possibility that the previous maximum
c function extends to the right of the function just
c plotted.
c
   61 if (xg(ng).le.xg(ng - 1)) ng = ng - 1
      if (xg(ng).le.x(n1)) go to 33
      if (jj + 3 + ng - igg.gt.maxdim) go to 700
      xh(jj + 1) = xh(jj) + eps
      jj = jj + 1
      h(jj) = f(x(n1), xg(igg), g(igg), xg(igg + 1), g(igg + 1))
      iggp1 = igg + 1
      do 34 j = iggp1, ng
      jj = jj + 1
      xh(jj) = xg(j)
   34 h(jj) = g(j)
   33 ng = jj + 2
      if (ng.gt.maxdim) go to 700
      do 13 i=1,jj
      g(i) = h(i)
   13 xg(i) = xh(i)
c
c the following precautionary step is used in place of a
c test in subroutine lookup to see if the value for which we
c want an index is outside the table.
c the last xg value will be set equal to the last abcissa
c of the next curve to be plotted.
c
      xg(jj + 1) = xg(jj) + eps
      g(jj + 1) = ymin + dykk
      if (sign.lt.0.) g(jj + 1) = -ymin - 50.0 * deltay + dykk
      g(ng) = g(jj + 1)
c
c restore arrays x and y before returning.
c
   66 if (nfns.lt.0) go to 53
      do 82 i=1,n1
      x(i) = x(i) + dxkk
   82 y(i) = sign * y(i) - dykk
   53 xg(ng) = sign
      return
c
c if statement 700 is reached, dimensions would have been
c exceeded.  see comments on calling sequence for hide.
c
  700 maxdim = -maxdim
      write(6,1030)
1030  format('visual maximum exceeds maxdim')
      go to 66
      end
      subroutine lookup (x, xtbl, j)
c
c this subroutine is called by hide to perform a table
c lookup.  because of precautions taken in hide, a test to
c see if x is outside the table is unnecessary.
c
      dimension xtbl(1)
      j = 2
    4 if (xtbl(j) - x) 1, 2, 3
    1 j = j + 1
      go to 4
    2 return
    3 j = j - 1
      return
      end
      subroutine pdatax(x,y,n,xm,dx,ym,dy)
c
c     purdue calcomp/dipl compatable data ploting routine
c
      dimension x(n),y(n)
      data cx,cy/2*0.0/
      px(i)=(x(i)-xm)/dx
      py(i)=(y(i)-ym)/dy
c
	i1 = 1
	i2 = 1
      if(amax1(abs(cx-px(1)),abs(cy-py(1))).lt.
     1   amax1(abs(cx-px(n)),abs(cy-py(n)))) goto 1
	i1 = n
	i2 = -i2
1     call plot(px(i1),py(i1),3)
      do 2 i3=2,n
      i1=i1+i2
2     call plot(px(i1),py(i1),2)
	cx = px(i1)
	cy = py(i1)
      return
      end


