/*
 * 
 * 	qplot - program to plot vectors
 * 
 *	The CRC graphics package
 *
 *	Carl Crawford
 *	Purdue University
 *	W. Lafayette, Indiana
 *	April 3, 1979
 *
 *      compile with "cc -O qplot.c -i -lG -lm"
 */

#include	<stdio.h>
#include	<math.h>

#define	MLAB 80		/* maximum axes label size */

#ifndef	pdp
#define	MAX_POINTS	3072
#else
#define	MAX_POINTS	512
#endif

#define	DevNum(Major,Minor)	((Major) + (Minor)*8)

#define	BIT	0	/* major device table */
#define GOV	1
#define IMAGE	2
#define	GGOV	3
#define	GIMAGE	4
#define	PLOT	5
#define	TEK	6
#define HP	7

#define	STDOUT		0	/* Special Device Numbers */
#define	VERSATEC	8
#define	PRINTRONIX	16
#define	RETRO		14
#define TEK4113		22

int	logx;		/* !=0 => x axis logrithmic */
int	logy;		/* !=0 => y axis logrithmic */
int	paxis	= 1;	/* 0=don't plot axis */
int     usey   = 1;     /* 1=use y file only */
float   scfac  = 1.0;   /* scale factor in plot */
char    *xf =   "x";    /* default x input file */
char    *yf =   "y";    /* default y input file */
char    *xyf =  "xybnd";/* default boundary file */
int	opsc;		/* 1= 'xyf' was openned */
int	dash;		/* 1= plot with dashed line */
float	xxs,yys;	/* starting locations for the graph */
int	spd = 36;	/* speed of hp plotter */
int	hist;		/* 1=use histogram mode */
int	savesc;		/* 1=save the generated scale file */
char	*xlp = NULL;	/* x axis label */
char	*ylp = NULL;	/* y axis label */
int	label;		/* 1=get labels from standard input */
char	xlab[MLAB];	/* buffer to hold x labels */
char	ylab[MLAB];	/* buffer to hold y labels */
char    *el;            /* end label */
char	*tl;		/* top label */
char	*bl;		/* bottom label */
char	*host;		/* host overide for all pipes */
float	height = 0.2;	/* character heights */
float	maxmin[4];	/* command string max,min values */
int	umxmn[4];	/* 1=corresponding maxmin value entered */
int     xbyte = 3;      /* default type for x vector */
int     ybyte = 5;      /* default type for y vector */
int     skip;           /* use every skip point in the vector */
long    begin;          /* start at vector point begin */
int     count = 512;    /* number of vector points to use */
int     pen   = 1;      /* hp pen color */
char    *stfl = "-";    /* default file for -p option */
float   xlen =  8.0;    /* length of x axis */
float   ylen =  8.0;    /* length of y axis */
int     frame;          /* 1=frame plot with border */
int	realx;		/* 1=real internal x vector */
int     xdigits = 6;    /* number of sig. digits for x axis */
int     ydigits = 6;    /* number of sig. digits for y axis */
int	online;		/* 1=use online symbols */
int     sym  =   4;     /* default online symbol */
int     jol  =  1;      /* default j for sline */
float   xtic =  1.0;    /* default x tic distance */
float   ytic =  1.0;    /* default y tic distance */
float   ds =    .1;     /* default dash length */
float   gp =    .1;     /* default gap length */
char    *siten = "pl";  /* default site for gplp */
int	blank;		/* blank flag */
int     devn;           /* minor device number */
int     dev = PRINTRONIX;/* major device number */
char	*devstr = 0;	/* dev= device string */
char	*plotstr = 0;	/* plot= device string */
char	*raxis = 0;	/* Use Real numbers to plot the named axis */
short	wasvalid = 0;	/* KLUDGE ALERT */

int     size[] = {
		sizeof(char),   /* signed char */
		sizeof(char),   /* unsigned char */
		sizeof(short),  /* short integer */
		sizeof(int),    /* integer */
		sizeof(long),   /* long integer */
		sizeof(float),  /* float */
		sizeof(double), /* double */
	};

#define INT     0
#define FLOAT   1
#define LONG    2
#define CHAR    3

struct hash  {
	char    *label;
	int     type;
	char    **pointer;
	} table[] = {
/* 1 */         {"x",CHAR,&xf},
/* 2 */         {"y",CHAR,&yf},
/* 3 */         {"s",CHAR,&xyf},
/* 4 */         {"g",CHAR,&stfl},
/* 5 */         {"xp",FLOAT,(char **)&xxs},
/* 6 */         {"yp",FLOAT,(char **)&yys},
/* 7 */         {"xl",CHAR,&xlp},
/* 8 */         {"yl",CHAR,&ylp},
/* 9 */         {"skip",INT,(char **)&skip},
/* 10 */        {"begin",LONG,(char **)&begin},
/* 11 */        {"xmin",FLOAT,(char **)&maxmin[0]},
/* 12 */        {"xmax",FLOAT,(char **)&maxmin[1]},
/* 13 */        {"ymin",FLOAT,(char **)&maxmin[2]},
/* 14 */        {"ymax",FLOAT,(char **)&maxmin[3]},
/* 15 */        {"count",INT,(char **)&count},
/* 16 */        {"pen",INT,(char **)&pen},
/* 17 */        {"scfac",FLOAT,(char **)&scfac},
/* 18 */        {"xlen",FLOAT,(char **)&xlen},
/* 19 */        {"ylen",FLOAT,(char **)&ylen},
/* 20 */        {"digits",INT,(char **)&xdigits},
/* 21 */        {"len",FLOAT,(char **)&xlen},
/* 22 */        {"el",CHAR,&el},
/* 23 */        {"sym",INT,(char **)&sym},
/* 24 */        {"j",INT,(char **)&jol},
/* 25 */        {"xdigits",INT,(char **)&xdigits},
/* 26 */        {"ydigits",INT,(char **)&ydigits},
/* 27 */        {"tic",FLOAT,(char **)&xtic},
/* 28 */        {"xtic",FLOAT,(char **)&xtic},
/* 29 */        {"ytic",FLOAT,(char **)&ytic},
/* 30 */        {"site",CHAR,&siten},
/* 31 */        {"dash",FLOAT,(char **)&ds},
/* 32 */        {"gap",FLOAT,(char **)&gp},
/* 33 */        {"dig",INT,(char **)&xdigits},
/* 34 */        {"xdig",INT,(char **)&xdigits},
/* 35 */        {"ydig",INT,(char **)&ydigits},
/* 36 */	{"speed",INT,(char **)&spd},
/* 37 */	{"tl",CHAR,&tl},
/* 38 */	{"bl",CHAR,&bl},
/* 39 */	{"logx",INT,(char **)&logx},
/* 40 */	{"logy",INT,(char **)&logy},
/* 41 */	{"op",CHAR,&host},
/* 42 */	{"dev",CHAR,&devstr},
/* 43 */	{"plot",CHAR,&plotstr},
/* 44 */	{"raxis",CHAR,&raxis},
		{0,0,0}
	};

struct	devtable {
	int	dev;
	char	*devstr;
	    } devtab[] = {
		{TEK4113,"4113"},
		{0,0}
	    };

main(argc,argv)
	int	argc;
	char	**argv;
{
	FILE    *fd;
	float   xd[MAX_POINTS+2],yd[MAX_POINTS+2];
	int	cx,cy;
	long	atol();
	float	max(),min();
	register int	i,j;
	float	dx,xtmp,ytmp,sftmp;
	char    buf[10];

	bzero(buf, sizeof(buf));
	gethostname(buf, sizeof(buf)-1);
	if(strcmp(buf,"arpa") == 0)
		dev = DevNum(GOV,0);
	file();
	args();
	parse(argc,argv);
	if(abs(logy) > 3 || abs(logx) > 3)err("illegal logy or logx value","");
	if(count > MAX_POINTS) 
		count = MAX_POINTS;
	if(begin < 0)begin *= (-count);
	cy = input(yf,ybyte,yd);
	if( !usey ){
		cx = input(xf,xbyte,xd);
		if(cx != cy)err("x and y vectors have different length","");
	}
	if( (fd = fopen(xyf,"r")) == NULL){
		scale(yd,cy);
		if( !usey ) scale(xd,cy);
	}else{
		fscanf(fd,"%f%f%f%f",xd+cy,xd+cy+1,yd+cy,yd+cy+1);
		fclose(fd);
		opsc = 1;
	}
	if(umxmn[0]){
		xd[cy] = maxmin[0];
	}else{
		if(opsc){
			umxmn[0] = 1;
			maxmin[0] = xd[cy];
		}
	}
	if(umxmn[1]){
		xd[cy+1] = maxmin[1];
	}else{
		if(opsc){
			umxmn[1] = 1;
			maxmin[1] = xd[cy+1];
		}
	}
	if(umxmn[2])yd[cy] = maxmin[2];
	if(umxmn[3])yd[cy+1] = maxmin[3];

	if(usey){
		if(umxmn[0] && umxmn[1]){
			dx = (maxmin[1] - maxmin[0])/(cy -1);
			xd[0] = maxmin[0];
			for(i=1;i<cy;i++)xd[i] = xd[i-1] + dx;
			if(realx)xbyte = 5;
		}else{
			if(umxmn[0]){
				for(i=0,j= -skip -1;i<cy;xd[i++] = maxmin[0] + (j += skip + 1));
				xd[cy] = maxmin[0];
				xd[cy+1] = xd[cy-1];
			}else{
				for(i=0,j= -skip -1;i<cy;xd[i++] = begin + (j += skip + 1));
				xd[cy] = begin;
				xd[cy+1] = xd[cy-1];
			}
		}
	}
	if(xbyte <= 4 && !(umxmn[0] && umxmn[1])){
		i = floor(xlen / xtic);
		xd[cy+1] = ceil((xd[cy+1] - xd[cy])/i)*i + xd[cy];
	}
	if(ybyte <= 4){
		i = floor(ylen / ytic);
		yd[cy+1] = ceil((yd[cy+1] - yd[cy])/i)*i + yd[cy];
	}
	if(label && paxis){
		if(xlp == NULL){
			getlab('x',xlab);
			xlp = xlab;
		}
		if(ylp == NULL){
			getlab('y',ylab);
			ylp = ylab;
		}
	}
	/* Added to keep from dereferencing a NULL pointer later. --kcd */
	if(xlp == NULL){
		xlab[0] = '\0';
		xlp = xlab;
	}
	if(ylp == NULL){
		ylab[0] = '\0';
		ylp = ylab;
	}
	if(savesc){
		if((fd=fopen(xyf,"w")) == NULL)err("can't create: ",xyf);
		fprintf(fd,"%e %e %e %e\n",xd[cy],xd[cy+1],yd[cy],yd[cy+1]);
		fclose(fd);
	}

	if (logx < 0) {
		for (i=0; i <= cy+1; i++){
			if(xd[i] <= 0)err("data value <= 0 in x vector","");
			xd[i] = log10( (double) xd[i]);
		}
		xd[cy] = floor( (double) xd[cy]);
		xd[cy+1] = ceil( (double) xd[cy+1]);
		logx = -logx;
	}
	if (logy < 0) {
		for (i=0; i <= cy+1; i++){
			if(yd[i] <= 0)err("data value <= 0 in y vector","");
			yd[i] = log10( (double) yd[i]);
		}
		yd[cy] = floor( (double) yd[cy]);
		yd[cy+1] = ceil( (double) yd[cy+1]);
		logy = -logy;
	}

	for(i=0;i<cy;i++) {
		if (yd[i] != max(min(yd[i],yd[cy+1]),yd[cy])) {
			if (wasvalid) {
				wasvalid = 0;
				if (yd[i] < yd[cy]) 
					xd[i]=xd[i-1]+
					      ((yd[cy]-yd[i-1])*(xd[i]-xd[i-1]))
					      / (yd[i]-yd[i-1]);
				else 
					xd[i]=xd[i-1]+
					      ((yd[cy+1]-yd[i-1])*(xd[i]-xd[i-1]))
					      / (yd[i]-yd[i-1]);
			} 
			yd[i] = max(min(yd[i],yd[cy+1]),yd[cy]); 
		} else 
			wasvalid = 1;
	}

	if(dev == DevNum(GOV,0) || dev == DevNum(IMAGE,0) ||
		dev == DevNum(GGOV,0) || dev == DevNum(GIMAGE,0)){
		if(devn){
			devn -= '0';
			if(dev == DevNum(IMAGE,0) || dev == DevNum(GIMAGE,0))
				devn += 1;
		}
		dev |= devn << 3;
	}
	strcpy(buf,"-");
	strcat(buf,siten);
	site(buf);
	fname(stfl);
	if(host || (dev == PLOT && plotstr))
		dev |= 0100;
	if (host)
		plots(dev,blank,host);
	else if (dev == 0100 | PLOT)
		plots(dev,blank,plotstr);
	else
		plots(dev,blank,NULL);
	newpen(pen);
	speed(spd);
	plot(xxs,yys,-3);
	factor(scfac);
	if(paxis){
		int	FloatX, FloatY;

		FloatX = (raxis && index(raxis,'x')) || (xbyte > 4);
		FloatY = (raxis && index(raxis,'y')) || (ybyte > 4);

		axisv(xtic,xdigits);
		if (logx)
			laxis(1.5,1.5,xlp,0,xlen, (int) xd[cy], (int) xd[cy+1],logx);
		else
			axis(1.5,1.5,xlp,0,xlen,xd[cy],xd[cy+1],!FloatX);
		axisv(ytic,ydigits);
		if (logy)
			laxis(1.5,1.5,ylp,1,ylen, (int) yd[cy], (int) yd[cy+1],logy);
		else
			axis(1.5,1.5,ylp,1,ylen,yd[cy],yd[cy+1],!FloatY);
	}
	plot(1.5,1.5,-3);
	if(frame && paxis){
		plot(0.0,ylen,3);
		plot(xlen,ylen,2);
		plot(xlen,0.0,2);
	}
	else if (frame) {
		plot(0.0,0.0,3);
		plot(0.0,ylen,2);
		plot(xlen,ylen,2);
		plot(xlen,0.0,2);
		plot(0.0,0.0,2);
	}
	if( !dash ){
		if(online){
			sline(xd,yd,cy,xlen,ylen,jol,sym);
		}else{
			line(xd,yd,cy,hist,xlen,ylen);
		}
	}else{
		dline(xd,yd,cy,&ds,&gp,1,xlen,ylen);
	}
	if(el){        /* end label */
		where(&xtmp,&ytmp,&sftmp);
		symbol((xtmp+.1)/sftmp,(ytmp-.1)/sftmp,height,el,0.0);
	}
	if(tl){		/* top label */
		symbol(xlen*0.5-(3./7.*_ssize(tl)*height),ylen+height*0.5,height,tl,0.0);
	}
	if(bl){		/* bottom label */
		symbol(xlen*0.5-(3./7.*_ssize(bl)*height),-1.1,height,bl,0.0);
	}
	plot(0.0,0.0,999);
	exit(0);
}


float	max(x,y)
	float	x,y;
{
	return( (x > y)? x : y);
}

float	min(x,y)
	float	x,y;
{
	return( (x < y)? x : y);
}

input(name,n,vec)
	char	*name;
	int	n;
	float	*vec;
{
	register int    i,ns;
	FILE    *fd;
	char    buf[sizeof(double)];
#ifdef sel
	double  vec2;
#endif

	if( (fd = fopen(name,"r")) == NULL){
		fprintf(stderr,"can't open: %s\n",name);
		exit(1);
	}
	if (n == 7){
		int	j;
		float	x;

		i = begin;
		while ( i-- > 0 && fscanf(fd,"%f",&x) > 0);
		i = 0;
		while (i < count && fscanf(fd,"%f",&x) > 0){
			*vec++ = x;
			i++;
			for (j=0;j<skip && fscanf(fd,"%f",&x) > 0;j++);
		}
	}
	else {
		i = 0;
		ns = size[n];
		fseek(fd,(long)(begin * ns),0);
		while((i<count) && (fread(buf,ns,1,fd) != 0)){
			switch(n){

			case 0: /* signed char */
				*vec++ = *((char *)buf);
				break;
			case 1: /* unsigned char */
				*vec++ = *((char *)buf) & 0377;
				break;
			case 2: /* short */
				*vec++ = *((short *)buf);
				break;
			case 3: /* int */
				*vec++ = *((int *)buf);
				break;
			case 4: /* long */
				*vec++ = *((long *)buf);
				break;
			case 5: /* float */
				*vec++ = *((float *)buf);
				break;
			case 6: /* double */
#ifdef sel
				bcopy(buf,(char *)&vec2,sizeof(double));
				*vec++ = vec2;
#else
				*vec++ = *((double *)buf);
#endif
				break;
			}
			i++;
			fseek(fd,(long)(skip*ns),1);
		}
	}
	fclose(fd);
	if(i == 0){
		fprintf(stderr,"no points read from input file\n");
		exit(1);
	}
	return(i);
}


nbyte(s,n)
	char	*s;
	int	*n;
{
	while(*s)if(*s == ',' && *(s+1)){
		*s++ = 0;
		switch(*s){

		case 'b':       /* char data */
		case 'c':
		case '1':
			if(*++s == 's')*n = 0;
			else *n = 1;
			return;
		case 's':       /* short */
		case '2':
			*n = 2;
			return;
		case 'i':       /* integer */
			*n = 3;
			return;
		case 'l':       /* long */
			*n = 4;
			return;
		case 'f':       /* float */
		case '4':
			*n = 5;
			return;
		case 'd':       /* double */
		case '8':
			*n = 6;
			return;
		case 'a':	/* ASCII */
			*n = 7;
			return;
		default:
			err("byte declaration error","");
		}
	}else{
		s++;
	}
}

err(s1,s2)
	char	*s1,*s2;
{
	fprintf(stderr,"%s%s\n",s1,s2);
	exit(1);
}

comm(s)
	char	*s;
{
	register	int	j,r;
	char    *p;
	struct hash *hp;


	for(hp=table;hp->label;hp++){
		for(j=0;(r=hp->label[j]) == s[j] && r;j++);
		if(r == 0 && s[j] == '=')
			if(!s[j+1]){
				s[j] = 0;
				err("empty string: ",s);
			}else{
				switch(hp->type){

				case CHAR:
					*hp->pointer = s + j + 1;
					break;
				case INT:
					*((int *)hp->pointer) = atoi(s+j+1);
					break;
				case FLOAT:
					*((float *)hp->pointer) = atof(s+j+1);
					break;
				case LONG:
					*((long *)hp->pointer) = atol(s+j+1);
					break;
				}
				return(hp - table + 1);
			}
	}
	p = s;
	while(*p){
		if(*p == '='){
			*p = 0;
			break;
		}
		p++;
	}
	err("bad option: ",s);
}


parse(argc,argv)
	int	argc;
	char	**argv;
{
	char    c;
	int     i;

	while(argv++ , --argc){
		if(argv[0][0] == '-')while(c = *++*argv)switch(c){

			case '0':	/* device # */
			case '1':
			case '2':
			case '3':       /* grinell */
			case '4':
				devn = c;
				break;
			case 'G':
				if (dev == IMAGE || dev == GIMAGE)
					dev = GIMAGE;
				else
					dev = GGOV;
				break;
			case 'a':	/* don't plot axis */
				paxis = 0;
				break;
			case 'A':	/* plot axis */
				paxis = 1;
				break;
			case 'g':	/* use graphics overlay */
				if (dev == GGOV || dev == GIMAGE)
					dev = GGOV;
				else
					dev = GOV;
				break;
			case 'i':	/* use Image Plane */
				if (dev == GGOV || dev == GIMAGE)
					dev = GIMAGE;
				else
					dev = IMAGE;
				break;
			case 'c':	/* use comtal */
				if (dev == GIMAGE || dev == IMAGE)
					dev = IMAGE;
				else
					dev = GOV;
				break;
			case 's':	/* store xy bnd file */
				savesc = 1;
				break;
			case 'S':	/* don't store xy bnd file */
				savesc = 0;
				break;
			case 'x':	/* use x and y file  */
				usey = 0;
				break;
			case 'X':	/* don't use x and y file  */
				usey = 1;
				break;
			case 'd':	/* use dash line */
				dash = 1;
				break;
			case 'D':	/* don't use dash line */
				dash = 0;
				break;
			case 'b':	/* don't blank display */
				blank = 1;
				break;
			case 'B':	/* blank display */
				blank = 0;
				break;
			case 'z':	/*use histogram mode */
				hist = 1;
				break;
			case 'Z':	/* don't use histogram mode */
				hist = 0;
				break;
			case 't':	/* use tektronix */
				dev = TEK;
				break;
			case 'T':	/* use Retro-graphics */
				dev = RETRO;
				break;
			case 'h':	/* use hp plotter */
				dev = HP;
				break;
			case 'f':       /* frame plot */
				frame = 1;
				break;
			case 'F':       /* don't frame plot */
				frame = 0;
				break;
			case 'o':       /* g=stdout */
				dev = STDOUT;
				stfl = "-";
				break;
			case 'r':	/* real x generated vector */
				realx = 1;
				break;
			case 'R':	/* integer x generated vector */
				realx = 0;
				break;
			case 'm':	/* use on line symbols */
				online = 1;
				break;
			case 'M':	/* don't use on line symbols */
				online = 0;
				break;
			case 'v':       /* direct versatec mode */
				dev = VERSATEC;
				break;
			case 'P':	/* Plot Subroutines */
				dev = PLOT;
				break;
			case 'p':       /* direct line printer mode */
				dev = PRINTRONIX;
				break;
			case 'l':	/* get labels from standard input */
				label = 1;
				break;
			case 'L':	/* don't get labels */
				label = 0;
				break;
			default:
				fprintf(stderr,"bad flag: -%c\n",c);
				exit(1);
			}
		else
			switch(i = comm(*argv)){

			case 1:	/* x input file name */
				if(*xf == ',')xf = "x";
				nbyte(*argv+2,&xbyte);
				usey = 0;
				break;
			case 2:	/* y input file name */
				if(*yf == ',')yf = "y";
				nbyte(*argv + 2,&ybyte);
				break;
			case 4:	/* output file name */
				dev = STDOUT;
		 		break;
			case 11:	/* set max or min value */
			case 12:
			case 13:
			case 14:
				umxmn[i-11] = 1;
				break;
			case 36:	/* speed */
				dev = HP;
				break;
			case 20:        /* digits for axes */
			case 33:
				ydigits = xdigits;
				break;
			case 21:	/* x and y axis length */
				ylen = xlen;
				break;
			case 23:	/* sym */
			case 24:	/* j for online symbol */
				online = 1;
				break;
			case 27:	/* tic */
				ytic = xtic;
				break;
			case 30:        /* site */
				dev = PRINTRONIX;
				break;
			case 31:        /* dash */
			case 32:        /* gap */
				dash = 1;
				break;
			case 42:	/* Look up device name in dev table */
				{ struct devtable *tp;
				for(tp=devtab; tp->devstr; tp++)
					if(strcmp(tp->devstr,devstr) == 0)
						break;
				if(tp->devstr)
					dev = tp->dev;
				else
					err("Unknown device ",devstr);
				}
				break;
			case 43:
				dev = PLOT;
				break;
				
			}
	}
}

args()
{
	char	*argv[20];
	int	argc;
	char	*s,*getenv(),*p;

	if((s=getenv("QPLOTARGS")) == NULL)return;

	argv[0] = s;
	argc = 1;
	while(*s){
		while(*s == ' ')*s++ = 0;
		if(*s){
			if(*s != '"')argv[argc++] = s;
			else{
				argv[argc++] = ++s;
				while(*s){
					if(*s != '"')s++;
					else{
						*s++ = 0;
						break;
					}
				}
			}
		}
		while( (*s != ' ')  && *s){
			if(*s != '"')s++;
			else{
				p = s;
				while(*p){
					*p = *(p+1);
					p++;
				}
				while(*s){
					if(*s != '"')s++;
					else{
						*s++ = 0;
						break;
					}
				}
			}
		}
	}
	parse(argc,argv);
}

file()
{
	int	argc;
	char	*argv[20];
	static char buf[256];
	char	*b;
	char	*getenv(),*s;
	FILE	*dfd;

	if((s = getenv("HOME")) == NULL)return;
	strcpy(buf,s);
	strcat(buf,"/.qplotrc");
	if((dfd = fopen(buf,"r")) == NULL)return;
	argc = 1;
	b = buf;
	while(fgets(b,256-((int)(b - buf)),dfd) != NULL){
		b[strlen(b)-1] = 0;
		argv[argc++] = b;
		b += strlen(b)+1;
		if(argc == 20)break;
	}
	parse(argc,argv);
	fclose(dfd);
}

getlab(c,s)
	char	c,*s;
{
	printf("enter %c axis label: ",c);
	fgets(s,MLAB,stdin);
	if(s[strlen(s)-1] == '\n')s[strlen(s)-1] = 0;
}
