/*

  	plot3d - program to plot three dimensional surfaces
  
	The CRC graphics package

	Malcolm Slaney
	April 12, 1982

	Hacked heavily from qplot code by
		Carl Crawford
		Purdue University
		W. Lafayette, Indiana
		April 3, 1979
  

	MODIFICATIONS:
		Changed parameter code so that xcount and ycount default
		to (size-begin+1)/(skip+1)...................Malcolm 8/25/82

		Added Ascii Input format.....................Malcolm 11/30/82

		Changed device mappings......................Malcolm 10/22/83

		Added several more options and arguments when truplt was 
		modified and named newtru. Newtru will now draw the function
		below(phi2>0) or above(phi2<0) the horizon if the x-y axes 
		are not drawn. For more details see newtru.f. 
		The new arguments are :
		xdig, ydig, zdig, dig, xl, yl, zl, xlen, ylen, zlen, len, 
		xtic, ytic, ztic, tic, zmin, direction(=[xy]), 
		resolution(0.7< >4.0).
		The new flags are -l and -z.
		Specifying dir=y would do the job of -k flag, so later on -k
		should be removed. Resolution is added to get a better 
		resolution in line hiding.
								Mani 12/7/83

		xmin, xmax, ymin, ymax and raxis parameters have been added 
		to the list of parameters. raxis=[xy] would specify whether
		the the values for x and y axes be converted to float or not. 
								Mani 3/29/84

		z has been added to the list of options for raxis=[xyz]. 
								Mani 4/10/84
*/

#include	<stdio.h>
#include	<math.h>

#define	MLAB 80		/* maximum axes label size */
#define LARGE 1.0e31	/* large number used as a flag for not setting a var. */
#define XYSIZE 514	/* array size for x and y */

#define	DevNum(Major,Minor)	((Major) + (Minor)*8)

#define	BIT	0	/* major device table */
#define GOV	1
#define IMAGE	2
#define	GGOV	3
#define	GIMAGE	4
#define	PLOT	5
#define	TEK	6
#define HP	7

#define	STDOUT		0	/* Special Device Numbers */
#define	VERSATEC	8
#define	PRINTRONIX	16
#define	RETRO		14
#define	TEK4113		22

int	logx;		/* !=0 => x axis logrithmic */

int	logx;		/* !=0 => x axis logrithmic */
int	logy;		/* !=0 => y axis logrithmic */
long	prnt	= 0;	/* FOR DEBUGGING	*/
long	pxaxis	= 1;	/* 1=plot the x axis
			   0=don't plot the x axis*/
long	pyaxis	= 1;	/* 1=plot the y axis
			   0=don't plot the y axis*/
long	pzaxis	= 1;	/* 1=plot the z-axis,
			   0=don't plot the z-axis */
int     use[2] = {0,0}; /* 1=use x or y file */
int	reverse = 0;	/* Reverse Z direction in plot */
float   scfac  = 1.0;   /* scale factor in plot */
char    *xyf[2] = {"x","y"};    
			/* default x and y input file */
char	*zf =	"z";	/* Default z input file */
char    *xyzf ="xyzbnd";/* default boundary file */
int	opsc = 0;	/* 1= "xyzbnd" has been opened */
int	dash;		/* 1= plot with dashed line */
float	xxs,yys;	/* starting locations for the graph */
int	spd = 36;	/* speed of hp plotter */
int	savesc;		/* 1=save the generated scale file */
char	*xlp = NULL;	/* x axis label */
char	*ylp = NULL;	/* y axis label */
char	*zlp = NULL;	/* z axis label */
long	prmpt=0;	/* 1=prompt for labels from standard input */
char	xlab[MLAB];	/* buffer to hold x labels */
char	ylab[MLAB];	/* buffer to hold y labels */
char	zlab[MLAB];	/* buffer to hold z labels */
char    *el;            /* end label */
char	*tl = NULL;	/* top label */
char	*bl = NULL;	/* bottom label */
char	*host;		/* host overide for all pipes */
char	*plotstr;	/* plot device overide for all pipes */
char	*devstr;	/* device overide name */
float	height = 0.2;	/* character heights */
float	maxmin[6];	/* command string max,min values */
int	umxmn[6]= {0,0,0,0,0,0};	
			/* 1=corresponding maxmin value entered */
int     real[3] = {0,0,0};/* 1=x, y or z axes becomes float */
int	byte[3] = {3,3,5};
			/* default type for x, y and z vectors */
int	begin[2] ={0,0};/* Starting X and Y coord of interest */
int	skip[2] ={0,0};	/* Number of points in x and y to skip */
int	xysize[2] ={64,64};	
			/* Number of points in matrix for x and y indices */
int     count[3] ={0,0,0};
			/* number of vector points in x and y direction to use*/
int     pen   = 1;      /* hp pen color */
char    *stfl = "-";    /* default file for -p option */
float   len[3] = {8.0,8.0,8.0};    
			/* length of x, y and z axes */
int     frame;          /* 1=frame plot with border */
int     dig[3] ={6,6,6};/* number of sig. digits for x, y and z axes */
int	online;		/* 1=use online symbols */
int     sym  =   4;     /* default online symbol */
int     jol  =  1;      /* default j for sline */
float   tic[3] = {1.0,1.0,1.0};    
			/* default x, y and z tic distances */
float   ds =    .1;     /* default dash length */
float   gp =    .1;     /* default gap length */
char    *siten = "pl";  /* default site for gplp */
int	blank;		/* blank flag */
int     devn;           /* minor device number */
int     dev = PRINTRONIX;/* major device number */
long	ydir = 1;	/* Print y lines (crosshatch) */
long	xdir = 0;	/* Print x lines (crosshatch) */
float	phi1 = 40.0;	/* Orientation of x-y plane */;
float	phi2 = 30.0;	/* Tilt of plane */
float	base = LARGE;	/* Z Location of xy plane in plot, default is zmax */
float	resol = 1.0;	/* Resol*1700 horiz. steps is used for line hiding */ 
char    *dirn = "y";	/* Default direction for line drawings */
char    *axisn = "xyz";	/* Default for axes drawings */
char    *raxis = NULL;	/* Default direction for line drawings */

int     size[] = {
		sizeof(char),   /* signed char */
		sizeof(char),   /* unsigned char */
		sizeof(short),  /* short integer */
		sizeof(int),    /* integer */
		sizeof(long),   /* long integer */
		sizeof(float),  /* float */
		sizeof(double), /* double */
	};

#define INT     0
#define FLOAT   1
#define LONG    2
#define CHAR    3

struct hash  {
	char    *label;
	int     type;
	char    **pointer;
	} table[] = {
/* 1 */         {"x",CHAR,&xyf[0]},
/* 2 */         {"y",CHAR,&xyf[1]},
/* 3 */         {"z",CHAR,&zf},
/* 4 */         {"s",CHAR,&xyzf},
/* 5 */         {"g",CHAR,&stfl},
/* 6 */         {"xp",FLOAT,(char **)&xxs},
/* 7 */         {"yp",FLOAT,(char **)&yys},
/* 8 */         {"xl",CHAR,&xlp},
/* 9 */         {"yl",CHAR,&ylp},
/* 10 */        {"zl",CHAR,&zlp},
/* 11 */        {"begin",LONG,(char **)&begin[0]},
/* 12 */        {"xmin",FLOAT,(char **)&maxmin[0]},
/* 13 */        {"xmax",FLOAT,(char **)&maxmin[1]},
/* 14 */        {"ymin",FLOAT,(char **)&maxmin[2]},
/* 15 */        {"ymax",FLOAT,(char **)&maxmin[3]},
/* 16 */        {"zmin",FLOAT,(char **)&maxmin[4]},
/* 17 */        {"zmax",FLOAT,(char **)&maxmin[5]},
/* 18 */        {"xcount",INT,(char **)&count[0]},
/* 19 */        {"ycount",INT,(char **)&count[1]},
/* 20 */        {"pen",INT,(char **)&pen},
/* 21 */        {"scfac",FLOAT,(char **)&scfac},
/* 22 */        {"xlen",FLOAT,(char **)&len[0]},
/* 23 */        {"ylen",FLOAT,(char **)&len[1]},
/* 24 */        {"zlen",FLOAT,(char **)&len[2]},
/* 25 */        {"site",CHAR,&siten},
/* 26 */	{"speed",INT,(char **)&spd},
/* 27 */	{"tl",CHAR,&tl},
/* 28 */	{"bl",CHAR,&bl},
/* 29 */	{"op",CHAR,&host},
/* 30 */	{"phi1",FLOAT,(char **)&phi1},
/* 31 */	{"phi2",FLOAT,(char **)&phi2},
/* 32 */	{"base",FLOAT,(char **)&base},
/* 33 */	{"len",FLOAT,(char **)&len[0]},
/* 34 */	{"n",INT,(char **)&xysize[0]},
/* 35 */	{"count",INT,(char **)&count[0]},
/* 36 */	{"xbegin",LONG,(char **)&begin[0]},
/* 37 */	{"ybegin",LONG,(char **)&begin[1]},
/* 38 */	{"skip",LONG,(char **)&skip[0]},
/* 39 */	{"xskip",LONG,(char **)&skip[0]},
/* 40 */	{"yskip",LONG,(char **)&skip[1]},
/* 41 */	{"size",LONG,(char **)&xysize[0]},
/* 42 */	{"xsize",LONG,(char **)&xysize[0]},
/* 43 */	{"ysize",LONG,(char **)&xysize[1]},
/* 44 */        {"dig",INT,(char **)&dig[0]},
/* 45 */        {"xdig",INT,(char **)&dig[0]},
/* 46 */        {"ydig",INT,(char **)&dig[1]},
/* 47 */        {"zdig",INT,(char **)&dig[2]},
/* 48 */        {"tic",FLOAT,(char **)&tic[0]},
/* 49 */        {"xtic",FLOAT,(char **)&tic[0]},
/* 50 */        {"ytic",FLOAT,(char **)&tic[1]},
/* 51 */        {"ztic",FLOAT,(char **)&tic[2]},
/* 52 */        {"res",FLOAT,(char **)&resol},
/* 53 */        {"resolution",FLOAT,(char **)&resol},
/* 54 */        {"dir",CHAR,&dirn},
/* 55 */        {"direct",CHAR,&dirn},
/* 56 */        {"direction",CHAR,&dirn},
/* 57 */	{"dev",CHAR,&devstr},
/* 58 */	{"plot",CHAR,&plotstr},
/* 59 */	{"zaxis",FLOAT,(char **)&base},	/*should be removed later on*/
/* 60 */	{"raxis",CHAR,&raxis},	
/* 61 */        {"axis",CHAR,&axisn},
		{0,0,0}
	};

struct	devtable {
	int	dev;
	char	*devstr;
	    } devtab[] = {
		{TEK4113,"4113"},
		{0,0}
	    };


main(argc,argv)
	int	argc;
	char	**argv;
{
	FILE    *fd;
	float   xyd[2*XYSIZE],dum1,dum2;
	float	*zd;
	long	atol();
	float	max(),min();
	register int	i,j,k;
	int	idum,iflag,ky,incr;
	float	fdum,dxy,zmin,zmax,tmp;
	char    buf[10];
	char	*getenv();

	long	n, n1, nxx, nyy, nxdim;

	if((fd = fopen("/etc/cpu","r")) != NULL){
		fgets(buf,10,fd);
		buf[strlen(buf) -1] = 0;
		if(strcmp(buf,"arpa") == 0)
			dev = DevNum(GOV,0);
		fclose(fd);
	}
	file();
	args();
	parse(argc,argv);

	if( strcmp(axisn,"xyz") != 0){
		pxaxis = 0;
		pyaxis = 0;
		pzaxis = 0;
		for( i=0 ; *(axisn+i) != NULL ; i++ ){
			if( *(axisn+i) == 'x' ){
				pxaxis = 1;
			}else if( *(axisn+i) == 'y' ){
				pyaxis = 1;
			}else if( *(axisn+i) == 'z' ){
				pzaxis = 1;
			}else{
				fprintf(stderr,"bad argument in axis=%s\n"
					,axisn);
				exit(1);
			}
		}
	}
		
	if(strcmp(dirn,"x") == 0){
		xdir = 1;
		ydir = 0;
	}else if(strcmp(dirn,"y") == 0){
		xdir = 0;
		ydir = 1;
	}else if( (strcmp(dirn,"xy") == 0) || (strcmp(dirn,"yx") == 0) ){
		xdir = 1;
		ydir = 1;
	}else{
		fprintf(stderr,"bad argument in dir=");
		exit(1);
	}

	if( raxis != NULL ) {
		for( i=0 ; *(raxis+i) != NULL ; i++ ){
			if( *(raxis+i) == 'x' ){
				real[0] = 1;
			}else if( *(raxis+i) == 'y' ){
				real[1] = 1;
			}else if( *(raxis+i) == 'z' ){
				real[2] = 1;
			}else{
				fprintf(stderr,"bad argument in raxis=");
				exit(1);
			}
		}
	}

	if( resol > 4.0 )
		resol = 4.0;
	else if ( resol < 0.7 )
		resol = 0.7;

	if(count[0] > 512 || count[1] > 512){
		fprintf(stderr,"count[0] and count[1] must be less than 512.\n");
		exit(1);
	}
					/*
					 *  Set the defaults.......
					 *  user must set size parameters
					 *  the count variables are set based
					 *  on the values of size, begin and
					 *  skip......Malcolm...8/25/82
					 */
	for(k=0;k<2;k++){
		if (count[k] == 0)
		    count[k] = (xysize[k]-begin[k])/(double)(skip[k]+1)+.999999;
	}

	zd = (float *)calloc(count[0]*count[1],sizeof(float));
	if (!zd){
		fprintf(stderr,"Can't allocate space for data.\n");
		exit(3);
	}

					/* show they are not set */
	if (!umxmn[4])				
		maxmin[4] = -LARGE;
	if (!umxmn[5])			
		maxmin[5] = LARGE;				

	count[2] = matrixinput(zf,byte[2],zd);
	if( real[2] ){
		byte[2] = 5;
	}else if( byte[2] != 3 ){
		byte[2] = 5;
	}
	if (count[2] != count[0]*count[1]){
		fprintf(stderr,"Only read %d of %d points in z file.\n",
			count[2], count[0]*count[1]);
		exit(2);
	}

	zmin   = *zd;
	zmax   = zmin;
	for(i=0;i<count[2];i++){ 
		fdum	= *(zd+i);
		if( fdum < zmin ){
			zmin = fdum;
		}else if ( fdum > zmax){ 
			zmax = fdum;
		}
		if( umxmn[4] && (fdum < maxmin[4]) ) *(zd+i) = maxmin[4];
		if( umxmn[5] && (fdum > maxmin[5]) ) *(zd+i) = maxmin[5];
	}
	if( !umxmn[4] && !umxmn[5] && (zmax == zmin) ){
		fprintf(stderr,"z is constant and no zmin or zmax are set");
		exit(1);
	}
	if( !umxmn[4] ) maxmin[4] = zmin;
	if( !umxmn[5] ) maxmin[5] = zmax;

	for(k=0;k<2;k++){
		ky = k * XYSIZE;
		if( use[k] ){
			idum = input(xyf[k],byte[k],xyd+ky,
					count[k],begin[k],skip[k]);
			if(idum != count[k]){
			  fprintf(stderr,"Only read %d of %d points in %s file.\n",idum,count[k],xyf[k]);
			  exit(1);
			}
		}
		if( real[k] ){
			byte[k] = 5;
		}else if( byte[k] != 5 && byte[k] != 6 ){
			byte[k] = 3;
		}
/*			
		if( xyd[ky] > xyd[ky+count[k]] ){
			for( i=0 ; i<(count[k]+1)/2 ; i++ ){
				if( k == 0 ){
					incr	= 1;
				}else{
					incr	= count[0];
				}
				for( j=0 ; j<count[(k+1)%2] ; j+=incr ){
				    idum		= (count[k]-i-1)*incr;
				    tmp			= *(zd+i*incr+j);
				    *(zd+i*incr+j)	= *(zd+idum+j);
				    *(zd+idum+j)	= tmp;
				}
				tmp			= xyd[i];
				xyd[i]			= xyd[count[k]-i-1];
				xyd[count[k]-i-1]	= tmp;
			}
		}
									*/
	}
	if( (fd = fopen(xyzf,"r")) == NULL){
		if( use[0] ) scale(xyd,count[0]);
		if( use[1] ) scale(xyd+XYSIZE,count[1]);
	}else{
		fscanf(fd,"%f %f %f %f %f %f",xyd+count[0],xyd+count[0]+1,xyd+XYSIZE+count[1],xyd+XYSIZE+count[1]+1,&dum1,&dum2);
		fclose(fd);
		opsc = 1;
		if( !umxmn[4] ){
			maxmin[4] = dum1;
			umxmn[4] = 1;
		}
		if( !umxmn[5] ){
			maxmin[5] = dum2;
			umxmn[5] = 1;
		}
	}

	for(k=0;k<2;k++){
		ky = k * XYSIZE;
		for(i=0;i<2;i++){
			if( umxmn[k*2+i] )
				xyd[ky+count[k]+i] = maxmin[k*2+i];
			else if( opsc ){
				umxmn[k*2+i] = 1;
				maxmin[k*2+i] = xyd[ky+count[k]+i];
			}
		}
	}
			
	for(k=0;k<2;k++){
		ky = k * XYSIZE;
		if( !use[k] ){
			if( umxmn[k*2] && umxmn[k*2+1] ){
				dxy = (maxmin[k*2+1]-maxmin[k*2])/(count[k]-1);
				xyd[ky] = maxmin[k*2];
				for(i=1;i<count[k];i++) 
					xyd[ky+i] = xyd[ky+i-1] + dxy;
				xyd[ky+count[k]] = maxmin[k*2];
				xyd[ky+count[k]+1] = xyd[ky+count[k]-1];
			}else if( umxmn[k*2] ){
				for(i=0,j=maxmin[k*2];i<count[k];i++,j+=skip[k]+1)
					xyd[ky+i] = j;
				xyd[ky+count[k]] = maxmin[k*2];
				xyd[ky+count[k]+1] = xyd[ky+count[k]-1];
			}else{
				for(i=0,j=begin[k];i<count[k];i++,j+=skip[k]+1)
					xyd[ky+i] = j;
				xyd[ky+count[k]] = begin[k];
				xyd[ky+count[k]+1] = xyd[ky+count[k]-1];
			}
		}
	}
/*
	for(k=0;k<2;k++){
		ky = k * XYSIZE;
		if(byte[k] <= 4 && !(umxmn[k*2] && umxmn[k*2+1])){
			i = floor(len[k] / tic[k]);
			xyd[ky+count[k]+1] = ceil( (xyd[ky+count[k]+1]
				- xyd[ky+count[k]])/i ) * i + xyd[ky+count[k]];
		}
	}
								*/
	if(savesc){
		if((fd=fopen(xyzf,"w")) == NULL)err("can't create: ",xyzf);
		fprintf(fd,"%e %e %e %e %e %e \n",xyd[count[0]],
		xyd[count[0]+1],xyd[XYSIZE+count[0]],xyd[XYSIZE+count[0]+1],
		maxmin[4],maxmin[5]);
		fclose(fd);
	}

	iflag = 0;
	for(k=0;k<2;k++){
		ky = k * XYSIZE;
		idum = ky + count[k];
		if( xyd[ky] < xyd[idum-1] ){
		  if( ( umxmn[k*2] && ( xyd[ky] < xyd[idum] ) ) || 
			( umxmn[k*2+1] && ( xyd[idum-1] > xyd[idum+1] ) ) ){
			fprintf(stderr,"1: plot extends beyond the axes\n");
			iflag = 1;
		  }
		}else if( xyd[ky] > xyd[idum-1] ){
		  if( (umxmn[k*2+1] && ( xyd[ky] > xyd[idum+1] ) ) ||					( umxmn[k*2] && ( xyd[idum-1] < xyd[idum] ) ) ){
			fprintf(stderr,"2: plot extends beyond the axes\n");
			iflag = 1;
	          }
		}
	}
	if( iflag ) exit(1);

#ifdef sel
	if (xlp != NULL) strcpy(&xlab,xlp);
	if (ylp != NULL) strcpy(&ylab,ylp);
	if (zlp != NULL) strcpy(&zlab,zlp);
	xlp = xlab;
	ylp = ylab;
	zlp = zlab;

	if( (pxaxis) && *xlp == NULL && (prmpt) ){
		getlab('x',xlab);
		xlp = xlab;
	}
	if( (pyaxis) && *ylp == NULL && (prmpt) ){
		getlab('y',ylab);
		ylp = ylab;
	}
	if( (pzaxis) && *zlp == NULL && (prmpt)){
		getlab('z',zlab);
		zlp = zlab;
	}
#else
	if( (pxaxis) && xlp == NULL && (prmpt) ){
		getlab('x',xlab);
		xlp = xlab;
	}
	if( (pyaxis) && ylp == NULL && (prmpt) ){
		getlab('y',ylab);
		ylp = ylab;
	}
	if( (pzaxis) && zlp == NULL && (prmpt)){
		getlab('z',zlab);
		zlp = zlab;
	}
	/* Added to keep from dereferencing a NULL pointer later. --kcd */
	if(tl == NULL){
		tl = "";
	}
	if(bl == NULL){
		bl = "";
	}
	if(xlp == NULL){
		xlab[0] = '\0';
		xlp = xlab;
	}
	if(ylp == NULL){
		ylab[0] = '\0';
		ylp = ylab;
	}
	if(zlp == NULL){
		zlab[0] = '\0';
		zlp = zlab;
	}
#endif

	if(dev == DevNum(GOV,0) || dev == DevNum(IMAGE,0) ||
	    dev == DevNum(GGOV,0) || dev == DevNum(GIMAGE,0)){
		if(devn){
			devn -= '0';
			if(dev == DevNum(IMAGE,0) || dev == DevNum(GIMAGE,0))
				devn += 1;
		}
		dev |= devn << 3;
	}
	strcpy(buf,"-");
	strcat(buf,siten);
	site(buf);
	fname(stfl);
	if(host || dev == PLOT)
		dev |= 0100;
	if (host)
		plots(dev,blank,host);
	else if (dev == 0100 | PLOT)
		plots(dev,blank,plotstr);
	else
		plots(dev,blank,NULL);
	newpen(pen);
	speed(spd);
/*	plot(xxs*1.25,yys*1.25,-3);		*/
	plot(xxs,yys,-3);

	if(frame ){
		plot(0.00,0.00,3);
		plot(0.00,10.0,2);
		plot(10.0,10.0,2);
		plot(10.0,0.00,2);
		plot(0.05,0.00,2);
	}
  
/*
	plot3d sets up the view angles, and other constants for
	newtru, which does the real ploting

	called with a vector x and y for position and the
	data in the array z.

	Also need xcount, ycount, and zcount

*/
	n1=n-1;

				/* setup constants for 3d plot routine */
	nxx=count[0];
	nyy=count[1];
	nxdim=count[0];

				/* call plotting routine */
	newtru_(zd,xyd,xyd+XYSIZE,&nxx,&nyy,&nxdim,&phi1,&phi2
	,len,len+1,len+2,byte,byte+1,byte+2,dig,dig+1,dig+2,tic,tic+1,tic+2
	,xlp,ylp,zlp,tl,bl,&scfac,&xdir,&ydir,&maxmin[5],&maxmin[4],&umxmn[4]
	,&base,&pxaxis,&pyaxis,&pzaxis,&resol,&prnt);
	plot(0.0,0.0,999);
	exit(0);
}


float	max(x,y)
	float	x,y;
{
	return( (x > y)? x : y);
}

float	min(x,y)
	float	x,y;
{
	return( (x < y)? x : y);
}

matrixinput(name,n,vec)
	char	*name;			/* Name of file */
	int	n;			/* Size of data in file */
	float	*vec;			/* Place to put result */
{
	register int    i,ns, x, y,j;
	float	zmax,zmin;
	FILE    *fd;
	char    buf[sizeof(double)];

	zmax	= HUGE;
	zmin	= -HUGE;
	if( (fd = fopen(name,"r")) == NULL){
		fprintf(stderr,"can't open: %s\n",name);
		exit(1);
	}
	if (n == 7){
		long	SeekTo, numcount;
		float	xtmp;

		numcount = i = 0;
		for (y=0;y<count[1] && !feof(fd);y++){
			SeekTo = ((long)y*(skip[1]+1)+begin[1])*xysize[0]
								+ begin[0];
			while (numcount < SeekTo){
				fscanf(fd,"%f",&xtmp);
				numcount++;
			}
			for (x=0;x<count[0] && !feof(fd);x++){
				fscanf(fd,"%f",&xtmp);
				*vec = xtmp;
				if (reverse)
					*vec *= -1.0;
				if (*vec > zmax)
					*vec = zmax;
				if (*vec < zmin)
					*vec = zmin;
				vec++;
				i++;
				numcount++;
				if( x < count[0]-1 )
					for (j=0;j<skip[0]&&fscanf(fd,"%f"
							,&xtmp)>0;j++)
						numcount++;
			}
		}
	}
	else {
		ns = size[n];
		i = 0;

		for (y=0;y<count[1];y++){
			fseek(fd,(((long)y*(skip[1]+1)+begin[1])*xysize[0]
							+ begin[0])*ns,0);
			for (x=0;x<count[0];x++){
				fread(buf,ns,1,fd);
				if (feof(fd))
					break;
				i++;
				switch(n){

				case 0: /* signed char */
					*vec = *((char *)buf);
					break;
				case 1: /* unsigned char */
					*vec = *((char *)buf) & 0377;
					break;
				case 2: /* short */
					*vec = *((short *)buf);
					break;
				case 3: /* int */
					*vec = *((int *)buf);
					break;
				case 4: /* long */
					*vec = *((long *)buf);
					break;
				case 5: /* float */
					*vec = *((float *)buf);
					break;
				case 6: /* double */
					*vec = *((double *)buf);
					break;
				}
				if (reverse)
					*vec *= -1.0;
				if (*vec > zmax)
					*vec = zmax;
				if (*vec < zmin)
					*vec = zmin;
				vec++;
				fseek(fd,(long)(skip[0]*ns),1);
			}
		}
	}
	if(!i){
		fprintf(stderr,"no points read from input file\n");
		exit(1);
	}
	fclose(fd);
	if (zmax == zmin) {
		printf("plot3d: Entire matrix equals %g.\n",zmax);
		exit(2);
	}
	return(i);
}
 

input(name,n,vec, count, begin, skip)
	char	*name;
	int	n;
	int	count, begin, skip;
	float	*vec;
{
	register int    i,ns;
	FILE    *fd;
	char    buf[sizeof(double)];

	if( (fd = fopen(name,"r")) == NULL){
		fprintf(stderr,"can't open: %s\n",name);
		exit(1);
	}
	if (n == 7){
		int	j;
		float	x;

		i = begin;
		while ( i-- > 0 && fscanf(fd,"%f",&x) > 0);
		i = 0;
		while (i < count && fscanf(fd,"%f",&x) > 0){
			*vec++ = x;
			i++;
			for (j=0;j<skip && fscanf(fd,"%f",&x) > 0;j++);
		}
	}
	else {
		ns = size[n];
		i = 0;
		fseek(fd,(long)(begin * ns),0);
		while(i<count && fread(buf,ns,1,fd)){
			switch(n){

			case 0: /* signed char */
				*vec++ = *((char *)buf);
				break;
			case 1: /* unsigned char */
				*vec++ = *((char *)buf) & 0377;
				break;
			case 2: /* short */
				*vec++ = *((short *)buf);
				break;
			case 3: /* int */
				*vec++ = *((int *)buf);
				break;
			case 4: /* long */
				*vec++ = *((long *)buf);
				break;
			case 5: /* float */
				*vec++ = *((float *)buf);
				break;
			case 6: /* double */
				*vec++ = *((double *)buf);
				break;
			}
			i++;
			fseek(fd,(long)(skip*ns),1);
		}
	}
	fclose(fd);
	if(i == 0){
		fprintf(stderr,"no points read from input file\n");
		exit(1);
	}
	return(i);
}

nbyte(s,n)
	char	*s;
	int	*n;
{
	while(*s)if(*s == ',' && *(s+1)){
		*s++ = 0;
		switch(*s){

		case 'b':       /* char data */
		case 'c':
		case '1':
			if(*++s == 's')*n = 0;
			else *n = 1;
			return;
		case 's':       /* short */
		case '2':
			*n = 2;
			return;
		case 'i':       /* integer */
			*n = 3;
			return;
		case 'l':       /* long */
			*n = 4;
			return;
		case 'f':       /* float */
		case '4':
			*n = 5;
			return;
		case 'd':       /* double */
		case '8':
			*n = 6;
			return;
		case 'a':	/* ASCII */
			*n = 7;
			return;
		default:
			err("byte declaration error","");
		}
	}else{
		s++;
	}
}

err(s1,s2)
	char	*s1,*s2;
{
	fprintf(stderr,"%s%s\n",s1,s2);
	exit(1);
}

comm(s)
	char	*s;
{
	register	int	j,r;
	char    *p;
	struct hash *hp;


	for(hp=table;hp->label;hp++){
		for(j=0;(r=hp->label[j]) == s[j] && r;j++);
		if(r == 0 && s[j] == '=')
			if(!s[j+1] && hp->type != CHAR){
				s[j] = 0;
				err("empty string: ",s);
			}else{
				switch(hp->type){

				case CHAR:
					*hp->pointer = s + j + 1;
					break;
				case INT:
					*((int *)hp->pointer) = atoi(s+j+1);
					break;
				case FLOAT:
					*((float *)hp->pointer) = atof(s+j+1);
					break;
				case LONG:
					*((long *)hp->pointer) = atol(s+j+1);
					break;
				}
				return(hp - table + 1);
			}
	}
	p = s;
	while(*p){
		if(*p == '='){
			*p = 0;
			break;
		}
		p++;
	}
	err("bad option: ",s);
}


parse(argc,argv)
	int	argc;
	char	**argv;
{
	char    c;
	int     i;

	while(argv++ , --argc){
		if(argv[0][0] == '-')while(c = *++*argv)switch(c){

			case '0':	/* device # */
			case '1':
			case '2':
			case '3':	/* Grinnell #'s */
			case '4':
				devn = c;
				break;
			case 'G':	/* Grinnell */
				if (dev == IMAGE || dev == GIMAGE)
					dev = GIMAGE;
				else
					dev = GGOV;
				break;
			case 'd':	/* FOR DEBUGING */
				prnt = 1;
				break;
			case 'D':	/* FOR DEBUGING */
				prnt = 0;
				break;
			/* -z and -Z SHOULD BE REMOVED LATER */
			case 'z':	/* don't plot only the z-axis */
				pzaxis = 0;
				pxaxis = 1;
				pyaxis = 1;
				break;
			case 'Z':	/* plot only the z-axis */
				pzaxis = 1;
				pxaxis = 0;
				pyaxis = 0;
				break;
			case 'a':	/* don't plot any of the axes */
				pxaxis = 0;
				pyaxis = 0;
				pzaxis = 0;
				break;
			case 'A':	/* plot all of the axes */
				pxaxis = 1;
				pyaxis = 1;
				pzaxis = 1;
				break;
			case 'g':	/* use graphics overlay */
				if (dev == GGOV || dev == GIMAGE)
					dev = GGOV;
				else
					dev = GOV;
				break;
			case 'i':	/* use image plane */
				if (dev == GGOV || dev == GIMAGE)
					dev = GIMAGE;
				else
					dev = IMAGE;
				break;
			case 'c':	/* use comtal */
				if (dev == IMAGE || dev == GIMAGE)
					dev = IMAGE;
				else
					dev = GOV;
				break;
			case 's':	/* store xy bnd file */
				savesc = 1;
				break;
			case 'S':	/* don't store xy bnd file */
				savesc = 0;
				break;
			case 'x':	/* use x file  
				use[0] = 1;
				break;
			case 'X':	/* don't use x file  */
				use[0] = 0;
				break;
			case 'y':	/* use y file */
				use[1] = 1;
				break;
			case 'Y':	/* don't use y file */
				use[1] = 0;
				break;
			case 'b':	/* don't blank display */
				blank = 1;
				break;
			case 'B':	/* blank display */
				blank = 0;
				break;
			case 't':	/* use tektronix */
				dev = TEK;
				break;
			case 'T':	/* use Retro-graphics */
				dev = RETRO;
				break;
			case 'h':	/* use hp plotter */
				dev = HP;
				break;
			case 'f':       /* frame plot */
				frame = 1;
				break;
			case 'F':       /* don't frame plot */
				frame = 0;
				break;
			case 'o':       /* g=stdout */
				dev = STDOUT;
				stfl = "-";
				break;
			case 'v':       /* direct versatec mode */
				dev = VERSATEC;
				break;
			case 'P':	/* Use Plot package */
				dev = PLOT;
				break;
			case 'p':       /* direct line printer mode */
				dev = PRINTRONIX;
				break;
			case 'l':	/* prompt for axes labels */
				prmpt = 1;
				break;
			case 'L':	/* Don't prompt for axes labels */
				prmpt = 0;
				break;
			/* THIS SHOULD BE REMOVED SOMETIME LATER */
			case 'k':	/* Don't crosshatch (sic) surface */
				ydir = 1;
				xdir = 0;
				break;
			case 'K':	/* Crosshatch (sic) surface */
				xdir = 1;
				ydir = 1;
				break;
			case 'r':	/* Reverse Plot */
				reverse = 1;
				break;
			case 'R':	/* Do not reverse plot */
				reverse = 0;
				break;
			default:
				fprintf(stderr,"bad flag: -%c\n",c);
				exit(1);
			}
		else
			switch(i = comm(*argv)){

			case 1:	/* x input file name */
				if(*xyf[0] == ',')xyf[0] = "x";
				nbyte(*argv+2,&byte[0]);
				use[0] = 1;
				break;
			case 2:	/* y input file name */
				if(*xyf[1] == ',')xyf[1] = "y";
				nbyte(*argv+2,&byte[1]);
				use[1] = 1;
				break;
			case 3:	/* z input file name */
				if(*zf == ',')zf = "z";
				nbyte(*argv + 2,&byte[2]);
				break;
			case 5:	/* output file name */
				dev = STDOUT;
		 		break;
			case 11:	/* Begin */
				begin[1]=begin[0];
				break;
			case 12:	/* set max or min value */
			case 13:
			case 14:
			case 15:
			case 16:
			case 17:
				umxmn[i-12] = 1;
				break;
			case 25:        /* site */
				dev = PRINTRONIX;
				break;
			case 20:	/* pen */
			case 26:	/* speed */
				dev = HP;
				break;
			case 30:	/* Phi 1 */
				if (phi1 > 90 || phi1 < -90){
					fprintf(stderr,"phi1 must be between -90 and 90 degrees.\n");
					exit(2);
				}
				break;
			case 31:
				if (phi2 > 90 || phi2 < -90){
					fprintf(stderr,"phi2 must be between -90 and 90 degrees.\n");
					exit(2);
				}
				break;
			case 33:	/* len */
				len[1] = len[0];
				len[2] = len[0];
				break;
			case 34:	/* n */
				xysize[1] = xysize[0];
				break;
			case 35:	/* count */
				count[1] = count[0];
				break;
			case 38:	/* skip */
				skip[1] = skip[0];
				break;
			case 41:	/* size */
				xysize[1] = xysize[0];
				break;
			case 44:	/* dig */
				dig[1] = dig[0];
				dig[2] = dig[0];
				break;
			case 48:	/* tic */
				tic[1] = tic[0];
				tic[2] = tic[0];
				break;
			case 57:	/* Look up device name in dev table */
				{ struct devtable *tp;
				for(tp=devtab; tp->devstr; tp++)
					if(strcmp(tp->devstr,devstr) == 0)
						break;
				if(tp->devstr)
					dev = tp->dev;
				else
					err("Unknown device ",devstr);
				}
				break;
			case 58:
				dev = PLOT;
				break;
			}
	}
}

args()
{
	char	*argv[20];
	int	argc;
	char	*s,*getenv(),*p;

	if((s=getenv("PLOT3DARGS")) == NULL)return;

	argv[0] = s;
	argc = 1;
	while(*s){
		while(*s == ' ')*s++ = 0;
		if(*s){
			if(*s != '"')argv[argc++] = s;
			else{
				argv[argc++] = ++s;
				while(*s){
					if(*s != '"')s++;
					else{
						*s++ = 0;
						break;
					}
				}
			}
		}
		while( (*s != ' ')  && *s){
			if(*s != '"')s++;
			else{
				p = s;
				while(*p){
					*p = *(p+1);
					p++;
				}
				while(*s){
					if(*s != '"')s++;
					else{
						*s++ = 0;
						break;
					}
				}
			}
		}
	}
	parse(argc,argv);
}

file()
{
	int	argc;
	char	*argv[20];
	static char buf[256];
	char	*b;
	char	*getenv(),*s;
	FILE	*dfd;

	if((s = getenv("HOME")) == NULL)return;
	strcpy(buf,s);
	strcat(buf,"/.plot3drc");
	if((dfd = fopen(buf,"r")) == NULL)return;
	argc = 1;
	b = buf;
	while(fgets(b,256-((int)(b - buf)),dfd) != NULL){
		b[strlen(b)-1] = 0;
		argv[argc++] = b;
		b += strlen(b)+1;
		if(argc == 20)break;
	}
	parse(argc,argv);
	fclose(dfd);
}

getlab(c,s)
	char	c,*s;
{
	printf("enter %c axis label: ",c);
	fgets(s,MLAB,stdin);
	if(s[strlen(s)-1] == '\n')s[strlen(s)-1] = 0;
}
