c
c
c	newtru - 3 dimentional plotting routine 
c
c	The CRC Graphics Package
c
c	An old routine rewritten by Mani Azimi
c	12/9/83
c
c	This routine has been available for a long period in EE Dept.
c	Malcolm Slaney provided an interface for it (plot3d.c) and 
c	added some options to it. The major modifications were getting 
c	the lines below the horizon to be plotted, drawing axes for all 
c	the three directions and correcting the bugs in the old 
c	routine. For finding about the many options available see the 
c	manual for plot3d.
c
c	
	subroutine newtru(z,x,y,inx,iny,nxdim,aphi1,aphi2
     $		,xlen,ylen,azlen,ixbyte,iybyte,izbyte
     $		,ixdig,iydig,izdig,xtic,ytic,ztic,xlbl,ylbl,zlbl,tl,bl
     $		,scfac,ixdir,iydir,azmax,azmin,izmin,abase,ixaxis,iyaxis,izaxis
     $		,resol,iprnt)
	parameter(maxstp=8000)
	logical xaxs,yaxs,zaxs,abv,blw,xdir,ydir,print
	dimension absx(512),absy(512),xold(512),yold(512)
	dimension above(maxstp),below(maxstp)
	dimension z(nxdim,1),x(1),y(1)
	real xymin(2),xymax(2),tic(3)
	real xcorn(2,2),ycorn(2,2),xcindx(2,2),ycindx(2,2)
	integer ibyte(3),idig(3),ixlbl(3)
	character*80 lbl(3),xlbl,ylbl,zlbl,tl,bl
	common /a/ phi1,phi2,cphi1,sphi1,cphi2,s1s2,c1s2,zfct,absxs
	common /b/ above,below
	common /c/ xymin,xymax,tic,ibyte,idig,ixlbl,base,zbmax,zbmin,pi
	common /d/ zlen,nx,ny,numstp,dlmnsm,dm,dl,small
	common /e/ istrt1,iend1,istep1,istrt2,iend2,istep2
	common /f/ xold,yold,absx,absy
	common /pos/ xpos,ypos
	common /flag/ xaxs,yaxs,zaxs,abv,blw,xdir,ydir,print
c
	print = .false.
	if(iprnt .eq. 1) print = .true.
	nx = inx
	ny = iny
	zlen = 6.0 * azlen / 8.0
	base = abase
	zbmax = azmax
	zbmin = azmin
	phi1 = aphi1
	phi2 = aphi2
	xaxs = .false.
	yaxs = .false.
	zaxs = .false.
	if( ixaxis .eq. 1 ) xaxs = .true.
	if( iyaxis .eq. 1 ) yaxs = .true.
	if( izaxis .eq. 1 ) zaxs = .true.
	xdir = .false.
	ydir = .false.
	if( ixdir .eq. 1 ) xdir = .true.
	if( iydir .eq. 1 ) ydir = .true.
	ibyte(1)	= ixbyte
	ibyte(2)	= iybyte
	ibyte(3)	= izbyte
	tic(1)	= xtic
	tic(2)	= ytic
	tic(3)	= ztic
	idig(1)	= ixdig
	idig(2)	= iydig
	idig(3)	= izdig
	lbl(1)(1:80) = xlbl(1:80)
	lbl(2)(1:80) = ylbl(1:80)
	lbl(3)(1:80) = zlbl(1:80)
c		number of steps for line hiding
	numstp	= ifix(resol*float(maxstp)/4.0)
	do 10 i=1 , 3
		ixlbl(i)	= index(lbl(i),'\0') - 1
10	continue
	ixtl	= index(tl,'\0') - 1
	ixbl	= index(bl,'\0') - 1
	small	= 1.0e-4
	alarge	= 1.0e25
	pi	= 3.1415926535897932384626433
	dm	= 150.0 * resol
	dl	= 1.0 / dm
	dlmnsm	= dl - small
	arg1	= phi1 * pi / 180.0
	arg2	= phi2 * pi / 180.0
	sphi1	= sin(arg1)
	cphi1	= cos(arg1)
	sphi2	= sin(arg2)
	cphi2	= cos(arg2)
	s1s2	= sphi1 * sphi2
	c1s2	= cphi1 * sphi2
c
c   determine min and max values
c
	xymin(1) = x(nx+1)
	xymax(1) = x(nx+2)
	xymin(2) = y(ny+1)
	xymax(2) = y(ny+2)
	do 5 i=1 , 2
	    if ( xymin(i) .ge. xymax(i) ) then
		a      = xymin(i)
		xymin(i)   = xymax(i)
		xymax(i)   = a
	    endif
5	continue
c
c
c		set the distance between the vertical lines in the front panels
c
	idxvrt = nx / 8
	if ( nx .lt. 16 ) idxvrt = 1
	idyvrt = ny / 8 
	if ( ny .lt. 16 ) idyvrt = 1
c
c		select the the coordinates of the front edge depending on
c		the direction of line drawing either (istrt1,istrt2) or
c		(istrt2,istrt1).
c
	istrt1 = 1
	istep1 = 1
	istrt2 = 1
	istep2 = 1
	if( ydir ) then
		if( phi1 .ge. 0.0 ) then
			istrt1 = nx
			iend1  = 1
			istep1 = -1
			iend2 = ny
		else
			iend1  = nx
			iend2 = ny
		endif
	else
		if( phi1 .ge. 0.0 ) then
			iend1 = ny
			istrt2 = nx
			iend2  = 1
			istep2 = -1
		else
			iend1 = ny
			iend2  = nx
		endif
	endif
c
c		set base to the min (max) of the values on the edges
c		depending on whether phi2 is positive (negative)
c
	if( base .gt. alarge ) then
		if( phi2 .ge. 0.0 ) then
			do 60 i=istrt1 , iend1 , istep1
				if( ydir) then
					dumz	= z(i,istrt2)
				else
					dumz	= z(istrt2,i)
				endif
				if( dumz .lt. base ) base = dumz 
60			continue
			do 70 i=istrt2 , iend2 , istep2
				if( ydir ) then
					dumz	= z(istrt1,i)
				else
					dumz	= z(i,istrt1)
				endif
				if( dumz .lt. base ) base = dumz 
70			continue
		else
			base = - base
			do 61 i=istrt1 , iend1 , istep1
				if( ydir ) then
					dumz	= z(i,istrt2)
				else
					dumz	= z(istrt2,i)
				endif
				if( dumz .gt. base ) base = dumz 
61			continue
			do 71 i=istrt2 , iend2 , istep2
				if( ydir ) then
					dumz	= z(i,istrt2)
				else
					dumz	= z(istrt2,i)
				endif
				if( dumz .gt. base ) base = dumz 
71			continue
		endif
	endif
c
c		if no max set, set it to the max of z()
c		if no min set, set it to the min of (min z()) and base
c
	if( izmin .ne. 1) zbmin = amin1(zbmin,base)
c
	shrink = 0.65
	xlen	= xlen * shrink
	ylen	= ylen * shrink
	zlen	= zlen * shrink
c
c		normalize the x and y arrays for plotting
c
	xfct	= xlen / ( xymax(1) - xymin(1) )
	yfct	= ylen / ( xymax(2) - xymin(2) )
	do 20 i=1 , nx
		x(i)	= ( x(i) - xymin(1) ) * xfct
20	continue
	do 30 i=1 , ny
		y(i)	= ( y(i) - xymin(2) ) * yfct
30	continue
	zfct	= zlen / ( zbmax - zbmin )
c
c		setup proper origin on plotting page
c
	dumfct	= cphi2 * zfct
	xadd	= - s1s2 * ( x(nx) - x(1) ) / float(nx-1)
	yadd	=   c1s2 * ( y(ny) - y(1) ) / float(ny-1)
	dzmax	= -1.0e30
	dzmin	= 1.0e30
	dumx	= - x(1) * s1s2 
	do 980 ix=1 , nx
	    dumy	= y(1) * c1s2 
	    do 981 iy=1 , ny
		dum	= dumfct * z(ix,iy) + dumx + dumy
		if( dum .gt. dzmax ) dzmax = dum
		if( dum .lt. dzmin ) dzmin = dum
		dumy	= dumy + yadd
981	    continue
	    dumx	= dumx + xadd
980	continue
	xsize = cphi1 * xlen + abs(sphi1) * ylen
	call factor(scfac)
	call plot( 5.0-xsize/2.0 + 0.35 , 0.0 , -3 )
	height	= 0.2
	call alpha
	if( ixtl .gt. 0 ) then
	    call symbol(xlen*0.66666-(3.0/7.0*float(ixtl)*height), 
     $			9.5-height*0.5,height,tl(1:ixtl),0.0)
	endif
	if( ixbl .gt. 0 ) then
	    call symbol(xlen*0.66666-(3.0/7.0*float(ixbl)*height),
     $			0.85+height*0.5,height,bl(1:ixbl),0.0)
	endif
	call plot( 0.0 , 5.0-(dzmax+dzmin)/2.0+0.5 , -3 )
c	call plot( 5.0-xsize/2.0 + 0.4 , 5.0-(dzmax+dzmin)/2.0+0.5 , -3 )
c
c		absxs is the x coordinate of the origin relative to the 
c		plot coordinates. In this way all the x components are positive.
c
	if( phi1 .ge. 0.0 ) then
		absxs	= 0.0
	else
c		absxs	= sphi1 * y(ny) 
		absxs	= sphi1 * ylen
	endif
c
	do 120 i=1 , numstp
		below(i)  = 20.0
		above(i)  = -20.0
120	continue  
c
c		draw axis and set the boundary of hiding limits.
c
	if( xaxs .or. yaxs .or. zaxs ) call setaxs(xlen,ylen,lbl)
c
c		draw the vertical lines on the front panel 
c		while the lines are plotted (if x-y axes are to be drawn)
c
	if( xaxs .or. yaxs ) then
		xcindx(1,1) = x(1)
		ycindx(1,1) = y(1)
		xcindx(1,2) = x(nx)
		ycindx(1,2) = y(1)
		if( phi1 .ge. 0.0 ) then
			xcindx(2,1) = x(nx)
			xcindx(2,2) = x(nx)
		else
			xcindx(2,1) = x(1)
			xcindx(2,2) = x(1)
		endif
		ycindx(2,1) = y(1)
		ycindx(2,2) = y(ny)
		if( xaxs .or. yaxs .or. zaxs ) then
		    do 90 i=1 , 2
			iflag = 3 
			do 80 j=1 , 2
			    xcorn(i,j) = xcal(xcindx(i,j) , ycindx(i,j)) 
			    ycorn(i,j) = ycal(xcindx(i,j) , ycindx(i,j) , base)
				if( xaxs .or. yaxs ) then
				    if( iflag .eq. 3 ) then
				xpos = xcorn(i,j)
				ypos = ycorn(i,j)
			    else
				call plot(xpos,ypos,3)
				call plot(xcorn(i,j),ycorn(i,j),iflag)
			    endif
			endif
			iflag = 2
80			continue
90	    	continue
		endif
		call panel(x,y,z,nxdim)
	endif
c
c		setup the first row depending on the direction options,
c		either in x direction or y direction. absx and absy are
c		the absolute coordinate sizes for plotting.
c
c
c		main loop
c
	do 500 index1=istrt1 , iend1 , istep1
c
c   		calculate the line coordinates for next row
c		if last row no need for next row calculations
c
	    do 215 i=istrt2 , iend2 , istep2
		if( ydir ) then
		    absx(i) = float( ifix( xcal(x(index1),y(i)) *dm))*dl
		    absy(i) = ycal( x(index1),y(i),z(index1,i) )
		else
		    absx(i) = float( ifix( xcal(x(i),y(index1)) *dm))*dl
		    absy(i) = ycal( x(i),y(index1),z(i,index1) )
		endif
215	    continue
	    if( index1 .ne. istrt1 ) then
	        if( xdir .and. ydir ) then
		    do 230 index2=istrt2 , iend2 , istep2
			call perpen(index2)
230		    continue
		else
		    call perpen(istrt2)
		endif
	    endif
	    x2	= absx(istrt2)
	    y2	= absy(istrt2)
	    m	= x2 * dm + 1.01
c
c		set the line hiding flags for the first point of line.
c
	    abv	= .false.
	    blw	= .false.
	    if( y2 .gt. above(m) ) abv	= .true.
	    if( y2 .lt. below(m) ) blw = .true.
c
c			loop for drawing one complete line  
c
	    do 600 index2=istrt2 , iend2-istep2 , istep2
		x1	= x2
		y1	= y2
		x2	= absx(index2+istep2)
		y2	= absy(index2+istep2)
		if( print ) then
		    if( abv ) write(6,*)"				above"
		    if( blw ) write(6,*)"				below"
		    write(6,*)"-long: x1,y1,x2,y2",x1,y1,x2,y2
		endif
		call draw(x1,y1,x2,y2)
600	    continue
	    if( index1 .ne. istrt1 .and. .not. (xdir .and. ydir) ) then
		call perpen(iend2)
	    endif
c
c			store the line just drawn
c
	    do 210 i=istrt2 , iend2 , istep2
		xold(i) = absx(i)
		yold(i) = absy(i)
210	    continue
c
c		end of main loop
c
500	continue
	return
	end
