#include	"crc.h"

/*
	draxis - draw numerically annotated axes for slant axes

	The CRC graphics package

	carl crawford
	purdue univeristy
	w. lafayette, in 47907

	may 1980
*/
#define	PI	3.141592
#define SMALL	0.000001

draxis(x,y,label,angle,xy,size,xmin,xmax,idata)
/*		xy	=	1	clockwise
			=	-1	counter clockwise */
float	x,y,angle,size,xmin,xmax;
int	xy,idata;
char	*label;
{
	float	xt,yt,half,dumang,sang,cang;
	float	height,del,delx,dely,dticx,dticy;
	int	numt,i,j;
	int     n1,n2,fl,atic;
	char	*b,*c;

	angle = angle*PI/180.0;
	sang = sin(angle);
	cang = cos(angle);
	atic = 1;
	plot(x,y,3);
	height = HEIGHT;
	plot(x+size*cang,y+size*sang,2);
	if(TICDIS == 0.0)_err("axis error: ","ticdis zero");
	numt = floor(size/TICDIS+.5); 
	if(!numt) 
		numt = -1;
	plot(x,y,3);
	xt = x;	
	yt = y;
	dticx = 0.075*atic*cos(angle-xy*PI/2.0);
	dticy = 0.075*atic*sin(angle-xy*PI/2.0);
	del =  ( xmax - xmin ) / numt;
	delx = size*cang/numt;
	dely = size*sang/numt;
	numt++;
	for(i = 0;i<numt;i++){
		plot(xt+dticx,yt+dticy,2);
		xt += delx;
		yt += dely;
		plot(xt,yt,3);
	}
	if(idata >= 0)n1 = _axisl(xmin,xmax,idata,1);

	c = label;
	b = _abuf;
#ifdef sel
	strncpy(b, c, sizeof(_abuf));
	while(*b++ != NULL);
#else
	while(*b++ = *c++);
#endif
	if(n1 && idata >= 0){
		--b;
		*b++ = ' ';
		*b++ = '(';
		*b++ = 'X';
		*b++ = '1';
		*b++ = '0';
		*b++ = '$';
		*b++ = '{';
		if(n1 < 0){
			*b++ = '-';
			n1 = -n1;
		}
		if(n1 > 9){
			*b++ = '0' + (n1/10);
			n2 = n1/10;
			n1 -= n2*10;
		}
		*b++ = '0' + n1;
		*b++ = '$';
		*b++ = '}';
		*b++ = ')';
		*b = 0;
	}
	half = 6.0/7.0 * _ssize(_abuf) / 2.0 * height;
	dticx = 1.1*atic*cos(angle-xy*PI/2.0) + ( size/2.0-half ) * cang;
	dticy = 1.1*atic*sin(angle-xy*PI/2.0) + ( size/2.0-half ) * sang;
	if( fabs(angle-PI/2) < SMALL )
		symbol(x+(xy*atic * 1.2),y+(size/2.0) - half,height,_abuf,90.0);
	else if( fabs(angle) < SMALL ) 
		symbol(x+(size/2.0)-half,y-(xy*atic * .75),height,_abuf,0.0);
	else if( fabs(angle) <= PI/2.0 ){ 
	  symbol(x+dticx,y+dticy,height,_abuf,angle*180.0/PI);
	}
	else{ 
	  dumang = angle - PI;
	  if( dumang < -PI)
		dumang += 2.0*PI;
	  dticx += 2.0 * half * cang;
	  dticy += 2.0 * half * sang;
	  symbol(x+dticx,y+dticy,height,_abuf,dumang*180.0/PI);
	}
	if( idata < 0)return;
	height *= 2.8/4.0;
	plot(x,y,3);
	xt = x;	
	yt = y;
	for(i = 0; i <numt; i++){
	    half = height * (6.0/7.0) * _axisl(xmin,del,idata,0);
	    if( fabs(angle-PI/2) < SMALL )
		symbol(xt+xy*atic*(((xy<0)*half)+0.145),yt -(height/2.0),height,_abuf,0.0);
	    else if( fabs(angle) < SMALL ) 
		symbol(xt-(half/2.0),yt-(xy*atic*(0.145 + height)),height,_abuf,0.0);
	    else if( xy*angle > SMALL ) 
		symbol(xt+0.6*height+height*fabs(cang),yt-1.5*xy*height*cang,height,_abuf,0.0);
	    else 
		symbol(xt-0.6*height-height*fabs(cang)-half,yt-xy*height*cang,height,_abuf,0.0);
	    xmin += del;
	    xt += delx;
	    yt += dely;
	}
}

_axisl(a,b,iflag,opt)
float	a,b;
int	iflag,opt;
{
	double	d;
	double c;
	int	minus,dc,si,i;
	static	int	n,efl;
	int	n1,n2,n3;
	char	*ecvt(),*bu,*bb;

	if(opt){
		c = b - a;
		ecvt(fabs(a),DIGITS,&n1,&si);
		ecvt(fabs(b),DIGITS,&n2,&si);
		ecvt(fabs(c),DIGITS,&n3,&si);
		if(iabs(n1-n2) <= 1) n = (n1 > n2)? n1 : n2;
		else	if(iabs(n1-n3) <= 1) n = n3;
		else	if(iabs(n2-n3) <= 1) n = n2;
		efl = 0;
		if(n <= -2 || n >= (DIGITS + iflag)){
			efl = 1;
		}
		return(efl ? n-1 : 0);
	}
	else{
		if(iflag)d = floor(a + 0.5);
		else	d = a;
		minus = 0;
		if(d < 0){
			d = -d;
			minus = 1;
		}
		bu = ecvt(d,DIGITS,&dc,&si);
		if(d == 0.0)dc++;
		if(efl)dc -= n - 1;
		if(iflag && efl == 0){
			bu[dc] = 0;
			bb = _abuf;
			if(minus)*bb++ = '-';
			while( *bb++ = *bu++);
		}
		else{
			bb = _abuf;
			if(minus)*bb++ = '-';
			if(dc <= 0){
				*bb++ = '.';
				while(dc++)*bb++ = '0';
				while(*bb++ = *bu++);
				_abuf[DIGITS+1+minus] = 0;
			}
			else{
				while(dc--)*bb++ = *bu++;
				*bb++ = '.';
				while(*bb++ = *bu++);
			}
		}
		return(_ssize(_abuf));
	}
}

iabs(i)
int	i;
{
	return((i>0)? i : -i);
}
