#
/*
	crc.h - include file for the CRC graphics package

	Carl Crawford
	Purdue University
	W. Lafayette, IN 47907

	Jan. 1981
*/

#include <stdio.h>
#include <math.h>
#include <signal.h>

unsigned short *_pic;   /* pointer to bit plane */
int     _xp,_yp;        /* integer position */
float   _axp,_ayp;      /* real position */
float   _xo,_yo;        /* current origin */
int     _ud;            /* indicates up/down for pen */
int     _error;         /* indicates error in plotting */
float	_fac;		/* scale factor */
float	_ipsz;		/* size of the internal file - 1 */
float	_ipsz10;	/* ipsize / 10.0 */
int     DEV;            /* major device number */
char    DEVN;           /* minor device number */
int	BLANK;		/* 1 = don't blank device before plotting */
char	*STORE;		/* default storage file */
char	*PLOTFILT;	/* Plot Filter Name */
float	TICDIS;		/* distance between tic marks on the axis */
float	HEIGHT;		/* char height in axis routines */
int	DIGITS;		/* number of dec. digits + 1 in axis annotation */
unsigned _bufsize;	/* size of point buffer */
char	_abuf[100];	/* char buffer for anyone */
char	*SITE;		/* site for gplp */ 
FILE	*_pipe_fd;	/* file descriptor for pipes and pseudo pipes */
int	(*_isig)();	/* save SIGINT signal */
int	(*_qsig)();	/* save SIGQUIT signal */
int	(*_hsig)();	/* save SIGHUP signal */
int	_intty[3];	/* save current tty modes in here */

/*	control characters */

#define	NUL 0		/* <nul> */
#define	SOH 1		/* <soh> */
#define	STX 2		/* <stx> */
#define	ETC 3		/* <etc> */
#define ETX 3           /* <etx> */
#define EOT 4           /* <eot> */
#define ENQ 5           /* <enq> */
#define ACK 6		/* <ack> */
#define BEL 7		/* <bel> */
#define BS 8            /* <bs> */
#define HT 9		/* <ht> */
#define LF 10           /* <lf> */
#define VT 11           /* <vt> */
#define FF 12           /* <ff> */
#define CR 13           /* <cr> */
#define SO 14           /* <so> */
#define SI 15           /* <si> */
#define DLE 16		/* <dle> */
#define DC1 17		/* <dc1> */
#define DC2 18		/* <dc2> */
#define DC3 19		/* <dc3> */
#define DC4 20		/* <dc4> */
#define NAK 21		/* <nak> */
#define	SYN 22		/* <syn> */
#define ETB 23          /* <etb> */
#define CAN 24		/* <can> */
#define EM 25		/* <em> */
#define SUB 26          /* <sub> */
#define ESC 27          /* <esc> */
#define	FS 28		/* <fs> */
#define GS 29           /* <gs> */
#define RS 30           /* <rs> */
#define US 31           /* <us> */



/*      variables for HP and TEK */

int _CM;	/* current mode */
int _X;		/* x position */
int _Y;		/* y position */
int _FILL;	/* number of fill characters */

#define	BINARY_FONT_FILE	"/usr/lib/graphics/font.5x7
#define	PLOTBIN			"/usr/bin/plot"

#define	BIT	0	/* major device table */
#define GOV	1
#define IMAGE	2
#define	GGOV	3
#define	GIMAGE	4
#define	PLOT	5
#define	TEK	6
#define HP	7

#define MBIT	4
/* maximum device in bit plane mode */

/*
	Major and minor device tables

	DEV     DEVN    dev     OUTPUT
	0       0       0       file or standard output
		1       8       Versatec through gp (I)
		2       16      Printronix through gplp (I) and opr (I)

	1       0       1       Comtal graphics overlay 0(*)
		1       9       Comtal graphics overlay 1(*)
		2       17      Comtal graphics overlay 2(*)


	2       0       2       Comtal image image displayed(*)
		1       10      Comtal image 0(*)
		2       18      Comtal image 1(*)
		3       26      Comtal image 2(*)

	3       0       3       Grinnell graphics overlay 0(*)
		1       11      Grinnell graphics overlay 1(*)
		2       19      Grinnell graphics overlay 2(*)
		3       27      Grinnell graphics overlay 3(*)

	4       0       4       Grinnell Image being Displayed (*)
		1       12      Grinnell Image Plane 0(*)
		2       20      Grinnell Image Plane 1(*)
		3       28      Grinnell Image Plane 2(*)
		4       36      Grinnell Image Plane 3(*)
		5       44      Grinnell Image Plane 4(*)

	5	0	5	Plot Subroutines

	6       0       6       Tektronix through standard output
		1	14	Retro-Graphics through standard output
		2	22	Tektronix 4113

	7       0       7       HP through /u/lib/graphics/hpd

(*) - through /u/lib/graphics/gd

*/
